/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="RETURN")
public class BeforeReturn
extends InjectionPoint {
    private final int ordinal;
    private static final NMSLException \u628a\u597d\u6d88\u606f\u5e26\u7ed9\u5168\u57ce\u5427 = new NMSLException("\u4dc9\u4dfe\ua66f\u4df8\u4dda\u4df5\u4de3\u4dff\u4ded\u4dce\u450f\u4dd8\u4dfa\u273b\u4de9\u4dfb\u4375\u4dee\u27a4\u4dea\u26a7\u4df6\ua681\u4dfa\u4437\u27a3\u3764\u4dcf\u260c\u4c37\u2613\u4de2\u4dcf\u2637\u4dd0\u26ab\u4de0");

    @Override
    public boolean checkPriority(int targetPriority, int ownerPriority) {
        return true;
    }

    public BeforeReturn(InjectionPointData data) {
        super(data);
        this.ordinal = data.getOrdinal();
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int returnOpcode = Type.getReturnType(desc).getOpcode(172);
        int ordinal = 0;
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (!(insn instanceof InsnNode) || insn.getOpcode() != returnOpcode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }
}

