/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;
    private static final NMSLException \u522e\u8d77\u5927\u98ce\u7684\u65f6\u5019 = new NMSLException("\u4df5\u4dca\u4df8\u26f6\u4ddb\u27af\ua675\u4de5\u2756\u2746\ua66c\u4a13\u26bb\u4dcd\u4858\u4dcf\u4dca\u2689\u2722\u4de1\u4de4\ua640\u271a\u266c\ua65d\u4dc4\u4dfd\u4dc0\u26b2\u4dd6\u2625\u2685\ua65b\u4de5\u2744\u3e59\u26fc\u4dd1\ua672\u4dcd\u4dd2\u4dfb\u4de3\u2678\u4df6\ua67f");

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private Map<String, Object> decorations;
        private final AbstractInsnNode originalTarget;
        private static int nextId;
        private final int id;
        private AbstractInsnNode currentTarget;
        private static final NMSLException \u660e\u5929\u7684\u660e\u5929\u89c1\u5566;

        static {
            \u660e\u5929\u7684\u660e\u5929\u89c1\u5566 = new NMSLException("\u3559\u4dd3\u4dc1\u4dff\ua67d\u260d\u3e0b\ua686\u4dde\u4de9\u26f7\u4dcc\u4dfb\u2739\u2710\u4de8\u26b1\u4df5\u4987\u483f\u4dc7\ua643\u4dc4\u4344\u4dfe\u4de6\u27b0\u4dc0\u4df6\ua651\u4de3\ua689\u4dfa\u49f9\u4de4\u43b0\u4de0\u4ded");
            nextId = 0;
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }
    }
}

