/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorGroupInfo {
    private int maxCallbackCount;
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private int minCallbackCount = -1;
    private final boolean isDefault;
    private final String name;
    private static final NMSLException \u53cd\u800c\u8fd8\u6709\u70b9\u4e0d\u4e60\u60ef = new NMSLException("\u26b2\u4dcc\u2669\u267a\u3fbb\u44cc\u46ca\u4dc1\u271b\ua69d\u26d7\u4df4\u4df2\u4dc7\u4dd8\u3d8e\ua694\u4df3\ua68a\u48a2\u2751\ua679\u4df3\u4df2\u3d1a\u4df4\u4df9\u4de8\ua652\ua685\u4dfc\u4dd3");

    public void setMaxAllowed(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group max count. Attempted to set max=" + max + " on " + this);
        }
        if (this.maxCallbackCount < Integer.MAX_VALUE && this.maxCallbackCount != max) {
            LogManager.getLogger((String)"mixin").warn("Conflicting max value '{}' on @Group({}), previously specified {}", new Object[]{max, this.name, this.maxCallbackCount});
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, max);
    }

    public InjectorGroupInfo add(InjectionInfo member) {
        this.members.add(member);
        return this;
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, Integer.MAX_VALUE);
    }

    public InjectorGroupInfo(String name) {
        this(name, false);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("@Group(name=%s, min=%d, max=%d)", this.getName(), this.getMinRequired(), this.getMaxAllowed());
    }

    InjectorGroupInfo(String name, boolean flag) {
        this.maxCallbackCount = Integer.MAX_VALUE;
        this.name = name;
        this.isDefault = flag;
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setMinRequired(int min) {
        if (min < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group min count. Attempted to set min=" + min + " on " + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != min) {
            LogManager.getLogger((String)"mixin").warn("Conflicting min value '{}' on @Group({}), previously specified {}", new Object[]{min, this.name, this.minCallbackCount});
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, min);
    }

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 1);
    }

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int total = 0;
        for (InjectionInfo member : this.members) {
            total += member.getInjectedCallbackCount();
        }
        int min = this.getMinRequired();
        int max = this.getMaxAllowed();
        if (total < min) {
            throw new InjectionValidationException(this, String.format("expected %d invocation(s) but only %d succeeded", min, total));
        }
        if (total > max) {
            throw new InjectionValidationException(this, String.format("maximum of %d invocation(s) allowed but %d succeeded", max, total));
        }
        return this;
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final long serialVersionUID = 1L;
        private static final InjectorGroupInfo NO_GROUP;
        private static final NMSLException \u4eba\u591a\u529b\u91cf\u5927;

        public InjectorGroupInfo forName(String name) {
            InjectorGroupInfo value = (InjectorGroupInfo)super.get(name);
            if (value == null) {
                value = new InjectorGroupInfo(name);
                this.put(name, value);
            }
            return value;
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo group : this.values()) {
                group.validate();
            }
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotation, String defaultGroup) {
            Integer max;
            if (annotation == null) {
                return NO_GROUP;
            }
            String name = (String)Annotations.getValue(annotation, "name");
            if (name == null || name.isEmpty()) {
                name = defaultGroup;
            }
            InjectorGroupInfo groupInfo = this.forName(name);
            Integer min = (Integer)Annotations.getValue(annotation, "min");
            if (min != null && min != -1) {
                groupInfo.setMinRequired(min);
            }
            if ((max = (Integer)Annotations.getValue(annotation, "max")) != null && max != -1) {
                groupInfo.setMaxAllowed(max);
            }
            return groupInfo;
        }

        @Override
        public InjectorGroupInfo get(Object key) {
            return this.forName(key.toString());
        }

        public InjectorGroupInfo parseGroup(MethodNode method, String defaultGroup) {
            return this.parseGroup(Annotations.getInvisible(method, Group.class), defaultGroup);
        }

        static {
            \u4eba\u591a\u529b\u91cf\u5927 = new NMSLException("\u42fb\u4dcd\u3a86\u4de5\u41b9\u4dee\u27ae\u27bc\u276f\u4ddc\ua660\ua678\ua68d\u4bd3\u26d4\u273c\u4de0\u275c\u4df9\u4dd5\u3939\u4df5\ua657\ua665\u271a\u2770\u4dee\u4dc4\ua68b\ua67b\u4deb\u4df2\u4ddb\u2688");
            NO_GROUP = new InjectorGroupInfo("NONE", true);
        }
    }
}

