/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import pers.XiaoShadiao.NMSLException;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS;
    private static final NMSLException \u8981\u6765\u4e86\u4e48;

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty((String)id);
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getContext(), at, returnType.getDescriptor()));
        }
    }

    static {
        \u8981\u6765\u4e86\u4e48 = new NMSLException("\u3865\u2602\u4dc2\u44d1\u4de7\u405c\ua68d\u4de1\u4de2\u4dda\u4df2\u4dc7\u4dd4\u4df1\u4df0\u4df6\u2778\u4de7\u4dde\u3aa1\u4a2a\u4dc9\u4dc8\u4ded\u4dfe\u270e\u2736\u264c\u4dd3\u26b5\u4de1\u4dc1\u4df3");
        CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        ImmutableList ats = super.readInjectionPoints(type);
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of((Object)c);
        }
        return ats;
    }
}

