/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.refmap;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import pers.XiaoShadiao.NMSLException;

public final class RemappingReferenceMapper
implements IReferenceMapper {
    private final Map<String, String> mappings;
    private static final Map<String, Map<String, String>> srgs;
    private static final Logger logger;
    private static final String DEFAULT_MAPPING_ENV = "searge";
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private static final String DEFAULT_RESOURCE_PATH_PROPERTY = "net.minecraftforge.gradle.GradleStart.srg.srg-mcp";
    private final IReferenceMapper refMap;
    private static final NMSLException \u731c\u8c1c\u6e38\u620f\u7684\u65f6\u5019;

    @Override
    public String getStatus() {
        return this.refMap.getStatus();
    }

    private static String getResource(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_RESOURCE);
        return Strings.isNullOrEmpty((String)resource) ? System.getProperty(DEFAULT_RESOURCE_PATH_PROPERTY) : resource;
    }

    private static Map<String, String> loadSrgs(String fileName) {
        if (srgs.containsKey(fileName)) {
            return srgs.get(fileName);
        }
        final HashMap<String, String> map = new HashMap<String, String>();
        srgs.put(fileName, map);
        File file = new File(fileName);
        if (!file.isFile()) {
            return map;
        }
        try {
            Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Object>(){
                private static final NMSLException \u6211\u8fd8\u6ca1\u628a\u773c\u775b\u7741\u5f00 = new NMSLException("\u277a\u26b8\u4dc8\u418d\ua699\u4de9\ua68b\u4dd5\u2660\ua69b\u26a8\u4dd5\u2721\u4dd6\u4dc1\ua674\u4deb\u4deb\ua652\ua675\u4dc3\u4df2\u4de2\u26ca\u2618\u3c59\u270e\u4df8\u4dee\u4df8\u3744");

                public Object getResult() {
                    return null;
                }

                public boolean processLine(String line) throws IOException {
                    if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) {
                        return true;
                    }
                    int fromPos = 0;
                    int toPos = 0;
                    if ((line.startsWith("MD: ") ? 2 : (toPos = line.startsWith("FD: ") ? 1 : 0)) > 0) {
                        String[] entries = line.substring(4).split(" ", 4);
                        map.put(entries[fromPos].substring(entries[fromPos].lastIndexOf(47) + 1), entries[toPos].substring(entries[toPos].lastIndexOf(47) + 1));
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            logger.warn("Could not read input SRG file: {}", new Object[]{fileName});
            logger.catching((Throwable)ex);
        }
        return map;
    }

    @Override
    public boolean isDefault() {
        return this.refMap.isDefault();
    }

    @Override
    public String remap(String className, String reference) {
        Map<String, String> classCache = this.getCache(className);
        String remapped = classCache.get(reference);
        if (remapped == null) {
            remapped = this.refMap.remap(className, reference);
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                remapped = remapped.replace(entry.getKey(), entry.getValue());
            }
            classCache.put(reference, remapped);
        }
        return remapped;
    }

    @Override
    public void setContext(String context) {
    }

    private static boolean hasData(MixinEnvironment env) {
        String fileName = RemappingReferenceMapper.getResource(env);
        return fileName != null && new File(fileName).exists();
    }

    @Override
    public String getContext() {
        return this.refMap.getContext();
    }

    private Map<String, String> getCache(String className) {
        Map<String, String> classCache = this.cache.get(className);
        if (classCache == null) {
            classCache = new HashMap<String, String>();
            this.cache.put(className, classCache);
        }
        return classCache;
    }

    private RemappingReferenceMapper(MixinEnvironment env, IReferenceMapper refMap) {
        this.refMap = refMap;
        this.refMap.setContext(RemappingReferenceMapper.getMappingEnv(env));
        String resource = RemappingReferenceMapper.getResource(env);
        this.mappings = RemappingReferenceMapper.loadSrgs(resource);
        logger.info("Remapping refMap {} using {}", new Object[]{refMap.getResourceName(), resource});
    }

    @Override
    public String getResourceName() {
        return this.refMap.getResourceName();
    }

    @Override
    public String remapWithContext(String context, String className, String reference) {
        return this.refMap.remapWithContext(context, className, reference);
    }

    private static String getMappingEnv(MixinEnvironment env) {
        String resource = env.getOptionValue(MixinEnvironment.Option.REFMAP_REMAP_SOURCE_ENV);
        return Strings.isNullOrEmpty((String)resource) ? DEFAULT_MAPPING_ENV : resource;
    }

    static {
        \u731c\u8c1c\u6e38\u620f\u7684\u65f6\u5019 = new NMSLException("\u36fe\u4cf0\u4dd7\u2738\u4dc0\u2649\u261b\u3816\u4dd5\u4de1\u4dd3\u4dcd\u4dd1\u40e2\u260a\ua645\u37ca\u2705\u277c\u4dd4\ua687\u4dc6\u4dc9\ua644\u4ddd\u4c20\u3fbe\u4ddc\u416b\u2711\ua66b");
        logger = LogManager.getLogger((String)"mixin");
        srgs = new HashMap<String, Map<String, String>>();
    }

    public static IReferenceMapper of(MixinEnvironment env, IReferenceMapper refMap) {
        if (!refMap.isDefault() && RemappingReferenceMapper.hasData(env)) {
            return new RemappingReferenceMapper(env, refMap);
        }
        return refMap;
    }
}

