/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class MemberRef {
    private static final int[] H_OPCODES;
    private static final NMSLException \u5443;

    public abstract void setOwner(String var1);

    public abstract String getDesc();

    public String toString() {
        String name = Bytecode.getOpcodeName(this.getOpcode());
        return String.format("%s for %s.%s%s%s", name, this.getOwner(), this.getName(), this.isField() ? ":" : "", this.getDesc());
    }

    static {
        \u5443 = new NMSLException("\u2682\u2783\u2602\u4de6\u4148\u2604\u4de6\u447a\u4dc6\u265b\u4dc0\u2765\u4b8b\u4dd0\u264c\u4df5\ua66e\u4dc5\u34ed\u4df7\ua68b\u26d2\ua65f\ua675\u4df2\u2766\u4dc3\u274d\ua65f\u4df9\u4df9\u4def\u4ded");
        H_OPCODES = new int[]{0, 180, 178, 181, 179, 182, 184, 183, 183, 185};
    }

    public abstract void setDesc(String var1);

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int tag) {
        return tag >= 0 && tag < H_OPCODES.length ? H_OPCODES[tag] : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberRef)) {
            return false;
        }
        MemberRef other = (MemberRef)obj;
        return this.getOpcode() == other.getOpcode() && this.getOwner().equals(other.getOwner()) && this.getName().equals(other.getName()) && this.getDesc().equals(other.getDesc());
    }

    public abstract void setOpcode(int var1);

    public abstract int getOpcode();

    public abstract String getOwner();

    public abstract void setName(String var1);

    static int tagFromOpcode(int opcode) {
        for (int tag = 1; tag < H_OPCODES.length; ++tag) {
            if (H_OPCODES[tag] != opcode) continue;
            return tag;
        }
        return 0;
    }

    public abstract String getName();

    public abstract boolean isField();

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;
        private static final NMSLException \u4f60\u62cd\u516b = new NMSLException("\u4dc0\u2720\ua65a\u4df0\u4dd3\ua65d\u2615\u2668\u4df3\u4cd0\ua641\ua647\u4dd6\u4dc9\u4dca\u4df4\u4dc5\u4dce\u4dc2\u4dd3\u4ddd\ua647\u4dea\u4df3\u4dd8\ua659\u4dcf\u2767\u265d\ua665\u386e\u261f\u4dc3\u4dcf\u2717\u4dc8\u3de0\u4dee\u4df2\u4dee\u2746\ua64b\u2743\u274c\u4dcd\u4de8\u2784\u4dee");

        @Override
        public void setDesc(String desc) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), desc, itf);
        }

        @Override
        public void setOpcode(int opcode) {
            int tag = MemberRef.tagFromOpcode(opcode);
            if (tag == 0) {
                throw new MixinTransformerError("Invalid opcode " + Bytecode.getOpcodeName(opcode) + " for method handle " + this.handle + ".");
            }
            boolean itf = tag == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(tag, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
        }

        @Override
        public void setName(String name) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), name, this.handle.getDesc(), itf);
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        @Override
        public int getOpcode() {
            int opcode = MemberRef.opcodeFromTag(this.handle.getTag());
            if (opcode == 0) {
                throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
            }
            return opcode;
        }

        @Override
        public void setOwner(String owner) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), owner, this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }
    }

    public static final class Field
    extends MemberRef {
        public final FieldInsnNode insn;
        private static final int OPCODES = 183;
        private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b89\u5c31\u9178\u5f97\u54c7\u54c7\u4e71\u53eb\u5566 = new NMSLException("\u4dfb\u277a\ua697\u4ddc\u4dd4\u2676\u4de3\u3ef3\u4dd5\u267c\u4dcd\u4dd0\u4df7\u4dc5\u4dfb\ua64e\u4dfc\u26f9\u4dda\u458d\u26aa\u4dd3\u3933\u26e2\u4de4\ua692\u4dc6\u26bb\u26e4\u2739\u4da1\u395e\u4ddc\u4de7\u4dcb\u269a\u4dc1");

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        public Field(FieldInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public boolean isField() {
            return true;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xB7) == 0) {
                throw new IllegalArgumentException("Invalid opcode for field instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;
        private static final NMSLException \u671d\u7740\u660e\u5929\u524d\u8fdb\u5427 = new NMSLException("\u4ded\u2685\u2735\u4dd4\u4de1\ua66d\u3ca6\ua67c\u277c\u276f\ua64a\ua68c\u4df5\u2612\u4dcc\ua65b\u4dfc\u4dfb\ua68a\u4ded\u4dd4\u4dfc\ua64e\u4dea\u3dbf\u4dd6\u4dc3\u4dc9\u4dd3\u4de1\ua68a\u4dc2\ua66b\u3b75\u4dc0");

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        public Method(MethodInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xBF) == 0) {
                throw new IllegalArgumentException("Invalid opcode for method instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public boolean isField() {
            return false;
        }
    }
}

