/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class SourceMap {
    private static final String NEWLINE = "\n";
    private final String sourceFile;
    private int nextLineOffset = 1;
    private final Map<String, Stratum> strata = new LinkedHashMap<String, Stratum>();
    private String defaultStratum = "Mixin";
    private static final String DEFAULT_STRATUM = "Mixin";
    private static final NMSLException \u51fa\u53d1\u54af = new NMSLException("\u4dc1\u4dca\u4b0e\ua66f\u471c\u264a\u4ddb\u4dd3\u275c\u4dfd\u4dda\u4dc9\u262f\ua695\u412c\u4ddc\u4dc6\u4dec\u4de8\u4dd1\ua664\ua646\u2770\u2739\ua68d\u4dfa\u4dc0\u3c1a\u4df1\u4df0\u4dc3\ua658\u3f32\ua669\u2652\u4df4\u4deb\u4deb\u26ef\u4de3\ua692");

    public File addFile(String stratumName, ClassNode classNode) {
        return this.addFile(stratumName, classNode.sourceFile, classNode.name + ".java", Bytecode.getMaxLineNumber(classNode, 500, 50));
    }

    public SourceMap(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File addFile(String sourceFileName, String sourceFilePath, int size) {
        return this.addFile(this.defaultStratum, sourceFileName, sourceFilePath, size);
    }

    public File addFile(String stratumName, String sourceFileName, String sourceFilePath, int size) {
        Stratum stratum = this.strata.get(stratumName);
        if (stratum == null) {
            stratum = new Stratum(stratumName);
            this.strata.put(stratumName, stratum);
        }
        File file = stratum.addFile(this.nextLineOffset, size, sourceFileName, sourceFilePath);
        this.nextLineOffset += size;
        return file;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    private void appendTo(StringBuilder sb) {
        sb.append("SMAP").append(NEWLINE);
        sb.append(this.getSourceFile()).append(NEWLINE);
        sb.append(this.defaultStratum).append(NEWLINE);
        for (Stratum stratum : this.strata.values()) {
            stratum.appendTo(sb);
        }
        sb.append("*E").append(NEWLINE);
    }

    public File addFile(ClassNode classNode) {
        return this.addFile(this.defaultStratum, classNode);
    }

    public String getPseudoGeneratedSourceFile() {
        return this.sourceFile.replace(".java", "$mixin.java");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    static class Stratum {
        private final Map<String, File> files = new LinkedHashMap<String, File>();
        private static final String LINES_MARK = "*L";
        public final String name;
        private static final String FILE_MARK = "*F";
        private static final String STRATUM_MARK = "*S";
        private static final NMSLException \u68a6\u91cc = new NMSLException("\u4421\ua642\u4dd5\u4dd4\u2686\u268e\u385b\u4dee\u4dc2\u2719\u4dc8\ua668\u26d4\ua689\u4dc8\u4ddc\u4dda\u2788\u4ded\u4df4\ua67a\u27a7\u4ded\u4958\u4dd6\u4ddc\u2635\u4dfa\u4dc5\u27af\u4d9f\u4dbb\u4ddd\ua65b\u4dd4\u4dd2\u4dfd\u4dc4\u270c\u27ae\u2735\u4aa4\u2728\u4266\ua643");

        public Stratum(String name) {
            this.name = name;
        }

        public File addFile(int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            File file = this.files.get(sourceFilePath);
            if (file == null) {
                file = new File(this.files.size() + 1, lineOffset, size, sourceFileName, sourceFilePath);
                this.files.put(sourceFilePath, file);
            }
            return file;
        }

        void appendTo(StringBuilder sb) {
            sb.append(STRATUM_MARK).append(" ").append(this.name).append(SourceMap.NEWLINE);
            sb.append(FILE_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendFile(sb);
            }
            sb.append(LINES_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendLines(sb);
            }
        }
    }

    public static class File {
        public final String sourceFileName;
        public final int size;
        public final int lineOffset;
        public final String sourceFilePath;
        public final int id;
        private static final NMSLException \u628a\u7f07\u5b9d\u7684\u8111\u888b\u90fd\u542c\u5927\u4e86 = new NMSLException("\u274c\u2796\u263a\u4de4\u4dc2\u2606\u4dc7\u2725\u26d2\ua667\u4def\u4df9\ua64a\u4df3\ua69d\u2710\u4dce\u4dd2\u4dc9\u4dfe\u4dd7\u3bb5\u4dd4\u4df3\ua689\u4de4\u3fd2\u4dea\u4929\u3ee1\u40c0\u4dc1\u3a2e\u361b\u4dc8");

        public void applyOffset(MethodNode method) {
            ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iter.next();
                if (!(node instanceof LineNumberNode)) continue;
                ((LineNumberNode)node).line += this.lineOffset - 1;
            }
        }

        public File(int id, int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            this.id = id;
            this.lineOffset = lineOffset;
            this.size = size;
            this.sourceFileName = sourceFileName;
            this.sourceFilePath = sourceFilePath;
        }

        public void appendLines(StringBuilder sb) {
            sb.append("1#").append(this.id).append(",").append(this.size).append(":").append(this.lineOffset).append(SourceMap.NEWLINE);
        }

        void appendFile(StringBuilder sb) {
            if (this.sourceFilePath != null) {
                sb.append("+ ").append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
                sb.append(this.sourceFilePath).append(SourceMap.NEWLINE);
            } else {
                sb.append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
            }
        }

        public File(int id, int lineOffset, int size, String sourceFileName) {
            this(id, lineOffset, size, sourceFileName, null);
        }

        public void applyOffset(ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                this.applyOffset(method);
            }
        }
    }
}

