/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.commons.ClassRemapper;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.MixinClassWriter;
import pers.XiaoShadiao.NMSLException;

final class InnerClassGenerator
implements IClassGenerator {
    private static final Logger logger;
    private final Map<String, InnerClassInfo> innerClasses;
    private final Map<String, String> innerClassNames = new HashMap<String, String>();
    private static final NMSLException \u4ed6\u662f\u7b2c\u4e00;

    static {
        \u4ed6\u662f\u7b2c\u4e00 = new NMSLException("\u4dc6\u274d\u4de8\u4872\u4dc0\u4dd2\u3df4\u4df8\u2736\u2748\ua642\u4dde\u2724\u274e\u4dc4\u3b4b\u27b6\u2767\u26b7\u2783\u3840\u4df6\u4dd9\u278d\u45e5\u4dc3\u2795\u4deb\u4de9\u4dee\u278c\u27bc\ua692\ua65b\u3c7f\u4dfe");
        logger = LogManager.getLogger((String)"mixin");
    }

    private static String getUniqueReference(String originalName, MixinTargetContext context) {
        String name = originalName.substring(originalName.lastIndexOf(36) + 1);
        if (name.matches("^[0-9]+$")) {
            name = "Anonymous";
        }
        return String.format("%s$%s$%s", context.getTargetClassRef(), name, UUID.randomUUID().toString().replace("-", ""));
    }

    private byte[] generate(InnerClassInfo info) {
        try {
            logger.debug("Generating mapped inner class {} (originally {})", new Object[]{info.getName(), info.getOriginalName()});
            ClassReader cr = new ClassReader(info.getClassBytes());
            MixinClassWriter cw = new MixinClassWriter(cr, 0);
            cr.accept(new InnerClassAdapter((ClassVisitor)cw, info), 8);
            return cw.toByteArray();
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] generate(String name) {
        String ref = name.replace('.', '/');
        InnerClassInfo info = this.innerClasses.get(ref);
        if (info != null) {
            return this.generate(info);
        }
        return null;
    }

    InnerClassGenerator() {
        this.innerClasses = new HashMap<String, InnerClassInfo>();
    }

    public String registerInnerClass(MixinInfo owner, String originalName, MixinTargetContext context) {
        String id = String.format("%s%s", originalName, context);
        String ref = this.innerClassNames.get(id);
        if (ref == null) {
            ref = InnerClassGenerator.getUniqueReference(originalName, context);
            this.innerClassNames.put(id, ref);
            this.innerClasses.put(ref, new InnerClassInfo(ref, originalName, owner, context));
            logger.debug("Inner class {} in {} on {} gets unique name {}", new Object[]{originalName, owner.getClassRef(), context.getTargetClassRef(), ref});
        }
        return ref;
    }

    static class InnerClassAdapter
    extends ClassRemapper {
        private final InnerClassInfo info;
        private static final NMSLException \u4e00\u540c\u5230\u8fbe\u9c9c\u82b1\u82ac\u82b3\u7684\u897f\u98ce\u5c3d\u5934 = new NMSLException("\u4dff\u2710\ua67e\u4dd8\u4df4\ua67b\u4de1\ua663\u4dc1\ua653\u4df9\u4de9\u3d06\u4dd2\u4dc6\u2758\u4dd0\u2688\u274b\ua64f\ua667\u4df2\u4dfc\u4dc3\u4df1\u4be4\ua671\u2713\ua67d\u4dde\u4ddc\u4de2\u2660\u4df6");

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name.startsWith(this.info.getOriginalName() + "$")) {
                throw new InvalidMixinException((IMixinInfo)this.info.getOwner(), "Found unsupported nested inner class " + name + " in " + this.info.getOriginalName());
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }

        @Override
        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
            AnnotationVisitor av = this.cv.visitAnnotation("Lorg/spongepowered/asm/mixin/transformer/meta/MixinInner;", false);
            av.visit("mixin", this.info.getOwner().toString());
            av.visit("name", this.info.getOriginalName().substring(this.info.getOriginalName().lastIndexOf(47) + 1));
            av.visitEnd();
        }

        public InnerClassAdapter(ClassVisitor cv, InnerClassInfo info) {
            super(327680, cv, info);
            this.info = info;
        }
    }

    static class InnerClassInfo
    extends Remapper {
        private final MixinTargetContext target;
        private final String targetName;
        private final MixinInfo owner;
        private final String name;
        private final String originalName;
        private final String ownerName;
        private static final NMSLException \u8fdc\u65b9\u4f1a\u662f\u65b0\u7684\u4e16\u754c = new NMSLException("\u4ddf\ua663\u263d\ua68b\u2617\u4dff\ua662\u27b6\u4df9\u4df8\u3406\u4df3\u2744\u26e6\u4dd6\u4dc4\u2660\u4dc7\ua64e\u2768\u2715\u263f\u4dd2\ua658\u3ab8\u4dff\u4df6\ua655\u4ddb\u4de6\ua66a\u4ddd\ua666\u4df8\u276b\u4df8\ua697");

        String getName() {
            return this.name;
        }

        String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            ClassInfo.Method method;
            if (this.ownerName.equalsIgnoreCase(owner) && (method = this.owner.getClassInfo().findMethod(name, desc, 10)) != null) {
                return method.getName();
            }
            return super.mapMethodName(owner, name, desc);
        }

        public String toString() {
            return this.name;
        }

        String getTargetName() {
            return this.targetName;
        }

        String getOriginalName() {
            return this.originalName;
        }

        MixinInfo getOwner() {
            return this.owner;
        }

        MixinTargetContext getTarget() {
            return this.target;
        }

        byte[] getClassBytes() throws ClassNotFoundException, IOException {
            return MixinService.getService().getBytecodeProvider().getClassBytes(this.originalName, true);
        }

        InnerClassInfo(String name, String originalName, MixinInfo owner, MixinTargetContext target) {
            this.name = name;
            this.originalName = originalName;
            this.owner = owner;
            this.ownerName = owner.getClassRef();
            this.target = target;
            this.targetName = target.getTargetClassRef();
        }

        @Override
        public String map(String key) {
            if (this.originalName.equals(key)) {
                return this.name;
            }
            if (this.ownerName.equals(key)) {
                return this.targetName;
            }
            return key;
        }
    }
}

