/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.refmap.ReferenceMapper;
import org.spongepowered.asm.mixin.refmap.RemappingReferenceMapper;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.VersionNumber;
import pers.XiaoShadiao.NMSLException;

final class MixinConfig
implements Comparable<MixinConfig>,
IMixinConfig {
    @SerializedName(value="overwrites")
    private OverwriteOptions overwriteOptions;
    @SerializedName(value="priority")
    private int priority = 1000;
    private final transient Set<String> unhandledTargets;
    private final transient Map<String, List<MixinInfo>> mixinMapping;
    private transient boolean prepared = false;
    private final transient int order;
    private transient boolean visited = false;
    @SerializedName(value="setSourceFile")
    private boolean setSourceFile = false;
    @SerializedName(value="mixinPriority")
    private int mixinPriority = 1000;
    private static final Set<String> globalMixinList;
    private transient Config handle;
    private transient IMixinService service;
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final transient List<IListener> listeners;
    private transient IMixinConfigPlugin plugin;
    private transient MixinEnvironment env;
    @SerializedName(value="package")
    private String mixinPackage;
    @SerializedName(value="injectors")
    private InjectorOptions injectorOptions;
    private final transient List<MixinInfo> mixins;
    @SerializedName(value="required")
    private boolean required;
    @SerializedName(value="minVersion")
    private String version;
    private static int configOrder;
    private transient String name;
    @SerializedName(value="mixins")
    private List<String> mixinClasses;
    @SerializedName(value="target")
    private String selector;
    @SerializedName(value="client")
    private List<String> mixinClassesClient;
    @SerializedName(value="verbose")
    private boolean verboseLogging;
    @SerializedName(value="server")
    private List<String> mixinClassesServer;
    private transient IReferenceMapper refMapper;
    @SerializedName(value="refmap")
    private String refMapperConfig;
    @SerializedName(value="compatibilityLevel")
    private String compatibility;
    @SerializedName(value="plugin")
    private String pluginClassName;
    private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b81;

    int getDeclaredMixinCount() {
        return MixinConfig.getCollectionSize(this.mixinClasses, this.mixinClassesClient, this.mixinClassesServer);
    }

    public boolean conformOverwriteVisibility() {
        return this.overwriteOptions.conformAccessModifiers;
    }

    @Override
    public int compareTo(MixinConfig other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    private static int getCollectionSize(Collection<?> ... collections) {
        int total = 0;
        for (Collection<?> collection : collections) {
            if (collection == null) continue;
            total += collection.size();
        }
        return total;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public List<String> getClasses() {
        return Collections.unmodifiableList(this.mixinClasses);
    }

    void onSelect() {
        if (this.pluginClassName != null) {
            try {
                Class<?> pluginClass = this.service.getClassProvider().findClass(this.pluginClassName, true);
                this.plugin = (IMixinConfigPlugin)pluginClass.newInstance();
                if (this.plugin != null) {
                    this.plugin.onLoad(this.mixinPackage);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                this.plugin = null;
            }
        }
        if (!this.mixinPackage.endsWith(".")) {
            this.mixinPackage = this.mixinPackage + ".";
        }
        boolean suppressRefMapWarning = false;
        if (this.refMapperConfig == null) {
            if (this.plugin != null) {
                this.refMapperConfig = this.plugin.getRefMapperConfig();
            }
            if (this.refMapperConfig == null) {
                suppressRefMapWarning = true;
                this.refMapperConfig = "mixin.refmap.json";
            }
        }
        this.refMapper = ReferenceMapper.read(this.refMapperConfig);
        this.verboseLogging |= this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        if (!suppressRefMapWarning && this.refMapper.isDefault() && !this.env.getOption(MixinEnvironment.Option.DISABLE_REFMAP)) {
            this.logger.warn("Reference map '{}' for {} could not be read. If this is a development environment you can ignore this message", new Object[]{this.refMapperConfig, this});
        }
        if (this.env.getOption(MixinEnvironment.Option.REFMAP_REMAP)) {
            this.refMapper = RemappingReferenceMapper.of(this.env, this.refMapper);
        }
    }

    public boolean requireOverwriteAnnotations() {
        return this.overwriteOptions.requireOverwriteAnnotations;
    }

    private List<MixinInfo> mixinsFor(String targetClass) {
        List<MixinInfo> mixins = this.mixinMapping.get(targetClass);
        if (mixins == null) {
            mixins = new ArrayList<MixinInfo>();
            this.mixinMapping.put(targetClass, mixins);
        }
        return mixins;
    }

    public Config getHandle() {
        if (this.handle == null) {
            this.handle = new Config(this);
        }
        return this.handle;
    }

    boolean isVisited() {
        return this.visited;
    }

    String remapClassName(String className, String reference) {
        return this.getReferenceMapper().remap(className, reference);
    }

    public String getDefaultInjectorGroup() {
        String defaultGroup = this.injectorOptions.defaultGroup;
        return defaultGroup != null && !defaultGroup.isEmpty() ? defaultGroup : "default";
    }

    public boolean shouldSetSourceFile() {
        return this.setSourceFile;
    }

    public List<MixinInfo> getMixinsFor(String targetClass) {
        return this.mixinsFor(targetClass);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public int getDefaultRequiredInjections() {
        return this.injectorOptions.defaultRequireValue;
    }

    public IReferenceMapper getReferenceMapper() {
        if (this.env.getOption(MixinEnvironment.Option.DISABLE_REFMAP)) {
            return ReferenceMapper.DEFAULT_MAPPER;
        }
        this.refMapper.setContext(this.env.getRefmapObfuscationContext());
        return this.refMapper;
    }

    public boolean hasMixinsFor(String targetClass) {
        return this.mixinMapping.containsKey(targetClass);
    }

    public Set<String> getUnhandledTargets() {
        return Collections.unmodifiableSet(this.unhandledTargets);
    }

    private MixinEnvironment parseSelector(String target, MixinEnvironment fallbackEnvironment) {
        if (target != null) {
            String[] selectors;
            for (String sel : selectors = target.split("[&\\| ]")) {
                sel = sel.trim();
                Pattern environmentSelector = Pattern.compile("^@env(?:ironment)?\\(([A-Z]+)\\)$");
                Matcher environmentSelectorMatcher = environmentSelector.matcher(sel);
                if (!environmentSelectorMatcher.matches()) continue;
                return MixinEnvironment.getEnvironment(MixinEnvironment.Phase.forName(environmentSelectorMatcher.group(1)));
            }
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(target);
            if (phase != null) {
                return MixinEnvironment.getEnvironment(phase);
            }
        }
        return fallbackEnvironment;
    }

    @Override
    public String getMixinPackage() {
        return this.mixinPackage;
    }

    static {
        \u6211\u4eec\u662f\u7f07\u5b81 = new NMSLException("\ua68e\u4df8\u4dfa\u2747\u45ef\u4dc9\u4dc3\u38ad\u2649\u4dee\ua680\ua660\u4de5\u4de0\u277c\u2796\u4df3\u2770\u4df3\u4df7\ua69f\u4206\u4de8\u4dee\u269c\u4ddc\u4de9\u4dd0\ua68e\u4df0\ua68a\u4de6\ua685\u2629\u4119\u4df9\u4dde\ua657\u260c\u2698\u26fe\u2747\u260f\ua663\u4dfc");
        configOrder = 0;
        globalMixinList = new HashSet<String>();
    }

    private boolean onLoad(IMixinService service, String name, MixinEnvironment fallbackEnvironment) {
        this.service = service;
        this.name = name;
        this.env = this.parseSelector(this.selector, fallbackEnvironment);
        this.required &= !this.env.getOption(MixinEnvironment.Option.IGNORE_REQUIRED);
        this.initCompatibilityLevel();
        this.initInjectionPoints();
        return this.checkVersion();
    }

    public Level getLoggingLevel() {
        return this.verboseLogging ? Level.INFO : Level.DEBUG;
    }

    public boolean select(MixinEnvironment environment) {
        this.visited = true;
        return this.env == environment;
    }

    void addListener(IListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public MixinEnvironment getEnvironment() {
        return this.env;
    }

    public boolean packageMatch(String className) {
        return className.startsWith(this.mixinPackage);
    }

    @Override
    public IMixinConfigPlugin getPlugin() {
        return this.plugin;
    }

    public int getDefaultMixinPriority() {
        return this.mixinPriority;
    }

    private void initCompatibilityLevel() {
        MixinEnvironment.CompatibilityLevel current;
        if (this.compatibility == null) {
            return;
        }
        MixinEnvironment.CompatibilityLevel level = MixinEnvironment.CompatibilityLevel.valueOf(this.compatibility.trim().toUpperCase());
        if (level == (current = MixinEnvironment.getCompatibilityLevel())) {
            return;
        }
        if (current.isAtLeast(level) && !current.canSupport(level)) {
            throw new MixinInitialisationError("Mixin config " + this.name + " requires compatibility level " + (Object)((Object)level) + " which is too old");
        }
        if (!current.canElevateTo(level)) {
            throw new MixinInitialisationError("Mixin config " + this.name + " requires compatibility level " + (Object)((Object)level) + " which is prohibited by " + (Object)((Object)current));
        }
        MixinEnvironment.setCompatibilityLevel(level);
    }

    void postInitialise() {
        if (this.plugin != null) {
            List<String> pluginMixins = this.plugin.getMixins();
            this.prepareMixins(pluginMixins, true);
        }
        Iterator<MixinInfo> iter = this.mixins.iterator();
        while (iter.hasNext()) {
            MixinInfo mixin = iter.next();
            try {
                mixin.validate();
                for (IListener listener : this.listeners) {
                    listener.onInit(mixin);
                }
            }
            catch (InvalidMixinException ex) {
                this.logger.error(ex.getMixin() + ": " + ex.getMessage(), (Throwable)ex);
                this.removeMixin(mixin);
                iter.remove();
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                this.removeMixin(mixin);
                iter.remove();
            }
        }
    }

    private void removeMixin(MixinInfo remove) {
        for (List<MixinInfo> mixinsFor : this.mixinMapping.values()) {
            Iterator<MixinInfo> iter = mixinsFor.iterator();
            while (iter.hasNext()) {
                if (remove != iter.next()) continue;
                iter.remove();
            }
        }
    }

    public List<String> reloadMixin(String mixinClass, byte[] bytes) {
        for (MixinInfo mixin : this.mixins) {
            if (!mixin.getClassName().equals(mixinClass)) continue;
            mixin.reloadMixin(bytes);
            return mixin.getTargetClasses();
        }
        return Collections.emptyList();
    }

    private boolean checkVersion() throws MixinInitialisationError {
        VersionNumber curVersion;
        VersionNumber minVersion;
        if (this.version == null) {
            this.logger.error("Mixin config {} does not specify \"minVersion\" property", new Object[]{this.name});
        }
        if ((minVersion = VersionNumber.parse(this.version)).compareTo(curVersion = VersionNumber.parse(this.env.getVersion())) > 0) {
            this.logger.warn("Mixin config {} requires mixin subsystem version {} but {} was found. The mixin config will not be applied.", new Object[]{this.name, minVersion, curVersion});
            if (this.required) {
                throw new MixinInitialisationError("Required mixin config " + this.name + " requires mixin subsystem version " + minVersion);
            }
            return false;
        }
        return true;
    }

    private void initInjectionPoints() {
        if (this.injectorOptions.injectionPoints == null) {
            return;
        }
        for (String injectionPoint : this.injectorOptions.injectionPoints) {
            try {
                Class<?> injectionPointClass = this.service.getClassProvider().findClass(injectionPoint, true);
                if (InjectionPoint.class.isAssignableFrom(injectionPointClass)) {
                    InjectionPoint.register(injectionPointClass);
                    continue;
                }
                this.logger.error("Unable to register injection point {} for {}, class must extend InjectionPoint", new Object[]{injectionPointClass, this});
            }
            catch (Throwable th) {
                this.logger.catching(th);
            }
        }
    }

    void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.prepareMixins(this.mixinClasses, false);
        switch (this.env.getSide()) {
            case CLIENT: {
                this.prepareMixins(this.mixinClassesClient, false);
                break;
            }
            case SERVER: {
                this.prepareMixins(this.mixinClassesServer, false);
                break;
            }
            default: {
                this.logger.warn("Mixin environment was unable to detect the current side, sided mixins will not be applied");
            }
        }
    }

    public String toString() {
        return this.name;
    }

    void postApply(String transformedName, ClassNode targetClass) {
        this.unhandledTargets.remove(transformedName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private MixinConfig() {
        this.mixinMapping = new HashMap<String, List<MixinInfo>>();
        this.unhandledTargets = new HashSet<String>();
        this.mixins = new ArrayList<MixinInfo>();
        this.order = configOrder++;
        this.listeners = new ArrayList<IListener>();
        this.injectorOptions = new InjectorOptions();
        this.overwriteOptions = new OverwriteOptions();
    }

    static Config create(String configFile, MixinEnvironment outer) {
        try {
            IMixinService service = MixinService.getService();
            MixinConfig config = (MixinConfig)new Gson().fromJson((Reader)new InputStreamReader(service.getResourceAsStream(configFile)), MixinConfig.class);
            if (config.onLoad(service, configFile, outer)) {
                return config.getHandle();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(String.format("The specified resource '%s' was invalid or could not be read", configFile), ex);
        }
    }

    public int getMaxShiftByValue() {
        return Math.min(Math.max(this.injectorOptions.maxShiftBy, 0), 5);
    }

    int getMixinCount() {
        return this.mixins.size();
    }

    private void prepareMixins(List<String> mixinClasses, boolean suppressPlugin) {
        if (mixinClasses == null) {
            return;
        }
        for (String mixinClass : mixinClasses) {
            String fqMixinClass = this.mixinPackage + mixinClass;
            if (mixinClass == null || globalMixinList.contains(fqMixinClass)) continue;
            MixinInfo mixin = null;
            try {
                mixin = new MixinInfo(this.service, this, mixinClass, true, this.plugin, suppressPlugin);
                if (mixin.getTargetClasses().size() <= 0) continue;
                globalMixinList.add(fqMixinClass);
                for (String targetClass : mixin.getTargetClasses()) {
                    String targetClassName = targetClass.replace('/', '.');
                    this.mixinsFor(targetClassName).add(mixin);
                    this.unhandledTargets.add(targetClassName);
                }
                for (IListener listener : this.listeners) {
                    listener.onPrepare(mixin);
                }
                this.mixins.add(mixin);
            }
            catch (InvalidMixinException ex) {
                if (this.required) {
                    throw ex;
                }
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                if (this.required) {
                    throw new InvalidMixinException(mixin, "Error initialising mixin " + mixin + " - " + ex.getClass() + ": " + ex.getMessage(), (Throwable)ex);
                }
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public Set<String> getTargets() {
        return Collections.unmodifiableSet(this.mixinMapping.keySet());
    }

    static interface IListener {
        public void onPrepare(MixinInfo var1);

        public void onInit(MixinInfo var1);
    }

    static class OverwriteOptions {
        @SerializedName(value="conformVisibility")
        boolean conformAccessModifiers;
        @SerializedName(value="requireAnnotations")
        boolean requireOverwriteAnnotations;
        private static final NMSLException \u68a6\u91cc = new NMSLException("\u2620\u4de6\u4df8\u4dfe\u4dfe\u4dc9\u4df5\u4ddc\u4df9\u4dee\u4deb\u4df7\u373a\u4dcb\ua66e\u486a\u4df2\u4dc8\u26c3\u4dde\ua695\u3dfd\u37a9\u4de1\u4de2\ua677\u4de6\ua67a\u264b\u4dc6\u2751\u47a1\u4dcb\u2747\u48a7\ua697\u2601\u4dd3\u35d6\u2795\ua64b\u4de3\u4dd3\u267e\u4dc8\ua668\ua685");

        OverwriteOptions() {
        }
    }

    static class InjectorOptions {
        @SerializedName(value="injectionPoints")
        List<String> injectionPoints;
        @SerializedName(value="maxShiftBy")
        int maxShiftBy = 0;
        @SerializedName(value="defaultRequire")
        int defaultRequireValue = 0;
        @SerializedName(value="defaultGroup")
        String defaultGroup = "default";
        private static final NMSLException \u963f\u96c5\u5979 = new NMSLException("\u2706\u4ded\u4467\u4def\u26b9\u4dd8\u4dc2\ua64d\u4dd7\u4dfe\u4dfe\u4de7\u4ddc\u4de1\u3a9c\ua673\u4dfd\u4dcd\u2790\u4dcb\u4de8\u4dd9\u267a\u4dce\u279a\u26a9\u4df2\u4df6\u4505\u27a0\u4ddb\u2743\u4dc0\u26f5\u27a8\u4df7\u275c\u4dca\u4136\u4dc5\u3cab\u4de5\u4dd1\u4dcf\u4dc7");

        InjectorOptions() {
        }
    }
}

