/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorAccessor;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorInterface;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTargetAlreadyLoadedException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.NMSLException;

class MixinInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    static int mixinOrder;
    private final String className;
    private final transient MixinEnvironment.Phase phase;
    private transient State state;
    private final transient ClassInfo info;
    private transient State pendingState;
    private final transient IMixinConfigPlugin plugin;
    private final boolean virtual;
    private final transient int order;
    private final transient Logger logger = LogManager.getLogger((String)"mixin");
    private final int priority;
    private final String name;
    private final List<ClassInfo> targetClasses;
    private final transient IMixinService service;
    private final List<String> targetClassNames;
    private static final IMixinService classLoaderUtil;
    private final transient SubType type;
    private final transient boolean strict;
    private final transient Profiler profiler = MixinEnvironment.getProfiler();
    private final transient MixinConfig parent;
    private static final NMSLException \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684;

    @Override
    public byte[] getClassBytes() {
        return this.getState().getClassBytes();
    }

    private void handleTargetError(String message) {
        if (this.strict) {
            this.logger.error(message);
            throw new InvalidMixinException((IMixinInfo)this, message);
        }
        this.logger.warn(message);
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getState().getSoftImplements());
    }

    private boolean shouldApplyMixin(boolean suppressPlugin, String targetName) {
        Profiler.Section pluginTimer = this.profiler.begin("plugin");
        boolean result = this.plugin == null || suppressPlugin || this.plugin.shouldApplyMixin(targetName, this.className);
        pluginTimer.end();
        return result;
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    public void postApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.postApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
        this.parent.postApply(transformedName, targetClass);
    }

    public boolean isUnique() {
        return this.getState().isUnique();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected boolean readPseudo(ClassNode classNode) {
        return Annotations.getInvisible(classNode, Pseudo.class) != null;
    }

    public boolean isLoadable() {
        return this.type.isLoadable();
    }

    void reloadMixin(byte[] mixinBytes) {
        if (this.pendingState != null) {
            throw new IllegalStateException("Cannot reload mixin while it is initialising");
        }
        this.pendingState = new Reloaded(this.state, mixinBytes);
        this.validate();
    }

    static {
        \u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684 = new NMSLException("\u4dfd\u4de9\u4dc6\u4ddd\u4dc1\u4dd1\u26a1\u4de3\u4df4\u4df2\u4dfd\u2645\ua641\u4de0\u4df7\u4de7\u4de8\u276e\u4dfc\u4de7\ua66a\u2723\u279c\u279e\u4ddb\u38ca\u2652\u4dcc\u2760\u4dc5");
        classLoaderUtil = MixinService.getService();
        mixinOrder = 0;
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getState().isDetachedSuper();
    }

    Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getSyntheticInnerClasses());
    }

    MixinConfig getParent() {
        return this.parent;
    }

    Set<String> getInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getInnerClasses());
    }

    private void readTargets(Collection<ClassInfo> outTargets, Collection<String> inTargets, boolean suppressPlugin, boolean checkPublic) {
        for (String targetRef : inTargets) {
            ClassInfo targetInfo;
            String targetName = targetRef.replace('/', '.');
            if (classLoaderUtil.isClassLoaded(targetName) && !this.isReloading()) {
                String message = String.format("Critical problem: %s target %s was already transformed.", this, targetName);
                if (this.parent.isRequired()) {
                    throw new MixinTargetAlreadyLoadedException((IMixinInfo)this, message, targetName);
                }
                this.logger.error(message);
            }
            if (!this.shouldApplyMixin(suppressPlugin, targetName) || (targetInfo = this.getTarget(targetName, checkPublic)) == null || outTargets.contains(targetInfo)) continue;
            outTargets.add(targetInfo);
            targetInfo.addMixin(this);
        }
    }

    private boolean isReloading() {
        return this.pendingState instanceof Reloaded;
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    public boolean isAccessor() {
        return this.type instanceof SubType.Accessor;
    }

    public String toString() {
        return String.format("%s:%s", this.parent.getName(), this.name);
    }

    @Override
    public int compareTo(MixinInfo other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    protected int readPriority(ClassNode classNode) {
        if (classNode == null) {
            return this.parent.getDefaultMixinPriority();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        Integer priority = (Integer)Annotations.getValue(mixin, "priority");
        return priority == null ? this.parent.getDefaultMixinPriority() : priority.intValue();
    }

    ClassInfo getClassInfo() {
        return this.info;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    MixinInfo(IMixinService service, MixinConfig parent, String name, boolean runTransformers, IMixinConfigPlugin plugin, boolean suppressPlugin) {
        this.order = mixinOrder++;
        this.service = service;
        this.parent = parent;
        this.name = name;
        this.className = parent.getMixinPackage() + name;
        this.plugin = plugin;
        this.phase = parent.getEnvironment().getPhase();
        this.strict = parent.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_TARGETS);
        try {
            byte[] mixinBytes = this.loadMixinClass(this.className, runTransformers);
            this.pendingState = new State(mixinBytes);
            this.info = this.pendingState.getClassInfo();
            this.type = SubType.getTypeFor(this);
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
        if (!this.type.isLoadable()) {
            classLoaderUtil.registerInvalidClass(this.className);
        }
        try {
            this.priority = this.readPriority(this.pendingState.getClassNode());
            this.virtual = this.readPseudo(this.pendingState.getClassNode());
            this.targetClasses = this.readTargetClasses(this.pendingState.getClassNode(), suppressPlugin);
            this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    void validate() {
        if (this.pendingState == null) {
            throw new IllegalStateException("No pending validation state for " + this);
        }
        try {
            this.pendingState.validate(this.type, this.targetClasses);
            this.state = this.pendingState;
        }
        finally {
            this.pendingState = null;
        }
    }

    protected List<ClassInfo> readTargetClasses(MixinClassNode classNode, boolean suppressPlugin) {
        if (classNode == null) {
            return Collections.emptyList();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        ArrayList<ClassInfo> targets = new ArrayList<ClassInfo>();
        List publicTargets = (List)Annotations.getValue(mixin, "value");
        List privateTargets = (List)Annotations.getValue(mixin, "targets");
        if (publicTargets != null) {
            this.readTargets(targets, Lists.transform((List)publicTargets, (Function)new Function<Type, String>(){
                private static final NMSLException \u6211\u4eec\u662f\u7f07\u91cc\u897f\u5e87\u4fc4\u4e1d = new NMSLException("\u3905\u4de5\u39e3\u4df4\u4dc8\u4dc8\u4dd0\u4de4\u2732\u4461\u4dc0\u4df1\u4de3\u4dd1\u4de9\u4ddd\ua67f\u26c4\u4df7\u4de9\u4dc2\u2784\u4dd3\u4dc0\ua678\ua659\u4dcd\ua682\u266e\u26e8\u4dfe\u4ddb\u4dd1\u4dc8\u272a\u26cf\u2749\ua675\ua64e\ua651\u4dca\ua65b\u2768\u4dc8");

                public String apply(Type input) {
                    return input.getClassName();
                }
            }), suppressPlugin, false);
        }
        if (privateTargets != null) {
            this.readTargets(targets, Lists.transform((List)privateTargets, (Function)new Function<String, String>(){
                private static final NMSLException \u68d2 = new NMSLException("\u4dfb\u4dca\u3965\u4dde\u4ded\u4dfb\u4de5\ua672\u4df9\u4dc4\u4df5\ua67f\u4dc2\u4dfd\u4dd2\u4de1\ua67a\ua650\u3aa4\u4de9\u4dc7\u4df1\ua684\u4dc5\ua647\u4de3\u4dcd\ua649\u4df9\u42b3\u277f\u4ddf\u2737\ua690\u4dca");

                public String apply(String input) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), input);
                }
            }), suppressPlugin, true);
        }
        return targets;
    }

    @Override
    public MixinClassNode getClassNode(int flags) {
        return this.getState().createClassNode(flags);
    }

    private byte[] loadMixinClass(String mixinClassName, boolean runTransformers) throws ClassNotFoundException {
        byte[] mixinBytes = null;
        try {
            String restrictions;
            if (runTransformers && (restrictions = this.service.getClassRestrictions(mixinClassName)).length() > 0) {
                this.logger.error("Classloader restrictions [{}] encountered loading {}, name: {}", new Object[]{restrictions, this, mixinClassName});
            }
            mixinBytes = this.service.getBytecodeProvider().getClassBytes(mixinClassName, runTransformers);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(String.format("The specified mixin '%s' was not found", mixinClassName));
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load mixin {}, the specified mixin will not be applied", new Object[]{mixinClassName});
            throw new InvalidMixinException(this, "An error was encountered whilst loading the mixin class", (Throwable)ex);
        }
        return mixinBytes;
    }

    MixinTargetContext createContextFor(TargetClassContext target) {
        ClassNode classNode = this.getClassNode(8);
        Profiler.Section preTimer = this.profiler.begin("pre");
        MixinTargetContext preProcessor = this.type.createPreProcessor((MixinClassNode)classNode).prepare().createContextFor(target);
        preTimer.end();
        return preProcessor;
    }

    Set<String> getInterfaces() {
        return this.getState().getInterfaces();
    }

    public void preApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.preApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
    }

    private ClassInfo getTarget(String targetName, boolean checkPublic) throws InvalidMixinException {
        ClassInfo targetInfo = ClassInfo.forName(targetName);
        if (targetInfo == null) {
            if (this.isVirtual()) {
                this.logger.debug("Skipping virtual target {} for {}", new Object[]{targetName, this});
            } else {
                this.handleTargetError(String.format("@Mixin target %s was not found %s", targetName, this));
            }
            return null;
        }
        this.type.validateTarget(targetName, targetInfo);
        if (checkPublic && targetInfo.isPublic() && !this.isVirtual()) {
            this.handleTargetError(String.format("@Mixin target %s is public in %s and should be specified in value", targetName, this));
        }
        return targetInfo;
    }

    private State getState() {
        return this.state != null ? this.state : this.pendingState;
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.targetClasses);
    }

    static abstract class SubType {
        protected boolean detached;
        protected final MixinInfo mixin;
        protected final boolean targetMustBeInterface;
        protected final String annotationType;
        private static final NMSLException \u4f60\u62cd\u516d = new NMSLException("\u27a7\u4351\u386e\u4dde\u2763\u3c8d\u26b5\ua652\u2678\u4dc0\u4dc6\u4de8\u4de9\u4de4\u4dcc\u27b0\u2774\u4ddb\u26b9\ua68d\u4dce\ua67a\u3474\u470d\u4ddd\u47dd\u276d\u264c\u4dc3\ua68b\u2735\u2698");

        boolean isDetachedSuper() {
            return this.detached;
        }

        static SubType getTypeFor(MixinInfo mixin) {
            if (!mixin.getClassInfo().isInterface()) {
                return new Standard(mixin);
            }
            boolean containsNonAccessorMethod = false;
            for (ClassInfo.Method method : mixin.getClassInfo().getMethods()) {
                containsNonAccessorMethod |= !method.isAccessor();
            }
            if (containsNonAccessorMethod) {
                return new Interface(mixin);
            }
            return new Accessor(mixin);
        }

        void validateTarget(String targetName, ClassInfo targetInfo) {
            boolean targetIsInterface = targetInfo.isInterface();
            if (targetIsInterface != this.targetMustBeInterface) {
                String not = targetIsInterface ? "" : "not ";
                throw new InvalidMixinException((IMixinInfo)this.mixin, this.annotationType + " target type mismatch: " + targetName + " is " + not + "an interface in " + this);
            }
        }

        SubType(MixinInfo info, String annotationType, boolean targetMustBeInterface) {
            this.mixin = info;
            this.annotationType = annotationType;
            this.targetMustBeInterface = targetMustBeInterface;
        }

        abstract MixinPreProcessorStandard createPreProcessor(MixinClassNode var1);

        boolean isLoadable() {
            return false;
        }

        Collection<String> getInterfaces() {
            return Collections.emptyList();
        }

        abstract void validate(State var1, List<ClassInfo> var2);

        static class Accessor
        extends SubType {
            private final Collection<String> interfaces = new ArrayList<String>();
            private static final NMSLException \u7528\u4e94\u989c\u516d\u8272\u7684\u661f\u661f\u505a\u5e06 = new NMSLException("\u3521\u4b68\u4ddc\u4dc5\ua649\ua66c\u40f8\u4de0\u4dfc\u4de9\u4dd4\u4a8f\u4ddd\u274f\u4dd0\u2717\u26a5\u4ddd\u2703\u4dc8\u2786\u2746\u4def\u4ddc\u41a4\u4df2\u4dd3\u3982\ua648\u4df6\u4ddb\u4de0\u40a0\u4dfa\u4779\u46b3");

            @Override
            Collection<String> getInterfaces() {
                return this.interfaces;
            }

            Accessor(MixinInfo info) {
                super(info, "@Mixin", false);
                this.interfaces.add(info.getClassRef());
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }

            @Override
            boolean isLoadable() {
                return true;
            }

            @Override
            void validateTarget(String targetName, ClassInfo targetInfo) {
                boolean targetIsInterface = targetInfo.isInterface();
                if (targetIsInterface && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Accessor mixin targetting an interface is not supported in current enviromnment");
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorAccessor(this.mixin, classNode);
            }
        }

        static class Interface
        extends SubType {
            private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b81 = new NMSLException("\u4dc6\u4df9\u260d\u26a1\u4df5\u4dfa\ua65b\u4ddb\u2647\u26be\u4dc4\u4dfd\u4de6\u4dc9\u4dff\ua69b\u4dd5\u4dda\u4dc7\u26ac\u3c07\u26ff\u4dc4\u26ea\u2721\ua68f\u4de1\u2688\u44ea\u4dfc\u4dfd\u2799\u352a\u4de8\u2757\u3b0b\u2733");

            Interface(MixinInfo info) {
                super(info, "@Mixin", true);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                if (!MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Interface mixin not supported in current enviromnment");
                }
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorInterface(this.mixin, classNode);
            }
        }

        static class Standard
        extends SubType {
            private static final NMSLException \u6211\u652f\u6301 = new NMSLException("\ua650\u4dd9\u4dfb\u4dfe\u4def\u4dc8\u4dd9\u4de6\u4dc9\u4dfa\u4de6\ua675\u4ddd\u40ed\u4dcc\u44e9\u2617\u4dc9\u4dcd\u270b\u26f3\u2666\u26a5\u3dbe\u3b7b\u2645\u4b3a\u4def\u4435\u26f4\u4dc8\u4dee\u26e8\u4dd5\u26d4\u4dcd\u4dfe\u4de5\u2638\u4dfc\u2676");

            Standard(MixinInfo info) {
                super(info, "@Mixin", false);
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorStandard(this.mixin, classNode);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                for (ClassInfo targetClass : targetClasses) {
                    if (classNode.superName.equals(targetClass.getSuperName())) continue;
                    if (!targetClass.hasSuperClass(classNode.superName, ClassInfo.Traversal.SUPER)) {
                        ClassInfo superClass = ClassInfo.forName(classNode.superName);
                        if (superClass.isMixin()) {
                            for (ClassInfo superTarget : superClass.getTargets()) {
                                if (!targetClasses.contains(superTarget)) continue;
                                throw new InvalidMixinException((IMixinInfo)this.mixin, "Illegal hierarchy detected. Derived mixin " + this + " targets the same class " + superTarget.getClassName() + " as its superclass " + superClass.getClassName());
                            }
                        }
                        throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class '" + classNode.superName.replace('/', '.') + "' of " + this.mixin.getName() + " was not found in the hierarchy of target class '" + targetClass + "'");
                    }
                    this.detached = true;
                }
            }
        }
    }

    class Reloaded
    extends State {
        private final State previous;
        private static final NMSLException \u8981\u6765\u4e86\u5427 = new NMSLException("\u27bf\ua66c\u26bf\u2785\u4dff\u4dcf\u2614\u4dd6\u4df3\u4dd2\u4dd4\u4dca\u4dc0\u3cf5\ua64f\u4df4\u27bd\u265b\ua690\ua69a\u420c\u2731\u4dee\u2773\u4df5\u273d\u4de2\u26b0\u35ff\u4dec\u2788\u4dd1\u3e4b\u4dd2\u2675");

        @Override
        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change inner classes");
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change interfaces");
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change soft interfaces");
            }
            List<ClassInfo> targets = MixinInfo.this.readTargetClasses(this.classNode, true);
            if (!new HashSet<ClassInfo>(targets).equals(new HashSet<ClassInfo>(targetClasses))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change target classes");
            }
            int priority = MixinInfo.this.readPriority(this.classNode);
            if (priority != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change mixin priority");
            }
        }

        Reloaded(State previous, byte[] mixinBytes) {
            super(mixinBytes, previous.getClassInfo());
            this.previous = previous;
        }
    }

    class State {
        protected MixinClassNode classNode;
        private boolean unique;
        private final ClassInfo classInfo;
        protected final Set<String> interfaces = new HashSet<String>();
        protected final Set<String> innerClasses;
        private byte[] mixinBytes;
        private boolean detachedSuper;
        protected final List<InterfaceInfo> softImplements = new ArrayList<InterfaceInfo>();
        protected final Set<String> syntheticInnerClasses = new HashSet<String>();
        private static final NMSLException \u4e0d\u662f\u8868\u9762\u4e0a\u90a3\u4e48\u51b7\u6f20\u7684\u4eba = new NMSLException("\u4dc3\u45d0\u4de2\u4dd3\u2607\u4df7\u4dc9\u4de3\u273c\u4dec\ua67a\u4dcd\u2662\u4dde\u4deb\u26fd\u26cc\u4dd7\u4dfd\u2739\u4df7\ua664\ua644\u4dc8\u3a45\u26ff\ua659\u2778\u27a6\u27b8\u4ddc\u4dee\ua65d\u4dd2");

        void readInnerClasses() {
            for (InnerClassNode inner : this.classNode.innerClasses) {
                ClassInfo innerClass = ClassInfo.forName(inner.name);
                if ((inner.outerName == null || !inner.outerName.equals(this.classInfo.getName())) && !inner.name.startsWith(this.classNode.name + "$")) continue;
                if (innerClass.isProbablyStatic() && innerClass.isSynthetic()) {
                    this.syntheticInnerClasses.add(inner.name);
                    continue;
                }
                this.innerClasses.add(inner.name);
            }
        }

        Set<String> getSyntheticInnerClasses() {
            return this.syntheticInnerClasses;
        }

        private void validateClassVersion() {
            if (this.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
                String helpText = ".";
                for (MixinEnvironment.CompatibilityLevel level : MixinEnvironment.CompatibilityLevel.values()) {
                    if (level.classVersion() < this.classNode.version) continue;
                    helpText = String.format(". Mixin requires compatibility level %s or above.", level.name());
                }
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Unsupported mixin class version " + this.classNode.version + helpText);
            }
        }

        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            type.createPreProcessor(this.classNode).prepare();
        }

        void validate(SubType type, List<ClassInfo> targetClasses) {
            MixinPreProcessorStandard preProcessor = type.createPreProcessor(this.getClassNode()).prepare();
            for (ClassInfo target : targetClasses) {
                preProcessor.conform(target);
            }
            type.validate(this, targetClasses);
            this.detachedSuper = type.isDetachedSuper();
            this.unique = Annotations.getVisible(this.getClassNode(), Unique.class) != null;
            this.validateInner();
            this.validateClassVersion();
            this.validateRemappables(targetClasses);
            this.readImplementations(type);
            this.readInnerClasses();
            this.validateChanges(type, targetClasses);
            this.complete();
        }

        boolean isDetachedSuper() {
            return this.detachedSuper;
        }

        State(byte[] mixinBytes, ClassInfo classInfo) {
            this.innerClasses = new HashSet<String>();
            this.mixinBytes = mixinBytes;
            this.connect();
            this.classInfo = classInfo != null ? classInfo : ClassInfo.fromClassNode(this.getClassNode());
        }

        boolean isUnique() {
            return this.unique;
        }

        private void connect() {
            this.classNode = this.createClassNode(0);
        }

        private void complete() {
            this.classNode = null;
        }

        List<? extends InterfaceInfo> getSoftImplements() {
            return this.softImplements;
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        Set<String> getInnerClasses() {
            return this.innerClasses;
        }

        Set<String> getInterfaces() {
            return this.interfaces;
        }

        void readImplementations(SubType type) {
            this.interfaces.addAll(this.classNode.interfaces);
            this.interfaces.addAll(type.getInterfaces());
            AnnotationNode implementsAnnotation = Annotations.getInvisible(this.classNode, Implements.class);
            if (implementsAnnotation == null) {
                return;
            }
            List interfaces = (List)Annotations.getValue(implementsAnnotation);
            if (interfaces == null) {
                return;
            }
            for (AnnotationNode interfaceNode : interfaces) {
                InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(MixinInfo.this, interfaceNode);
                this.softImplements.add(interfaceInfo);
                this.interfaces.add(interfaceInfo.getInternalName());
                if (this instanceof Reloaded) continue;
                this.classInfo.addInterface(interfaceInfo.getInternalName());
            }
        }

        byte[] getClassBytes() {
            return this.mixinBytes;
        }

        private void validateInner() {
            if (!this.classInfo.isProbablyStatic()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Inner class mixin must be declared static");
            }
        }

        MixinClassNode getClassNode() {
            return this.classNode;
        }

        State(byte[] mixinBytes) {
            this(mixinBytes, null);
        }

        private void validateRemappable(Class<Shadow> annotationClass, String name, AnnotationNode annotation) {
            if (annotation != null && Annotations.getValue(annotation, "remap", Boolean.TRUE).booleanValue()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found a remappable @" + annotationClass.getSimpleName() + " annotation on " + name + " in " + this);
            }
        }

        MixinClassNode createClassNode(int flags) {
            MixinClassNode classNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(classNode, flags);
            return classNode;
        }

        private void validateRemappables(List<ClassInfo> targetClasses) {
            if (targetClasses.size() > 1) {
                for (FieldNode field : this.classNode.fields) {
                    this.validateRemappable(Shadow.class, field.name, Annotations.getVisible(field, Shadow.class));
                }
                for (MethodNode method : this.classNode.methods) {
                    this.validateRemappable(Shadow.class, method.name, Annotations.getVisible(method, Shadow.class));
                    AnnotationNode overwrite = Annotations.getVisible(method, Overwrite.class);
                    if (overwrite == null || (method.access & 8) != 0 && (method.access & 1) != 0) continue;
                    throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found @Overwrite annotation on " + method.name + " in " + MixinInfo.this);
                }
            }
        }
    }

    class MixinClassNode
    extends ClassNode {
        public final List<MixinMethodNode> mixinMethods;
        private static final NMSLException \u53ea\u662f\u5979\u7684\u70ed\u60c5\u548c\u5173\u6ce8 = new NMSLException("\u4dd2\u4dea\u4dda\u4df9\u2627\u2716\u4dc7\u2644\ua684\u4dcd\u265a\u4dd0\u4de5\u3b09\u4dc4\u2641\u4df1\u4dc8\u261c\ua692\u4df2\u364f\u4ddc\ua68f\u48f5\u4dd9\ua669\u4df7\u27b6\u4df0\u2627\u4de8\u279d\u4dd3\ua658\u2796\u4dc3\u274f\u4dff\ua692\u4ddd\u2691\u4dfb\u270e\u4dc8\ua656\u26d9\u275b\u4c0b");

        public MixinInfo getMixin() {
            return MixinInfo.this;
        }

        public MixinClassNode(MixinInfo mixin) {
            this(327680);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MixinMethodNode method = new MixinMethodNode(access, name, desc, signature, exceptions);
            this.methods.add(method);
            return method;
        }

        public MixinClassNode(int api) {
            super(api);
            this.mixinMethods = this.methods;
        }
    }

    class MixinMethodNode
    extends MethodNode {
        private final String originalName;
        private static final NMSLException \u68a6\u91cc = new NMSLException("\u2625\u3953\u261c\u3c0a\ua640\u417b\u4df8\u277b\u4ddb\u4dd1\u2649\u27b3\u46d5\ua682\u4dc8\u4186\u4df5\u4dc9\u4df0\ua695\u4dc1\u265a\u4de9\u3e2a\u38fc\u4de5\u346d\ua658\u2750\u260a\ua67e\u4dec\u4dfd\u2766\u2751\u26d0\u270a\u2692\ua64d\u26d1\u4353\ua673\ua697\ua69b");

        public String getOriginalName() {
            return this.originalName;
        }

        public IMixinInfo getOwner() {
            return MixinInfo.this;
        }

        public AnnotationNode getVisibleAnnotation(Class<? extends Annotation> annotationClass) {
            return Annotations.getVisible(this, annotationClass);
        }

        public boolean isSynthetic() {
            return Bytecode.hasFlag(this, 4096);
        }

        public AnnotationNode getInjectorAnnotation() {
            return InjectionInfo.getInjectorAnnotation(MixinInfo.this, this);
        }

        public boolean isInjector() {
            return this.getInjectorAnnotation() != null || this.isSurrogate();
        }

        public boolean isSurrogate() {
            return this.getVisibleAnnotation(Surrogate.class) != null;
        }

        public String toString() {
            return String.format("%s%s", this.originalName, this.desc);
        }

        public MixinMethodNode(int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.originalName = name;
        }
    }
}

