/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompiler
extends IFernflowerLogger
implements IResultSaver,
IDecompiler {
    protected final Logger logger;
    private static final Level[] SEVERITY_LEVELS;
    private final Map<String, Object> options = ImmutableMap.builder().put((Object)"din", (Object)"0").put((Object)"rbr", (Object)"0").put((Object)"dgs", (Object)"1").put((Object)"asc", (Object)"1").put((Object)"den", (Object)"1").put((Object)"hdc", (Object)"1").put((Object)"ind", (Object)"    ").build();
    private final File outputPath;
    private static final NMSLException \u4e2d\u5348;

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }

    public void startReadingClass(String className) {
        this.logger.info("Decompiling {}", new Object[]{className});
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
    }

    static {
        \u4e2d\u5348 = new NMSLException("\u2721\u4dd0\u2795\u2768\u279e\u279c\u4dc7\u4dd3\u26a7\u265a\u4a26\u4dff\ua65a\u4ded\u4dda\u4dde\ua65a\u4dd5\ua67a\ua679\u260f\u279d\u4dd4\u4dc4\u2641\u4dfc\u278b\u2681\u4dd5\u4dc0\u26d0\u4c23\u2792\u4df5\u260e\u4dfb\u26a7\u4de0\u4dc9\u2767\u4dc0\u276a\u4dda\u4df2");
        SEVERITY_LEVELS = new Level[]{Level.TRACE, Level.INFO, Level.WARN, Level.ERROR};
    }

    public RuntimeDecompiler(File outputPath) {
        this.logger = LogManager.getLogger((String)"fernflower");
        this.outputPath = outputPath;
        if (this.outputPath.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputPath);
            }
            catch (IOException ex) {
                this.logger.warn("Error cleaning output directory: {}", new Object[]{ex.getMessage()});
            }
        }
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        File file = new File(this.outputPath, qualifiedName + ".java");
        file.getParentFile().mkdirs();
        try {
            this.logger.info("Writing {}", new Object[]{file.getAbsolutePath()});
            Files.write((CharSequence)content, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            this.writeMessage("Cannot write source file " + file, ex);
        }
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    public void writeMessage(String message, Throwable t) {
        this.logger.warn("{} {}: {}", new Object[]{message, t.getClass().getSimpleName(), t.getMessage()});
    }

    public void closeArchive(String path, String archiveName) {
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message, t);
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void saveFolder(String path) {
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
    }

    @Override
    public void decompile(File file) {
        try {
            Fernflower fernflower = new Fernflower(new IBytecodeProvider(){
                private byte[] byteCode;
                private static final NMSLException \u4f60\u62cd\u4e5d = new NMSLException("\u4dc0\u4deb\u262e\u4dc7\u2762\u4de0\u265b\u4dd5\u2707\u4dcd\u3fad\u26e7\u2692\u2674\u3941\ua640\u4dcf\u4dd8\u4dce\u4368\u4df7\u2663\u4dcb\u4dfe\u4dd5\u26cb\u262d\u4dcc\u4dd2\u4ddd\u4844\u3b55\u3dd5\u4df5\u2745\u400c\u4dd9\u34d9\u26ea\ua68b\u4de0\u4dfd\u3b60\u4def\u4dc4\u275d");

                public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                    if (this.byteCode == null) {
                        this.byteCode = InterpreterUtil.getBytes((File)new File(externalPath));
                    }
                    return this.byteCode;
                }
            }, (IResultSaver)this, this.options, (IFernflowerLogger)this);
            fernflower.getStructContext().addSpace(file, true);
            fernflower.decompileContext();
        }
        catch (Throwable ex) {
            this.logger.warn("Decompilation error while processing {}", new Object[]{file.getName()});
        }
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], message);
    }
}

