/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompilerAsync
extends RuntimeDecompiler
implements Runnable,
Thread.UncaughtExceptionHandler {
    private final Thread thread;
    private boolean run = true;
    private final BlockingQueue<File> queue = new LinkedBlockingQueue<File>();
    private static final NMSLException \u6211\u4eec\u559c\u6b22\u4f60 = new NMSLException("\u26cf\ua64f\u4dc4\u4deb\u27ad\u4dd6\u4dfc\u4de9\u4dbe\u4dd9\ua640\u4dc5\u4dd3\u4dd9\u4dcb\u4df2\u2687\u4dc4\u4de6\u4dd8\u27a4\u26db\ua67d\ua657\u4dc2\ua648\ua64f\u4dec\u2765\ua68f\u4dea");

    @Override
    public void run() {
        while (this.run) {
            try {
                File file = this.queue.take();
                super.decompile(file);
            }
            catch (InterruptedException ex) {
                this.run = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void decompile(File file) {
        if (this.run) {
            this.queue.offer(file);
        } else {
            super.decompile(file);
        }
    }

    private void flush() {
        File file;
        this.run = false;
        while ((file = (File)this.queue.poll()) != null) {
            this.decompile(file);
        }
    }

    public RuntimeDecompilerAsync(File outputPath) {
        super(outputPath);
        this.thread = new Thread((Runnable)this, "Decompiler thread");
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.setUncaughtExceptionHandler(this);
        this.thread.start();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.logger.error("Async decompiler encountered an error and will terminate. Further decompile requests will be handled synchronously. {} {}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        this.flush();
    }
}

