/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import pers.XiaoShadiao.NMSLException;

public final class Extensions {
    private final MixinTransformer transformer;
    private final List<IClassGenerator> generators;
    private final Map<Class<? extends IExtension>, IExtension> extensionMap;
    private final Map<Class<? extends IClassGenerator>, IClassGenerator> generatorMap;
    private List<IExtension> activeExtensions;
    private final List<IExtension> extensions = new ArrayList<IExtension>();
    private final List<IClassGenerator> generatorsView;
    private static final NMSLException \u8bba\u519b\u4e8b\u548c\u5386\u53f2 = new NMSLException("\u4de5\u275d\u4dc5\u264d\u4dfb\ua699\u2792\u3d2d\u4dc0\ua66c\u4dc0\u38ff\u4df6\u4df9\u4dc7\u2771\ua693\u4dd4\u4dc5\u4de7\u3ea7\u27a4\u4dd6\u4ddb\u4de5\u465b\u37eb\u26db\u2699\u4dc2\u276c\u27ab\u27bd\u4dfb\u26dc\u2708\u2799\u2776\u4dc1\u4ddf\u2771\ua64f\u4dc8\u4dd7\u4c91");

    public void select(MixinEnvironment environment) {
        ImmutableList.Builder activeExtensions = ImmutableList.builder();
        for (IExtension extension : this.extensions) {
            if (!extension.checkActive(environment)) continue;
            activeExtensions.add((Object)extension);
        }
        this.activeExtensions = activeExtensions.build();
    }

    public <T extends IClassGenerator> T getGenerator(Class<? extends IClassGenerator> generatorClass) {
        return (T)Extensions.lookup(generatorClass, this.generatorMap, this.generators);
    }

    public void add(IClassGenerator generator) {
        this.generators.add(generator);
        this.generatorMap.put(generator.getClass(), generator);
    }

    public void add(IExtension extension) {
        this.extensions.add(extension);
        this.extensionMap.put(extension.getClass(), extension);
    }

    public Extensions(MixinTransformer transformer) {
        this.extensionMap = new HashMap<Class<? extends IExtension>, IExtension>();
        this.generators = new ArrayList<IClassGenerator>();
        this.generatorsView = Collections.unmodifiableList(this.generators);
        this.generatorMap = new HashMap<Class<? extends IClassGenerator>, IClassGenerator>();
        this.activeExtensions = Collections.emptyList();
        this.transformer = transformer;
    }

    public List<IClassGenerator> getGenerators() {
        return this.generatorsView;
    }

    public <T extends IExtension> T getExtension(Class<? extends IExtension> extensionClass) {
        return (T)Extensions.lookup(extensionClass, this.extensionMap, this.extensions);
    }

    private static <T> T lookup(Class<? extends T> extensionClass, Map<Class<? extends T>, T> map, List<T> list) {
        T extension = map.get(extensionClass);
        if (extension == null) {
            for (T classGenerator : list) {
                if (!extensionClass.isAssignableFrom(classGenerator.getClass())) continue;
                extension = classGenerator;
                break;
            }
            if (extension == null) {
                throw new IllegalArgumentException("Extension for <" + extensionClass.getName() + "> could not be found");
            }
            map.put(extensionClass, extension);
        }
        return extension;
    }

    public void preApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.preApply(context);
        }
    }

    public MixinTransformer getTransformer() {
        return this.transformer;
    }

    public List<IExtension> getActiveExtensions() {
        return this.activeExtensions;
    }

    public void export(MixinEnvironment env, String name, boolean force, byte[] bytes) {
        for (IExtension extension : this.activeExtensions) {
            extension.export(env, name, force, bytes);
        }
    }

    public List<IExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public void postApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.postApply(context);
        }
    }
}

