/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.obfuscation.mapping.common;

import com.google.common.base.Objects;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import pers.XiaoShadiao.NMSLException;

public class MappingMethod
implements IMapping<MappingMethod> {
    private final String name;
    private final String owner;
    private final String desc;
    private static final NMSLException \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019 = new NMSLException("\u2615\ua64a\u4df7\u4dfe\u4dcb\u2674\ua64a\ua66a\u4def\u4dcc\u4dd0\u443a\u4dd3\u4dda\u38b2\ua656\u4de0\u2657\u27bc\u4df2\u26c5\u4deb\u2614\u4dfe\u26e9\u26af\u2649\u26d4\u4df6\ua64c\ua668\u3533\u4c0e\u266d\ua678\u4de8\u442e\u404a\u4dd9\u2667\ua69f");

    public MappingMethod addPrefix(String prefix) {
        String simpleName = this.getSimpleName();
        if (simpleName == null || simpleName.startsWith(prefix)) {
            return this;
        }
        return new MappingMethod(this.getOwner(), prefix + simpleName, this.getDesc());
    }

    @Override
    public MappingMethod getSuper() {
        return null;
    }

    public MappingMethod(String owner, String simpleName, String desc) {
        this.owner = owner;
        this.name = simpleName;
        this.desc = desc;
    }

    @Override
    public MappingMethod remap(String newName) {
        return new MappingMethod(this.getOwner(), newName, this.getDesc());
    }

    private static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(pos + 1) : name;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getDesc()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MappingMethod) {
            return Objects.equal((Object)this.name, (Object)((MappingMethod)obj).name) && Objects.equal((Object)this.desc, (Object)((MappingMethod)obj).desc);
        }
        return false;
    }

    @Override
    public String serialise() {
        return this.toString();
    }

    @Override
    public IMapping.Type getType() {
        return IMapping.Type.METHOD;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public MappingMethod copy() {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), this.getDesc());
    }

    @Override
    public MappingMethod move(String newOwner) {
        return new MappingMethod(newOwner, this.getSimpleName(), this.getDesc());
    }

    @Override
    public MappingMethod transform(String newDesc) {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), newDesc);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    private static String getOwnerFromName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(0, pos) : null;
    }

    public MappingMethod(String fullyQualifiedName, String desc) {
        this(MappingMethod.getOwnerFromName(fullyQualifiedName), MappingMethod.getBaseName(fullyQualifiedName), desc);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return null;
        }
        return (this.owner != null ? this.owner + "/" : "") + this.name;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public String toString() {
        String desc = this.getDesc();
        return String.format("%s%s%s", this.getName(), desc != null ? " " : "", desc != null ? desc : "");
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }
}

