/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private IMixinService service = null;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private static MixinService instance;
    private static final Logger logger;
    private static final NMSLException \u6bcf\u6b21\u548c\u5c0f\u590f\u89c1\u9762;

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    static {
        \u6bcf\u6b21\u548c\u5c0f\u590f\u89c1\u9762 = new NMSLException("\ua680\u4de1\u2708\u37f0\u4dde\u27a9\u3950\u4dfe\u4dd7\u26c2\u2611\u4de9\u4dd6\ua647\u2718\u4dec\u4dde\u4ddc\u4dcc\u4df3\u3b81\u3d94\u4dc7\u4dd8\u4dd6\u4ddb\u3d75\u4df9\u26d2\ua64e\u4ddd\u2785\u4dfe\u26ea\ua65c\u3650\u35c5\u3e53\u4dfe\ua652\u4dc8\u4dfe\u2789\ua660");
        logger = LogManager.getLogger((String)"mixin");
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private MixinService() {
        this.runBootServices();
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }
}

