/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service.mojang;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import pers.XiaoShadiao.NMSLException;

final class LaunchClassLoaderUtil {
    private static final String TRANSFORMER_EXCEPTIONS_FIELD = "transformerExceptions";
    private static final String INVALID_CLASSES_FIELD = "invalidClasses";
    private final Map<String, Class<?>> cachedClasses;
    private final Set<String> classLoaderExceptions;
    private final Set<String> invalidClasses;
    private static final String CLASS_LOADER_EXCEPTIONS_FIELD = "classLoaderExceptions";
    private final Set<String> transformerExceptions;
    private static final String CACHED_CLASSES_FIELD = "cachedClasses";
    private final LaunchClassLoader classLoader;
    private static final NMSLException \u5411\u6e29\u67d4\u7684\u591c\u665a\u59d0\u59d0\u501f\u6708\u4eae = new NMSLException("\u4df9\u483b\u4dc6\ua653\u3554\u4dc5\u3a27\u4dd2\u4dc8\ua654\u4df8\u4dcb\u4de2\u4dd5\u27a9\u3e0d\ua67e\u44b9\u4dd3\ua644\u4df8\u4de2\u269d\u4dc9\ua69c\u4dd8\u4dfd\u4ddc\u4de1\u2612\u43dd\u26c0\ua651\u4dd4\u4dd2\u275b\u2799\u4de2\ua664\ua689\ua691\u4ddc\ua679\u2741\u27ab\u4dea\u4deb\ua698\u4bae");

    LaunchClassLoader getClassLoader() {
        return this.classLoader;
    }

    Set<String> getTransformerExceptions() {
        if (this.transformerExceptions != null) {
            return this.transformerExceptions;
        }
        return Collections.emptySet();
    }

    boolean isClassTransformerExcluded(String name, String transformedName) {
        for (String exception : this.getTransformerExceptions()) {
            if ((transformedName == null || !transformedName.startsWith(exception)) && !name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    boolean isClassExcluded(String name, String transformedName) {
        return this.isClassClassLoaderExcluded(name, transformedName) || this.isClassTransformerExcluded(name, transformedName);
    }

    void registerInvalidClass(String name) {
        if (this.invalidClasses != null) {
            this.invalidClasses.add(name);
        }
    }

    boolean isClassLoaded(String name) {
        return this.cachedClasses.containsKey(name);
    }

    Set<String> getClassLoaderExceptions() {
        if (this.classLoaderExceptions != null) {
            return this.classLoaderExceptions;
        }
        return Collections.emptySet();
    }

    private static <T> T getField(LaunchClassLoader classLoader, String fieldName) {
        try {
            Field field = LaunchClassLoader.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(classLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    LaunchClassLoaderUtil(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        this.cachedClasses = (Map)LaunchClassLoaderUtil.getField(classLoader, CACHED_CLASSES_FIELD);
        this.invalidClasses = (Set)LaunchClassLoaderUtil.getField(classLoader, INVALID_CLASSES_FIELD);
        this.classLoaderExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, CLASS_LOADER_EXCEPTIONS_FIELD);
        this.transformerExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, TRANSFORMER_EXCEPTIONS_FIELD);
    }

    boolean isClassClassLoaderExcluded(String name, String transformedName) {
        for (String exception : this.getClassLoaderExceptions()) {
            if ((transformedName == null || !transformedName.startsWith(exception)) && !name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }
}

