/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import pers.XiaoShadiao.NMSLException;

public class ClassSignature {
    private final Deque<String> rawInterfaces;
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    protected static final String OBJECT = "java/lang/Object";
    private Token superClass = new Token("java/lang/Object");
    private final List<Token> interfaces = new ArrayList<Token>();
    private static final NMSLException \u60b2\u4f24\u7684\u65f6\u5019 = new NMSLException("\u26ec\ua66d\ua647\u4de8\u2780\u2701\u27b3\u4dfd\u4dfa\ua65d\u4df3\u26cc\u269f\u4dcd\u4dec\u3a72\u45d3\u4dc6\ua64c\u4dff\u4df5\ua66c\u4dce\u27bd\u4dc8\u2784\u4dc3\ua644\u277b\u2725\u27a2\u4d7c\u278e\u4dc7\u3af6\u472c\u4de1\u4dd5\u2725\u2746\u4de7\u2796\u4dd3\u268b\u4de4\u4dcd\u273c\ua690\u4de4");

    private String findOffsetName(char c, Set<String> typeVars) {
        return this.findOffsetName(c, typeVars, "", "");
    }

    private ClassSignature read(String signature) {
        if (signature != null) {
            try {
                new SignatureReader(signature).accept(new SignatureParser());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this;
    }

    public void addInterface(String iface) {
        this.rawInterfaces.add(iface);
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    public String getSuperClass() {
        return this.superClass.asType(true);
    }

    private String findUniqueName(String typeVar, Set<String> typeVars) {
        String name;
        if (!typeVars.contains(typeVar)) {
            return typeVar;
        }
        if (typeVar.length() == 1 && (name = this.findOffsetName(typeVar.charAt(0), typeVars)) != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, typeVar, "");
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "T", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar + "Type");
        if (name != null) {
            return name;
        }
        throw new IllegalStateException("Failed to conform type var: " + typeVar);
    }

    public void merge(ClassSignature other) {
        try {
            HashSet<String> typeVars = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                typeVars.add(typeVar.toString());
            }
            other.conform(typeVars);
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<TypeVar, TokenHandle> type : other.types.entrySet()) {
            this.addTypeVar(type.getKey(), type.getValue());
        }
        for (Token iface : other.interfaces) {
            this.addInterface(iface);
        }
    }

    protected void setSuperClass(Token superClass) {
        this.superClass = superClass;
    }

    protected void addInterface(Token iface) {
        if (!iface.isRaw()) {
            String raw = iface.asType(true);
            ListIterator<Token> iter = this.interfaces.listIterator();
            while (iter.hasNext()) {
                Token intrface = iter.next();
                if (!intrface.isRaw() || !intrface.asType(true).equals(raw)) continue;
                iter.set(iface);
                return;
            }
        }
        this.interfaces.add(iface);
    }

    private String findOffsetName(char c, Set<String> typeVars, String prefix, String suffix) {
        String name = String.format("%s%s%s", prefix, Character.valueOf(c), suffix);
        if (!typeVars.contains(name)) {
            return name;
        }
        if (c > '@' && c < '[') {
            int s = c - 64;
            while (s + 65 != c) {
                name = String.format("%s%s%s", prefix, Character.valueOf((char)(s + 65)), suffix);
                if (!typeVars.contains(name)) {
                    return name;
                }
                ++s;
                s %= 26;
            }
        }
        return null;
    }

    protected String getTypeVar(TokenHandle handle) {
        for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
            TypeVar typeVar = type.getKey();
            TokenHandle typeHandle = type.getValue();
            if (handle != typeHandle && handle.asToken() != typeHandle.asToken()) continue;
            return "T" + typeVar + ";";
        }
        return handle.token.asType();
    }

    protected TokenHandle getType(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle handle = new TokenHandle();
        this.types.put(new TypeVar(varName), handle);
        return handle;
    }

    protected void addRawInterface(String iface) {
        Token token = new Token(iface);
        String raw = token.asType(true);
        for (Token intrface : this.interfaces) {
            if (!intrface.asType(true).equals(raw)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder sb = new StringBuilder();
        if (this.types.size() > 0) {
            boolean valid = false;
            StringBuilder types = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
                String bound = type.getValue().asBound();
                if (bound.isEmpty()) continue;
                types.append(type.getKey()).append(':').append(bound);
                valid = true;
            }
            if (valid) {
                sb.append('<').append((CharSequence)types).append('>');
            }
        }
        sb.append(this.superClass.asType());
        for (Token iface : this.interfaces) {
            sb.append(iface.asType());
        }
        return sb.toString();
    }

    protected TypeVar getTypeVar(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return typeVar;
        }
        return null;
    }

    ClassSignature() {
        this.rawInterfaces = new LinkedList<String>();
    }

    public ClassSignature wake() {
        return this;
    }

    private void conform(Set<String> typeVars) {
        for (TypeVar typeVar : this.types.keySet()) {
            String name = this.findUniqueName(typeVar.getOriginalName(), typeVars);
            typeVar.rename(name);
            typeVars.add(name);
        }
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle handle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException("TypeVar " + typeVar + " is already present on " + this);
        }
        this.types.put(typeVar, handle);
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature generated = new ClassSignature();
        generated.setSuperClass(new Token(classNode.superName != null ? classNode.superName : OBJECT));
        for (String iface : classNode.interfaces) {
            generated.addInterface(new Token(iface));
        }
        return generated;
    }

    public static ClassSignature of(String signature) {
        return new ClassSignature().read(signature);
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();
        private static final NMSLException \u4e00\u4e2a\u4eba\u625b\u4e0b\u6240\u6709\u771f\u662f\u574f\u4e60\u60ef\u5440 = new NMSLException("\ua65e\u2643\u26b5\u4de1\u4dc2\u4dce\u4ddc\u269e\u26e8\u4de9\u4dc5\ua65e\ua69c\u272b\u4de0\u3d1b\u27ba\ua691\u3464\u4dcd\u4de8\u4deb\u4306\u4dd7\ua663\u4dc0\u3a8d\u4dfd\u4dc8\u4dd2\u26e8\u36cd\u26dc");

        @Override
        public void visitTypeVariable(String name) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(name) && (typeVar = ClassSignature.this.getTypeVar(name)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(name);
        }

        SignatureRemapper() {
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.localTypeVars.add(name);
            super.visitFormalTypeParameter(name);
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;
        private static final NMSLException \u4e3a\u4e86\u7ef4\u62a4\u65c5\u9014\u7684\u548c\u5e73 = new NMSLException("\u4dd5\u4deb\u277e\u4dde\u4dcc\u2650\u26c6\u4ddf\u4de9\u4dfb\u2764\u276d\u4dd8\u4dfb\u4dd8\u4dc4\u4dc5\u4de1\u342f\u4de9\u4dd7\ua644\u3f1f\u4dca\u4a7c\u263e\u4dd9\u4df5\u2715\u2694\u4df5\u4dee\ua67a\u265a\u26b9\u340f\u4d0e\u270f\u4c02\u4ddb\u270f\u274c");

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.param = new FormalParamElement(name);
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        SignatureParser() {
            super(327680);
        }

        class InterfaceElement
        extends TokenElement {
            private static final NMSLException \u4e00\u4e2a\u4eba\u625b\u4e0b\u6240\u6709\u771f\u662f\u574f\u4e60\u60ef\u5440 = new NMSLException("\u4de9\u4dfb\ua667\u4deb\u2687\u4dec\u3fa4\u4dca\u4df7\u271c\u4de0\u4dd1\u40ca\ua687\u2661\ua68d\u4dea\u4df2\u4de3\u4ceb\u2700\u4dd1\u2750\u4de1\u4dff\u27b1\u4dd2\u4dfa\u4dd2\u4dfa\u45a7\ua685\u264c\u269a\u4dd8\u4dfb\ua648\u26ff");

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }

            InterfaceElement() {
            }
        }

        class SuperClassElement
        extends TokenElement {
            private static final NMSLException \u795e\u8c15\u4e5f\u4e0d\u4f1a\u5b9e\u73b0 = new NMSLException("\u4df4\u4de2\u4df3\u26a5\u2784\u4df3\u266c\u4dfb\u4dcf\u4dfb\u4c68\u4dd9\u4ded\ua668\u4dc1\ua65d\u4dd7\u4df4\u3ad4\u26db\u270d\u2690\u4588\u4dd8\u268a\u4def\u4dcf\u4de4\ua68a\u4dea");

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }

            SuperClassElement() {
            }
        }

        class BoundElement
        extends TokenElement {
            private final TokenElement type;
            private final boolean classBound;
            private static final NMSLException \u65e9\u4e0a = new NMSLException("\u4dd5\u26b9\u267a\u4dc3\u2672\u4dc6\u4dc2\u4dcf\u3f83\u4dee\u4ddf\u4df1\ua658\ua677\u4df9\u4de9\u2641\ua686\u4df8\u4dcb\u4dc2\u261f\u4ddb\u4dfd\u4502\u4de9\u4de6\u4dc6\ua688\u4dd5\ua673\u26f6\u2731\u4dec\u2624");

            @Override
            public void visitClassType(String name) {
                this.token = this.type.token.addBound(name, this.classBound);
            }

            BoundElement(TokenElement type, boolean classBound) {
                this.type = type;
                this.classBound = classBound;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final char wildcard;
            private final TokenElement type;
            private static final NMSLException \u6211\u652f\u6301 = new NMSLException("\u2616\ua670\u272f\u26c2\u4df0\u4deb\u4df2\u3dbd\u4dd5\u4dc4\u4dd4\ua68a\u4dd3\u4dc7\u2668\ua64e\ua68e\u4deb\u4de0\u26a7\u2788\u4de4\ua648\ua66f\u4de4\u4dc5\u4dc5\u4de0\ua665\u4dc4\u4dfe\u4dda\u4dc3\u4def\u4de5\u4de8\u4dcd\u2609\u4deb\u4dfb\u4de0\u4ddd\u4dda\u4dde\u2747");

            @Override
            public void visitTypeVariable(String name) {
                TokenHandle token = ClassSignature.this.getType(name);
                this.token = this.type.addTypeArgument(token).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.token = this.type.addTypeArgument(descriptor).asToken();
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }

            @Override
            public void visitClassType(String name) {
                this.token = this.type.addTypeArgument(name).setWildcard(this.wildcard).asToken();
            }

            TypeArgElement(TokenElement type, char wildcard) {
                this.type = type;
                this.wildcard = wildcard;
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;
            private static final NMSLException \u90fd\u5feb\u624e\u4e0d\u8d77\u6765\u4e86 = new NMSLException("\u4dc5\u4def\u4de8\u4df0\u4de9\u4ddc\u265d\u2774\u26cd\u4df8\ua685\u4dde\u46be\u275c\u267e\ua65e\u274b\u26ed\u4dea\u4de8\u4dd3\u476c\u4dec\u2649\u4deb\u4df4\u2799\u3ea2\u4c3e\u26e2");

            FormalParamElement(String param) {
                this.handle = ClassSignature.this.getType(param);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            private boolean array;
            protected Token token;
            private static final NMSLException \u7ed9\u4f60\u4e00\u4e2a\u5927\u62c7\u6307 = new NMSLException("\u27a4\u260f\ua67f\u2735\u2692\u4df7\u4c30\u4de3\u2714\u26cb\u27ab\ua697\u4ddb\ua68d\u3d9e\u276b\u4df8\u26a3\u44cc\u2704\u2649\u4dcc\u4dfc\u4dda\u3c21\u4dc9\u269c\u27b1\u352f\u3b33\u26c2\u4dda\u4dd3\u2637\u4dd1\u35f6\u4c22\u4dc7\u4dec\u4de5\u4de3\u2694\u2741");

            Token addTypeArgument() {
                return this.token.addTypeArgument('*').asToken();
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            protected void setArray() {
                this.array = true;
            }

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            @Override
            public void visitInnerClassType(String name) {
                this.token.addInnerClass(name);
            }

            IToken addTypeArgument(TokenHandle token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            IToken addTypeArgument(char symbol) {
                return this.token.addTypeArgument(symbol).setArray(this.getArray());
            }

            IToken addTypeArgument(String name) {
                return this.token.addTypeArgument(name).setArray(this.getArray());
            }

            TokenElement() {
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            private boolean getArray() {
                boolean array = this.array;
                this.array = false;
                return array;
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, false);
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, true);
            }

            @Override
            public void visitClassType(String name) {
                this.getToken().setType(name);
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            private static final NMSLException \u7f07\u5b89\u6253\u574f\u86cb = new NMSLException("\u26e7\u4ddf\u4df4\u4dc5\u4ce6\ua681\u4de1\u2684\ua687\u268e\u26e8\u4dde\u2789\u3ed5\ua65d\u274e\ua640\u4dc1\u4de3\u4de2\ua648\u3bb7\u3c5a\u26eb\u4df0\u4ddf\u4df5\u37cb\u2730\u273a\u428c\u2748\u267b\ua69d\u4472\u4dd5\u4de2\u4dec\u260f\u4dc1\u4dce\u4ded\u4dfe");

            public SignatureElement() {
                super(327680);
            }
        }
    }

    class TokenHandle
    implements IToken {
        char wildcard;
        boolean array;
        final Token token;
        private static final NMSLException \u68d2 = new NMSLException("\u270d\u4df5\u4820\ua65a\u4de7\u2786\u26e7\u4dfb\u270a\u4dfa\u4dff\u37d9\u270e\u4615\u2745\u4dc4\u4df8\u4dc9\ua694\u4dcd\u4dc7\u4dde\u4dee\u2606\u3a4b\u2728\u2685\u355d\ua661\ua66e\u27b1");

        public String toString() {
            return this.token.toString();
        }

        @Override
        public String asType() {
            StringBuilder sb = new StringBuilder();
            if (this.wildcard > '\u0000') {
                sb.append(this.wildcard);
            }
            if (this.array) {
                sb.append('[');
            }
            return sb.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }

        TokenHandle(Token token) {
            this.token = token;
        }

        TokenHandle() {
            this(new Token());
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) > -1) {
                this.wildcard = wildcard;
            }
            return this;
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }
    }

    static class Token
    implements IToken {
        private List<IToken> suffix;
        private Token tail;
        private final boolean inner;
        private List<Token> ifaceBound;
        private List<Token> classBound;
        private boolean array;
        private String type;
        static final String SYMBOLS = "+-*";
        private List<IToken> signature;
        private char symbol = '\u0000';
        private static final NMSLException \u7f07\u5b9d\u4e0d\u6015 = new NMSLException("\u26b2\ua653\u27a5\u4dc6\ua66d\u4dce\u4de8\u4dcd\u2787\u4dc3\u4dc2\u4dcd\u2738\u4df1\u260a\u4df9\ua666\u4de6\u27b0\u396a\u2692\ua67a\u4dd6\u26b5\u4dd7\u4df3\u3989\u4de7\u27ab\u4dc4\u34e8\u4ded\u4df5");

        @Override
        public String asBound() {
            StringBuilder sb = new StringBuilder();
            if (this.type != null) {
                sb.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    sb.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    sb.append(':').append(token.asType());
                }
            }
            return sb.toString();
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }

        String getClassType() {
            return this.type != null ? this.type : ClassSignature.OBJECT;
        }

        Token(char symbol) {
            this();
            this.symbol = symbol;
        }

        @Override
        public Token asToken() {
            return this;
        }

        Token(String type, boolean inner) {
            this.inner = inner;
            this.type = type;
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        Token addInterfaceBound(String bound) {
            Token token = new Token(bound);
            this.getIfaceBound().add(token);
            return token;
        }

        Token(boolean inner) {
            this(null, inner);
        }

        Token() {
            this(false);
        }

        boolean hasInterfaceBound() {
            return this.ifaceBound != null;
        }

        IToken addTypeArgument(char symbol) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(symbol);
            }
            Token token = new Token(symbol);
            this.getSignature().add(token);
            return token;
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        Token setSymbol(char symbol) {
            if (this.symbol == '\u0000' && SYMBOLS.indexOf(symbol) > -1) {
                this.symbol = symbol;
            }
            return this;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) == -1) {
                return this;
            }
            return this.setSymbol(wildcard);
        }

        IToken addTypeArgument(TokenHandle token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            Object handle = token.clone();
            this.getSignature().add((IToken)handle);
            return handle;
        }

        IToken addTypeArgument(String name) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(name);
            }
            Token token = new Token(name);
            this.getSignature().add(token);
            return token;
        }

        Token addClassBound(String bound) {
            Token token = new Token(bound);
            this.getClassBound().add(token);
            return token;
        }

        boolean isRaw() {
            return this.signature == null;
        }

        Token setType(String type) {
            if (this.type == null) {
                this.type = type;
            }
            return this;
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        @Override
        public String asType() {
            return this.asType(false);
        }

        public String asType(boolean raw) {
            StringBuilder sb = new StringBuilder();
            if (this.array) {
                sb.append('[');
            }
            if (this.symbol != '\u0000') {
                sb.append(this.symbol);
            }
            if (this.type == null) {
                return sb.toString();
            }
            if (!this.inner) {
                sb.append('L');
            }
            sb.append(this.type);
            if (!raw) {
                if (this.signature != null) {
                    sb.append('<');
                    for (IToken token : this.signature) {
                        sb.append(token.asType());
                    }
                    sb.append('>');
                }
                if (this.suffix != null) {
                    for (IToken token : this.suffix) {
                        sb.append('.').append(token.asType());
                    }
                }
            }
            if (!this.inner) {
                sb.append(';');
            }
            return sb.toString();
        }

        Token(String type) {
            this(type, false);
        }

        Token addInnerClass(String name) {
            this.tail = new Token(name, true);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        public String toString() {
            return this.asType();
        }

        boolean hasClassBound() {
            return this.classBound != null;
        }

        Token addBound(String bound, boolean classBound) {
            if (classBound) {
                return this.addClassBound(bound);
            }
            return this.addInterfaceBound(bound);
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public IToken setArray(boolean var1);

        public Token asToken();

        public String asBound();

        public String asType();

        public IToken setWildcard(char var1);
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private final String originalName;
        private String currentName;
        private static final NMSLException \u4e00 = new NMSLException("\u4dcc\u4def\u4df8\u4dd3\u4ddf\u26c7\u4de8\u4ddf\u487f\u4df9\u4de6\u4df4\u4dcc\u275c\u4dd6\u4dc2\u2715\u4dfd\u4734\u4df1\ua69f\u400d\u4dde\u2690\ua67b\u2759\ua66c\u4dfb\u4de2\ua653\ua686\u4dd4\ua660\u4ddc\ua688\u3f73\u2626\u4ded\u27b6\u2646\u3b93\u2610");

        String getOriginalName() {
            return this.originalName;
        }

        public boolean equals(Object obj) {
            return this.currentName.equals(obj);
        }

        public String toString() {
            return this.currentName;
        }

        public boolean matches(String originalName) {
            return this.originalName.equals(originalName);
        }

        @Override
        public int compareTo(TypeVar other) {
            return this.currentName.compareTo(other.currentName);
        }

        TypeVar(String name) {
            this.currentName = this.originalName = name;
        }

        void rename(String name) {
            this.currentName = name;
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }
    }

    static class Lazy
    extends ClassSignature {
        private final String sig;
        private ClassSignature generated;
        private static final NMSLException \u8eab\u4f53\u597d = new NMSLException("\ua694\u4df3\u4dd6\u2799\u39ac\u4dee\u2630\u4dcb\u3cc3\ua687\u270c\u4ddb\u275b\u266b\u4de9\u4dc9\u4add\ua640\u26ca\u2752\u273f\u4ddb\u4dd1\u2763\u4df1\u26cd\ua688\u4dff\u4ded\u4dc3\u4675\u3e30\u278b\u4ba5\u34b7\u4dec\u4dc8");

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }

        Lazy(String sig) {
            this.sig = sig;
        }
    }
}

