/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.NMSLException;

public final class ConstraintParser {
    private static final NMSLException \u522e\u8d77\u5927\u98ce\u7684\u65f6\u5019 = new NMSLException("\u394c\u4dcb\u269c\u4dec\u4ded\u4dda\u26eb\u47e3\u4456\ua643\u2725\u4dd5\u4df1\u409c\u4dd3\u265f\u27a7\u3eec\u3b3a\u4dd7\u2640\u4df5\ua69e\u4df0\u4de1\u270e\u39e8\ua650\u2772\ua65b\u4dfc\ua641\ua656\u4dff\ua666\u273c\u4dc1\u4de8\u279f\u4dd8\u26a4");

    private ConstraintParser() {
    }

    public static Constraint parse(String expr) {
        if (expr == null || expr.length() == 0) {
            return Constraint.NONE;
        }
        String[] exprs = expr.replaceAll("\\s", "").toUpperCase().split(";");
        Constraint head = null;
        for (String subExpr : exprs) {
            Constraint next = new Constraint(subExpr);
            if (head == null) {
                head = next;
                continue;
            }
            head.append(next);
        }
        return head != null ? head : Constraint.NONE;
    }

    public static Constraint parse(AnnotationNode annotation) {
        String constraints = Annotations.getValue(annotation, "constraints", "");
        return ConstraintParser.parse(constraints);
    }

    public static class Constraint {
        private final String expr;
        public static final Constraint NONE;
        private int min = Integer.MIN_VALUE;
        private String token;
        private static final Pattern pattern;
        private int max = Integer.MAX_VALUE;
        private Constraint next;
        private String[] constraint;
        private static final NMSLException \u603b\u89c9\u5f97\u4ed6\u80cc\u8d1f\u4e86\u592a\u591a\u4e1c\u897f;

        private boolean has(int index) {
            return this.constraint[index] != null;
        }

        Constraint(String expr) {
            this.expr = expr;
            Matcher matcher = pattern.matcher(expr);
            if (!matcher.matches()) {
                throw new InvalidConstraintException("Constraint syntax was invalid parsing: " + this.expr);
            }
            this.token = matcher.group(1);
            this.constraint = new String[]{matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8)};
            this.parse();
        }

        public void check(ITokenProvider environment) throws ConstraintViolationException {
            if (this != NONE) {
                Integer value = environment.getToken(this.token);
                if (value == null) {
                    throw new ConstraintViolationException("The token '" + this.token + "' could not be resolved in " + environment, this);
                }
                if (value < this.min) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is less than the minimum value " + this.min + " in " + environment, this, (int)value);
                }
                if (value > this.max) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is greater than the maximum value " + this.max + " in " + environment, this, (int)value);
                }
            }
            if (this.next != null) {
                this.next.check(environment);
            }
        }

        private Constraint() {
            this.expr = null;
            this.token = "*";
            this.constraint = new String[0];
        }

        private int val(int index) {
            return this.constraint[index] != null ? Integer.parseInt(this.constraint[index]) : 0;
        }

        static {
            \u603b\u89c9\u5f97\u4ed6\u80cc\u8d1f\u4e86\u592a\u591a\u4e1c\u897f = new NMSLException("\u26e2\u4de8\u27a8\u4dca\u26e1\u2732\u276d\u4dda\u270f\u2662\u4dd1\u4dcb\u2757\u4df1\u4dc6\u4dd7\u4dea\u4dec\u4dd3\u4673\u2644\u4de4\u4de6\u268b\u26cc\ua66d\u38a2\u279b\u4df6\u4dd2\ua685\u2671\u27a6\ua655\u4dc5\u262b\u4ddb\u4dc2\u4c39\u4dce\u2770\u277e\u4dcb\ua68e\u26c3\ua667\u4dee\u3d87\u4ded");
            NONE = new Constraint();
            pattern = Pattern.compile("^([A-Z0-9\\-_\\.]+)\\((?:(<|<=|>|>=|=)?([0-9]+)(<|(-)([0-9]+)?|>|(\\+)([0-9]+)?)?)?\\)$");
        }

        void append(Constraint next) {
            if (this.next != null) {
                this.next.append(next);
                return;
            }
            this.next = next;
        }

        private String elem(int index) {
            return this.constraint[index];
        }

        public int getMax() {
            return this.max;
        }

        private void parse() {
            if (!this.has(1)) {
                return;
            }
            this.min = this.val(1);
            this.max = this.min++;
            boolean hasModifier = this.has(0);
            if (this.has(4)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.val(4);
                if (this.max < this.min) {
                    throw new InvalidConstraintException("Invalid range specified '" + this.max + "' is less than " + this.min + " in " + this.expr);
                }
                return;
            }
            if (this.has(6)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.min + this.val(6);
                return;
            }
            if (hasModifier) {
                if (this.has(3)) {
                    throw new InvalidConstraintException("Unexpected trailing modifier '" + this.elem(3) + "' in " + this.expr);
                }
                String leading = this.elem(0);
                if (">".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if (">=".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if ("<".equals(leading)) {
                    this.max = --this.min;
                    this.min = Integer.MIN_VALUE;
                } else if ("<=".equals(leading)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                }
            } else if (this.has(2)) {
                String trailing = this.elem(2);
                if ("<".equals(trailing)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                } else {
                    this.max = Integer.MAX_VALUE;
                }
            }
        }

        public String getToken() {
            return this.token;
        }

        public String getRangeHumanReadable() {
            if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
                return "ANY VALUE";
            }
            if (this.min == Integer.MIN_VALUE) {
                return String.format("less than or equal to %d", this.max);
            }
            if (this.max == Integer.MAX_VALUE) {
                return String.format("greater than or equal to %d", this.min);
            }
            if (this.min == this.max) {
                return String.format("%d", this.min);
            }
            return String.format("between %d and %d", this.min, this.max);
        }

        public int getMin() {
            return this.min;
        }

        public String toString() {
            return String.format("Constraint(%s [%d-%d])", this.token, this.min, this.max);
        }
    }
}

