/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pers.XiaoShadiao.NMSLException;

public class PrettyPrinter {
    protected int width = 100;
    private final List<Object> lines;
    protected int kvKeyWidth = 10;
    protected String kvFormat;
    private boolean recalcWidth = false;
    private final HorizontalRule horizontalRule = new HorizontalRule('*');
    private Table table;
    protected int wrapWidth = 80;
    private static final NMSLException \u5927\u574f\u86cb = new NMSLException("\u4dc1\u263b\u279e\u4df0\u4ddd\u277e\u4de8\u2732\u2793\ua688\u4dd3\u4dd6\u2740\ua681\ua663\u4dcb\ua649\u4d1b\u3673\u26f4\u4dd8\ua640\u4dff\u4dc5\u4dc6\u4ddf\u279f\u48c7\u4de8\u4df6\u26e0\ua699\u4c98\u4dde\u271f\u4dc3\u2690\u4dc2\u263c\u2761\u4de3\u26c2\u4ddd\u26b8\ua683\u4dd8\u276e");

    private void updateWidth() {
        if (this.recalcWidth) {
            this.recalcWidth = false;
            for (Object line : this.lines) {
                if (!(line instanceof IVariableWidthEntry)) continue;
                this.width = Math.min(4096, Math.max(this.width, ((IVariableWidthEntry)line).getWidth()));
            }
        }
    }

    public PrettyPrinter th() {
        return this.th(false);
    }

    private static String getDefaultLoggerName() {
        String name = new Throwable().getStackTrace()[2].getClassName();
        int pos = name.lastIndexOf(46);
        return pos == -1 ? name : name.substring(pos + 1);
    }

    public PrettyPrinter add() {
        this.addLine("");
        return this;
    }

    public PrettyPrinter trace(PrintStream stream, String logger, Level level) {
        return this.trace(stream, LogManager.getLogger((String)logger), level);
    }

    private static String makeKvFormat(int keyWidth) {
        return String.format("%%%ds : %%s", keyWidth);
    }

    public PrettyPrinter add(Object[] array) {
        return this.add(array, "%s");
    }

    public PrettyPrinter table(Object ... format) {
        this.table = new Table();
        Column column = null;
        for (Object entry : format) {
            if (entry instanceof String) {
                column = this.table.addColumn((String)entry);
                continue;
            }
            if (entry instanceof Integer && column != null) {
                int width = (Integer)entry;
                if (width > 0) {
                    column.setWidth(width);
                    continue;
                }
                if (width >= 0) continue;
                column.setMaxWidth(-width);
                continue;
            }
            if (entry instanceof Alignment && column != null) {
                column.setAlignment((Alignment)((Object)entry));
                continue;
            }
            if (entry == null) continue;
            column = this.table.addColumn(entry.toString());
        }
        return this;
    }

    private void addLine(Object line) {
        if (line == null) {
            return;
        }
        this.lines.add(line);
        this.recalcWidth |= line instanceof IVariableWidthEntry;
    }

    private PrettyPrinter append(Object object, int indent, String margin) {
        if (object instanceof String) {
            return this.add("%s%s", margin, object);
        }
        if (object instanceof Iterable) {
            for (Object entry : (Iterable)object) {
                this.append(entry, indent, margin);
            }
            return this;
        }
        if (object instanceof Map) {
            this.kvWidth(indent);
            return this.add((Map)object);
        }
        if (object instanceof IPrettyPrintable) {
            return this.add((IPrettyPrintable)object);
        }
        if (object instanceof Throwable) {
            return this.add((Throwable)object, indent);
        }
        if (object.getClass().isArray()) {
            return this.add((Object[])object, indent + "%s");
        }
        return this.add("%s%s", margin, object);
    }

    public static void print(Throwable th) {
        new PrettyPrinter().add(th).print(System.err);
    }

    public PrettyPrinter trace(PrintStream stream, Logger logger, Level level) {
        this.log(logger, level);
        this.print(stream);
        return this;
    }

    public PrettyPrinter hr() {
        return this.hr('*');
    }

    public int wrapTo() {
        return this.wrapWidth;
    }

    public PrettyPrinter trace(PrintStream stream, Level level) {
        return this.trace(stream, PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter centre() {
        Object lastLine;
        if (!this.lines.isEmpty() && (lastLine = this.lines.get(this.lines.size() - 1)) instanceof String) {
            this.addLine(new CentredText(this.lines.remove(this.lines.size() - 1)));
        }
        return this;
    }

    public PrettyPrinter add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey() == null ? "null" : entry.getKey().toString();
            this.kv(key, entry.getValue());
        }
        return this;
    }

    private void logString(Logger logger, Level level, String line) {
        if (line != null) {
            logger.log(level, String.format("/* %-" + this.width + "s */", line));
        }
    }

    public PrettyPrinter add(Object object, int indent) {
        String margin = Strings.repeat((String)" ", (int)indent);
        return this.append(object, indent, margin);
    }

    public PrettyPrinter hr(char ruleChar) {
        this.addLine(new HorizontalRule(ruleChar));
        return this;
    }

    public PrettyPrinter trace(Logger logger) {
        return this.trace(System.err, logger);
    }

    private PrettyPrinter th(boolean onlyIfNeeded) {
        if (this.table == null) {
            this.table = new Table();
        }
        if (!onlyIfNeeded || this.table.addHeader) {
            this.table.headerAdded();
            this.addLine(this.table);
        }
        return this;
    }

    public PrettyPrinter trace(Level level) {
        return this.trace(PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(String logger, Level level) {
        return this.trace(System.err, LogManager.getLogger((String)logger), level);
    }

    public PrettyPrinter tr(Object ... args) {
        this.th(true);
        this.addLine(this.table.addRow(args));
        this.recalcWidth = true;
        return this;
    }

    public PrettyPrinter add(String format, Object ... args) {
        String line = String.format(format, args);
        this.addLine(line);
        this.width = Math.max(this.width, line.length());
        return this;
    }

    public PrettyPrinter addIndexed(Object[] array) {
        int indexWidth = String.valueOf(array.length - 1).length();
        String format = "[%" + indexWidth + "d] %s";
        for (int index = 0; index < array.length; ++index) {
            this.add(format, index, array[index]);
        }
        return this;
    }

    public PrettyPrinter print(PrintStream stream) {
        this.updateWidth();
        this.printSpecial(stream, this.horizontalRule);
        for (Object line : this.lines) {
            if (line instanceof ISpecialEntry) {
                this.printSpecial(stream, (ISpecialEntry)line);
                continue;
            }
            this.printString(stream, line.toString());
        }
        this.printSpecial(stream, this.horizontalRule);
        return this;
    }

    public PrettyPrinter add(StackTraceElement[] stackTrace, int indent) {
        String margin = Strings.repeat((String)" ", (int)indent);
        for (StackTraceElement st : stackTrace) {
            this.add("%s%s", margin, st);
        }
        return this;
    }

    public PrettyPrinter trace(PrintStream stream) {
        return this.trace(stream, PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter table(String ... titles) {
        this.table = new Table();
        for (String title : titles) {
            this.table.addColumn(title);
        }
        return this;
    }

    private void printSpecial(PrintStream stream, ISpecialEntry line) {
        stream.printf("/*%s*/\n", line.toString());
    }

    public static void dumpStack() {
        new PrettyPrinter().add(new Exception("Stack trace")).print(System.err);
    }

    public PrettyPrinter addWithIndices(Collection<?> c) {
        return this.addIndexed(c.toArray());
    }

    public PrettyPrinter add(IPrettyPrintable printable) {
        if (printable != null) {
            printable.print(this);
        }
        return this;
    }

    public PrettyPrinter log(Logger logger, Level level) {
        this.updateWidth();
        this.logSpecial(logger, level, this.horizontalRule);
        for (Object line : this.lines) {
            if (line instanceof ISpecialEntry) {
                this.logSpecial(logger, level, (ISpecialEntry)line);
                continue;
            }
            this.logString(logger, level, line.toString());
        }
        this.logSpecial(logger, level, this.horizontalRule);
        return this;
    }

    public PrettyPrinter trace(Logger logger, Level level) {
        return this.trace(System.err, logger, level);
    }

    private List<String> getWrapped(int width, String line, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        while (line.length() > width) {
            int wrapPoint = line.lastIndexOf(32, width);
            if (wrapPoint < 10) {
                wrapPoint = width;
            }
            String head = line.substring(0, wrapPoint);
            lines.add(head);
            line = indent + line.substring(wrapPoint + 1);
        }
        if (line.length() > 0) {
            lines.add(line);
        }
        return lines;
    }

    public PrettyPrinter add(Object[] array, String format) {
        for (Object element : array) {
            this.add(format, element);
        }
        return this;
    }

    public PrettyPrinter add(Throwable th) {
        return this.add(th, 4);
    }

    public PrettyPrinter addWrapped(int width, String format, Object ... args) {
        String indent = "";
        String line = String.format(format, args).replace("\t", "    ");
        Matcher indentMatcher = Pattern.compile("^(\\s+)(.*)$").matcher(line);
        if (indentMatcher.matches()) {
            indent = indentMatcher.group(1);
        }
        try {
            for (String wrappedLine : this.getWrapped(width, line, indent)) {
                this.addLine(wrappedLine);
            }
        }
        catch (Exception ex) {
            this.add(line);
        }
        return this;
    }

    public PrettyPrinter kvWidth(int width) {
        if (width > this.kvKeyWidth) {
            this.kvKeyWidth = width;
            this.kvFormat = PrettyPrinter.makeKvFormat(width);
        }
        this.recalcWidth = true;
        return this;
    }

    public PrettyPrinter add(Object object) {
        return this.add(object, 0);
    }

    public PrettyPrinter trace(String logger) {
        return this.trace(System.err, LogManager.getLogger((String)logger));
    }

    private void logSpecial(Logger logger, Level level, ISpecialEntry line) {
        logger.log(level, "/*{}*/", new Object[]{line.toString()});
    }

    private void printString(PrintStream stream, String string) {
        if (string != null) {
            stream.printf("/* %-" + this.width + "s */\n", string);
        }
    }

    public PrettyPrinter print() {
        return this.print(System.err);
    }

    public PrettyPrinter trace(PrintStream stream, Logger logger) {
        return this.trace(stream, logger, Level.DEBUG);
    }

    public PrettyPrinter spacing(int spacing) {
        if (this.table == null) {
            this.table = new Table();
        }
        this.table.setColSpacing(spacing);
        return this;
    }

    public PrettyPrinter table() {
        this.table = new Table();
        return this;
    }

    public PrettyPrinter addWrapped(String format, Object ... args) {
        return this.addWrapped(this.wrapWidth, format, args);
    }

    public PrettyPrinter add(Throwable th, int indent) {
        while (th != null) {
            this.add("%s: %s", th.getClass().getName(), th.getMessage());
            this.add(th.getStackTrace(), indent);
            th = th.getCause();
        }
        return this;
    }

    public PrettyPrinter trace(PrintStream stream, String logger) {
        return this.trace(stream, LogManager.getLogger((String)logger));
    }

    public PrettyPrinter wrapTo(int wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public PrettyPrinter() {
        this(100);
    }

    public PrettyPrinter kv(String key, Object value) {
        this.addLine(new KeyValue(key, value));
        return this.kvWidth(key.length());
    }

    public PrettyPrinter trace() {
        return this.trace(PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter log(Logger logger) {
        return this.log(logger, Level.INFO);
    }

    public PrettyPrinter add(String string) {
        this.addLine(string);
        this.width = Math.max(this.width, string.length());
        return this;
    }

    public PrettyPrinter kv(String key, String format, Object ... args) {
        return this.kv(key, String.format(format, args));
    }

    public PrettyPrinter(int width) {
        this.lines = new ArrayList<Object>();
        this.kvFormat = PrettyPrinter.makeKvFormat(this.kvKeyWidth);
        this.width = width;
    }

    static class Row
    implements IVariableWidthEntry {
        final String[] args;
        final Table table;
        private static final NMSLException \u5c11\u8bf4\u5947\u602a\u7684\u8bdd\u5566 = new NMSLException("\u4dc5\u4de3\u4dc6\u278c\u2673\u46a0\u4dce\u4deb\u4dd3\u2775\u4ddf\u4dd8\u4adb\u37a7\u2748\ua657\u4de7\u4df6\ua643\u4dcb\u27b4\u4624\u4dfa\u4dd3\ua68a\u4de7\u2629\u2759\u4de5\u4ce2\u4dfb");

        public String toString() {
            Object[] args = new Object[this.table.columns.size()];
            for (int col = 0; col < args.length; ++col) {
                Column column = this.table.columns.get(col);
                args[col] = col >= this.args.length ? "" : (this.args[col].length() > column.getMaxWidth() ? this.args[col].substring(0, column.getMaxWidth()) : this.args[col]);
            }
            return String.format(this.table.format, args);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }

        public Row(Table table, Object ... args) {
            this.table = table.grow(args.length);
            this.args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.args[i] = args[i].toString();
                this.table.columns.get(i).setMinWidth(this.args[i].length());
            }
        }
    }

    static class Column {
        private String title = "";
        private int minWidth = 1;
        private final Table table;
        private String format = "%s";
        private int maxWidth;
        private int size = 0;
        private Alignment align = Alignment.LEFT;
        private static final NMSLException \u7f07\u5b9d\u8001\u5e08\u4fdd\u8bc1\u4f60 = new NMSLException("\u4dce\u4dc6\u390e\ua684\u262e\u4dc5\u2678\u2683\u4dec\ua67a\u4de2\u2737\u4dc5\u4dcb\u4dd7\ua662\u4dfb\u4dfc\u4dca\u4dd6\u4df9\u4dfc\u4dd8\u4dc2\u4dd0\u27ae\u3e97\u4dfc\u2787\u265e\ua699\u4dfd\u4dd9\u27a2\u2773\u4df6");

        void setMaxWidth(int width) {
            this.size = Math.min(this.size, this.maxWidth);
            this.maxWidth = Math.max(1, width);
            this.updateFormat();
        }

        Column(Table table, Alignment align, int size, String title) {
            this(table, title);
            this.align = align;
            this.size = size;
        }

        int getMaxWidth() {
            return this.maxWidth;
        }

        Column(Table table) {
            this.maxWidth = Integer.MAX_VALUE;
            this.table = table;
        }

        public String toString() {
            if (this.title.length() > this.maxWidth) {
                return this.title.substring(0, this.maxWidth);
            }
            return this.title;
        }

        private void updateFormat() {
            int width = Math.min(this.maxWidth, this.size == 0 ? this.minWidth : this.size);
            this.format = "%" + (this.align == Alignment.RIGHT ? "" : "-") + width + "s";
            this.table.updateFormat();
        }

        void setMinWidth(int width) {
            if (width > this.minWidth) {
                this.minWidth = width;
                this.updateFormat();
            }
        }

        Column(Table table, String title) {
            this(table);
            this.title = title;
            this.minWidth = title.length();
            this.updateFormat();
        }

        void setTitle(String title) {
            this.title = title;
            this.setWidth(title.length());
        }

        String getTitle() {
            return this.title;
        }

        void setWidth(int width) {
            if (width > this.size) {
                this.size = width;
                this.updateFormat();
            }
        }

        String getFormat() {
            return this.format;
        }

        void setAlignment(Alignment align) {
            this.align = align;
            this.updateFormat();
        }
    }

    static class Table
    implements IVariableWidthEntry {
        final List<Row> rows;
        int colSpacing = 2;
        String format = "%s";
        boolean addHeader = true;
        final List<Column> columns = new ArrayList<Column>();
        private static final NMSLException \u7075\u9b42\u7d6e\u8bed = new NMSLException("\u485c\u276e\u267d\u4dd5\ua67d\u4dcd\u262f\u4dd5\u276e\u4ddc\u4df0\ua68e\u4df2\u4de4\u262c\u3b60\u26a2\u3817\u2781\ua69e\u2746\u4169\u4dd9\ua66a\u26bc\ua648\u4ddc\u4dd7\u4dd1\u4df7\u4dc4\u4dc0\u4dcb\ua686\u4ddf\u4df6\u2761");

        Table grow(int size) {
            while (this.columns.size() < size) {
                this.columns.add(new Column(this));
            }
            this.updateFormat();
            return this;
        }

        Row addRow(Object ... args) {
            return this.add(new Row(this, args));
        }

        public String toString() {
            boolean nonEmpty = false;
            String[] titles = new String[this.columns.size()];
            for (int col = 0; col < this.columns.size(); ++col) {
                titles[col] = this.columns.get(col).toString();
                nonEmpty |= !titles[col].isEmpty();
            }
            return nonEmpty ? String.format(this.format, titles) : null;
        }

        void updateFormat() {
            String spacing = Strings.repeat((String)" ", (int)this.colSpacing);
            StringBuilder format = new StringBuilder();
            boolean addSpacing = false;
            for (Column column : this.columns) {
                if (addSpacing) {
                    format.append(spacing);
                }
                addSpacing = true;
                format.append(column.getFormat());
            }
            this.format = format.toString();
        }

        Column add(Column column) {
            this.columns.add(column);
            return column;
        }

        void setColSpacing(int spacing) {
            this.colSpacing = Math.max(0, spacing);
            this.updateFormat();
        }

        String getFormat() {
            return this.format;
        }

        @Override
        public int getWidth() {
            String str = this.toString();
            return str != null ? str.length() : 0;
        }

        Table() {
            this.rows = new ArrayList<Row>();
        }

        void headerAdded() {
            this.addHeader = false;
        }

        Row add(Row row) {
            this.rows.add(row);
            return row;
        }

        Object[] getTitles() {
            ArrayList<String> titles = new ArrayList<String>();
            for (Column column : this.columns) {
                titles.add(column.getTitle());
            }
            return titles.toArray();
        }

        Column addColumn(Alignment align, int size, String title) {
            return this.add(new Column(this, align, size, title));
        }

        Column addColumn(String title) {
            return this.add(new Column(this, title));
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }

    class CentredText {
        private final Object centred;
        private static final NMSLException \u660e\u5929\u89c1 = new NMSLException("\u4de0\u266d\u2720\u2639\u2772\u4dc1\u4de6\u2657\u456a\u27ac\u4dd1\u278a\u4dec\u36d8\u4dd4\u4ddc\u4c4d\u273a\u27aa\u4df6\ua66a\u4dc8\ua666\u4dfe\u4deb\ua647\u4df0\u2665\u4dce\u4de9\ua65c\u3c96\ua69b\u4df8\u4de6\u4dd3");

        public CentredText(Object centred) {
            this.centred = centred;
        }

        public String toString() {
            String text = this.centred.toString();
            return String.format("%" + ((PrettyPrinter.this.width - text.length()) / 2 + text.length()) + "s", text);
        }
    }

    class HorizontalRule
    implements ISpecialEntry {
        private final char[] hrChars;
        private static final NMSLException \u60b2\u4f24\u7684\u65f6\u5019 = new NMSLException("\u4df0\ua670\u4364\u4ddf\u4ddf\u36d3\u2768\u27a9\u4dc4\u401b\u4875\u263c\u4dc7\u4df8\u3b46\ua69b\u4de0\u4dd4\u26fa\u4dd1\u448d\u3ee6\ua665\u4dd3\u4de1\u2779\u4df7\u4dc9\u278c\u274e\u4de7\ua69e\u2729\u4dc2\u4de1\u3c13\ua69f\u4dd2\u4dec\ua674\u4def\ua647\u4ddf\u4dd6\u274b\u4df5\u4dc9");

        public HorizontalRule(char ... hrChars) {
            this.hrChars = hrChars;
        }

        public String toString() {
            return Strings.repeat((String)new String(this.hrChars), (int)(PrettyPrinter.this.width + 2));
        }
    }

    class KeyValue
    implements IVariableWidthEntry {
        private final Object value;
        private final String key;
        private static final NMSLException \u5f00\u62d3\u8005 = new NMSLException("\u4df7\u4dcf\ua691\u4dfb\u4de2\u4de1\u4dc5\u2784\u4dc2\u4dc1\u4dd0\u4df3\u442c\u4dd4\u3c48\u4dc0\u4de3\u4df0\u268d\u4de9\u3c2d\u26be\u4df1\u3836\u4600\u4df5\u4dc1\u4dc1\u4deb\u4dda\u4519\u4dc1\u4dd1\u4dd0\u4df1\u2792\u4ded\u4dd8\u2653\u26df\u4df5\u2620\u4dee\u4df1\u4dc7\u4dc5\u4dfc");

        public String toString() {
            return String.format(PrettyPrinter.this.kvFormat, this.key, this.value);
        }

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static interface ISpecialEntry {
    }

    static interface IVariableWidthEntry {
        public int getWidth();
    }

    public static interface IPrettyPrintable {
        public void print(PrettyPrinter var1);
    }
}

