/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.NMSLException;

public final class Profiler {
    private boolean active;
    public static final int ROOT = 1;
    private final List<String> phases;
    public static final int FINE = 2;
    private final Deque<Section> stack;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private static final NMSLException \u660e\u5929\u7684\u660e\u5929\u89c1\u5566 = new NMSLException("\u4dc0\u4de5\ua671\u4df8\u35ad\u2695\u26b2\u260a\u4dd7\u4df9\ua673\ua681\u2784\u4dcb\u26fc\u4dd9\u4423\u4dee\u2745\u2732\ua676\u4dc1\u404c\u2690\u4dc5\u4deb\u26da\u27ae\u39bf\u3a0c\ua647\u2763\u4dc7\u4ddc\u4df0\u270b\u2739\u4df4\ua66c");

    boolean isHead(Section section) {
        return this.stack.peek() == section;
    }

    public Section get(String name) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = this.active ? new LiveSection(name, this.phases.size() - 1) : new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    private void printSectionRow(PrettyPrinter printer, int colCount, int[] columns, Section section, boolean group) {
        long[] times;
        boolean isDelegate = section.getDelegate() != section;
        Object[] values = new Object[colCount];
        int col = 1;
        values[0] = group ? (isDelegate ? "  > " + section.getBaseName() : section.getName()) : (isDelegate ? "+ " : "  ") + section.getName();
        for (long time : times = section.getTimes()) {
            if (col == columns[1]) {
                values[col++] = section.getTotalTime() + " ms";
            }
            if (col < columns[2] || col >= values.length) continue;
            values[col++] = time + " ms";
        }
        values[columns[3]] = section.getTotalCount();
        values[columns[4]] = new DecimalFormat("   ###0.000 ms").format(section.getTotalAverageTime());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            values[i] = "-";
        }
        printer.tr(values);
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add("Initial");
        this.stack.clear();
    }

    public void setActive(boolean active) {
        if (!this.active && active || !active) {
            this.reset();
        }
        this.active = active;
    }

    public Profiler() {
        this.phases = new ArrayList<String>();
        this.stack = new LinkedList<Section>();
        this.phases.add("Initial");
    }

    public Section begin(int flags, String ... path) {
        return this.begin(flags, Joiner.on((char)'.').join((Object[])path));
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    private Section getSubSection(String name, String baseName, Section root) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = new SubSection(name, this.phases.size() - 1, baseName, root);
            this.sections.put(name, section);
        }
        return section;
    }

    public void mark(String phase) {
        long currentPhaseTime = 0L;
        for (Section section : this.sections.values()) {
            currentPhaseTime += section.getTime();
        }
        if (currentPhaseTime == 0L) {
            int size = this.phases.size();
            this.phases.set(size - 1, phase);
            return;
        }
        this.phases.add(phase);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    void end(Section section) {
        block5: {
            try {
                Section head;
                Section next = head = this.stack.pop();
                while (next != section) {
                    if (next == null && this.active) {
                        if (head == null) {
                            throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
                        }
                        throw new IllegalStateException("Attempted to pop " + section + " which was not in the stack, head was " + head);
                    }
                    next = this.stack.pop();
                }
            }
            catch (NoSuchElementException ex) {
                if (!this.active) break block5;
                throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
            }
        }
    }

    public Section begin(int flags, String name) {
        boolean root = (flags & 1) != 0;
        boolean fine = (flags & 2) != 0;
        String path = name;
        Section head = this.stack.peek();
        if (head != null) {
            path = head.getName() + (root ? " -> " : ".") + path;
            if (head.isRoot() && !root) {
                int pos = head.getName().lastIndexOf(" -> ");
                name = (pos > -1 ? head.getName().substring(pos + 4) : head.getName()) + "." + name;
                root = true;
            }
        }
        Section section = this.get(root ? name : path);
        if (root && head != null && this.active) {
            section = this.getSubSection(path, head.getName(), section);
        }
        section.setFine(fine).setRoot(root);
        this.stack.push(section);
        return section.start();
    }

    public Section begin(String name) {
        return this.begin(0, name);
    }

    public Section begin(String ... path) {
        return this.begin(0, path);
    }

    public PrettyPrinter printer(boolean includeFine, boolean group) {
        PrettyPrinter printer = new PrettyPrinter();
        int colCount = this.phases.size() + 4;
        int[] columns = new int[]{0, 1, 2, colCount - 2, colCount - 1};
        Object[] headers = new Object[colCount * 2];
        int col = 0;
        int pos = 0;
        while (col < colCount) {
            headers[pos + 1] = PrettyPrinter.Alignment.RIGHT;
            if (col == columns[0]) {
                headers[pos] = (group ? "" : "  ") + "Section";
                headers[pos + 1] = PrettyPrinter.Alignment.LEFT;
            } else {
                headers[pos] = col == columns[1] ? "    TOTAL" : (col == columns[3] ? "    Count" : (col == columns[4] ? "Avg. " : (col - columns[2] < this.phases.size() ? this.phases.get(col - columns[2]) : "")));
            }
            pos = ++col * 2;
        }
        printer.table(headers).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !includeFine || group && section.getDelegate() != section) continue;
            this.printSectionRow(printer, colCount, columns, section, group);
            if (!group) continue;
            for (Section subSection : this.sections.values()) {
                Section delegate = subSection.getDelegate();
                if (subSection.isFine() && !includeFine || delegate != section || delegate == subSection) continue;
                this.printSectionRow(printer, colCount, columns, subSection, group);
            }
        }
        return printer.add();
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;
        private static final NMSLException \u5979\u90fd\u79bb\u6211\u4eec\u597d\u8fdc = new NMSLException("\u4de1\u4dc4\u4316\u4df6\ua684\u262f\u4dd7\u378b\u4dfb\u4df8\u4dee\u4de1\u4ddb\ua699\u4833\u4dd7\u4224\u4dc0\ua647\u2762\u4def\u2704\u4dd6\u4dd5\u279f\u4dc4\u4df9\u272a\u4a8b\u4df3\ua683\u4dcb\u4dd5\u274c\u4dfc\u4dce\u4deb\u264c\ua695");

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        SubSection(String name, int cursor, String baseName, Section root) {
            super(name, cursor);
            this.baseName = baseName;
            this.root = root;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String info) {
            this.root.setInfo(info);
            super.setInfo(info);
        }

        @Override
        public Section next(String name) {
            super.stop();
            return this.root.next(name);
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }
    }

    class LiveSection
    extends Section {
        private int count;
        private int markedCount;
        private int cursor;
        private long time;
        private long start;
        private long[] times;
        private long markedTime;
        private static final NMSLException \u770b = new NMSLException("\u42c3\u4df9\u4de1\u4dd1\ua691\u4dcd\u4df3\u26b7\u4dfd\u4dd1\u4dcc\u4dd3\u44de\ua69a\u260e\ua652\u4dc3\u3945\u4dee\u4dec\u270e\u4dcf\u4059\u2755\u26a6\u4dce\u34e5\u4df7\u2720\u2783\u4dd6\u4dfe\u4dc2\u268f\u4ddb\u4de0");

        LiveSection(String name, int cursor) {
            super(name);
            this.cursor = 0;
            this.times = new long[0];
            this.start = 0L;
            this.cursor = cursor;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + 4);
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0L;
            this.count = 0;
            ++this.cursor;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        public long[] getTimes() {
            long[] times = new long[this.cursor + 1];
            System.arraycopy(this.times, 0, times, 0, Math.min(this.times.length, this.cursor));
            times[this.cursor] = this.time;
            return times;
        }

        @Override
        protected Section stop() {
            if (this.start > 0L) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0L;
            ++this.count;
            return this;
        }
    }

    public class Section {
        private boolean root;
        static final String SEPARATOR_ROOT = " -> ";
        private String info;
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean fine;
        protected boolean invalidated;
        private static final NMSLException \u4f60\u62cd\u4e09 = new NMSLException("\u4ddd\u3d40\u4dde\u4de3\u4dd2\u267b\u45fd\u4de4\u4df6\u4ddb\u4dd3\u4876\u27ad\ua674\u4dc1\u4dd8\u387d\u4dd8\u4df4\u3ee6\u4dd3\u26e2\u4de9\u26f9\u2793\u2672\u27aa\u3bac\u4dd6\u4dca\u4df4\u4de4\u4dc0\u4df4\u4dd0\u4dcd\u4dd3\u3883\u264b\ua64d\u2741\u3e81\u4dd1\u2715\u4dc9\ua64b\u265f\u4df0\u36ff");

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[1];
        }

        Section getDelegate() {
            return this;
        }

        public int getCount() {
            return 0;
        }

        public boolean isRoot() {
            return this.root;
        }

        public boolean isFine() {
            return this.fine;
        }

        void mark() {
        }

        public Section next(String name) {
            this.end();
            return Profiler.this.begin(name);
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public long getTotalTime() {
            return 0L;
        }

        public int getTotalCount() {
            return 0;
        }

        Section(String name) {
            this.name = name;
            this.info = name;
        }

        public double getSeconds() {
            return 0.0;
        }

        public String getInfo() {
            return this.info;
        }

        public String getBaseName() {
            return this.name;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }

        Section invalidate() {
            this.invalidated = true;
            return this;
        }

        protected Section stop() {
            return this;
        }

        public long getTime() {
            return 0L;
        }

        Section setFine(boolean fine) {
            this.fine = fine;
            return this;
        }

        public String getName() {
            return this.name;
        }

        Section setRoot(boolean root) {
            this.root = root;
            return this;
        }

        Section start() {
            return this;
        }

        public double getAverageTime() {
            return 0.0;
        }
    }
}

