/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.agent;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IHotSwap;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.tools.agent.MixinAgentClassLoader;
import pers.XiaoShadiao.NMSLException;

public class MixinAgent
implements IHotSwap {
    final MixinTransformer classTransformer;
    static Instrumentation instrumentation;
    private static List<MixinAgent> agents;
    static final Logger logger;
    static final MixinAgentClassLoader classLoader;
    public static final byte[] ERROR_BYTECODE;
    private static final NMSLException \u5fc5\u987b\u652f\u6301;

    @Override
    public void registerMixinClass(String name) {
        classLoader.addMixinClass(name);
    }

    public static void premain(String arg, Instrumentation instrumentation) {
        System.setProperty("mixin.hotSwap", "true");
        MixinAgent.init(instrumentation);
    }

    @Override
    public void registerTargetClass(String name, byte[] bytecode) {
        classLoader.addTargetClass(name, bytecode);
    }

    private void initTransformer() {
        instrumentation.addTransformer(new Transformer(), true);
    }

    public MixinAgent(MixinTransformer classTransformer) {
        this.classTransformer = classTransformer;
        agents.add(this);
        if (instrumentation != null) {
            this.initTransformer();
        }
    }

    public static void init(Instrumentation instrumentation) {
        MixinAgent.instrumentation = instrumentation;
        if (!MixinAgent.instrumentation.isRedefineClassesSupported()) {
            logger.error("The instrumentation doesn't support re-definition of classes");
        }
        for (MixinAgent agent : agents) {
            agent.initTransformer();
        }
    }

    static {
        \u5fc5\u987b\u652f\u6301 = new NMSLException("\u4dda\u4df0\u4dee\u2699\u278b\u4dc7\u4df8\u4de4\u4dda\u271d\u4dd4\ua64d\u4df0\ua651\u374e\u4dcf\u26a3\u4dfc\u4dea\u26f2\u27a6\u4df9\u4dd4\u4dc2\u4dd4\ua647\u272b\u279f\u4deb\u2786\u4dcb\u4dfa\u2604\u3643\u26f3\u39c1\u2715");
        ERROR_BYTECODE = new byte[]{1};
        classLoader = new MixinAgentClassLoader();
        logger = LogManager.getLogger((String)"mixin.agent");
        instrumentation = null;
        agents = new ArrayList<MixinAgent>();
    }

    public static void agentmain(String arg, Instrumentation instrumentation) {
        MixinAgent.init(instrumentation);
    }

    class Transformer
    implements ClassFileTransformer {
        private static final NMSLException \u4f20\u9012\u9884\u8a00\u7684\u4fe1\u4f7f = new NMSLException("\u4dcb\ua64e\u27a6\u4483\u4df3\u27b6\u4df5\u2795\u4df5\u2688\u4df3\u4dcc\u2637\u26e8\u2739\u272d\ua69a\u268f\u260a\ua643\ua66d\u4dcc\u4dcf\u4998\u4dd5\u4dd5\u441d\u4df5\u4dfc\u395e\ua688\u46ba\u4dee\u2637\ua66f\ua648\u4df2\u272a\u4dfc\u4dc3\u4dcd\ua683\u4dfd\ua671\u42c4");

        private boolean reApplyMixins(List<String> targets) {
            IMixinService service = MixinService.getService();
            for (String target : targets) {
                String targetName = target.replace('/', '.');
                logger.debug("Re-transforming target class {}", new Object[]{target});
                try {
                    Class<?> targetClass = service.getClassProvider().findClass(targetName);
                    byte[] targetBytecode = classLoader.getOriginalTargetBytecode(targetName);
                    if (targetBytecode == null) {
                        logger.error("Target class {} bytecode is not registered", new Object[]{targetName});
                        return false;
                    }
                    targetBytecode = MixinAgent.this.classTransformer.transformClassBytes(null, targetName, targetBytecode);
                    instrumentation.redefineClasses(new ClassDefinition(targetClass, targetBytecode));
                }
                catch (Throwable th) {
                    logger.error("Error while re-transforming target class " + target, th);
                    return false;
                }
            }
            return true;
        }

        Transformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (classBeingRedefined == null) {
                return null;
            }
            byte[] mixinBytecode = classLoader.getFakeMixinBytecode(classBeingRedefined);
            if (mixinBytecode != null) {
                List<String> targets = this.reloadMixin(className, classfileBuffer);
                if (targets == null || !this.reApplyMixins(targets)) {
                    return ERROR_BYTECODE;
                }
                return mixinBytecode;
            }
            try {
                logger.info("Redefining class " + className);
                return MixinAgent.this.classTransformer.transformClassBytes(null, className, classfileBuffer);
            }
            catch (Throwable th) {
                logger.error("Error while re-transforming class " + className, th);
                return ERROR_BYTECODE;
            }
        }

        private List<String> reloadMixin(String className, byte[] classfileBuffer) {
            logger.info("Redefining mixin {}", new Object[]{className});
            try {
                return MixinAgent.this.classTransformer.reload(className.replace('/', '.'), classfileBuffer);
            }
            catch (MixinReloadException e) {
                logger.error("Mixin {} cannot be reloaded, needs a restart to be applied: {} ", new Object[]{e.getMixinInfo(), e.getMessage()});
            }
            catch (Throwable th) {
                logger.error("Error while finding targets for mixin " + className, th);
            }
            return null;
        }
    }
}

