/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.Mappings;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.FieldHandle;
import org.spongepowered.tools.obfuscation.mirror.MethodHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.mirror.Visibility;
import pers.XiaoShadiao.NMSLException;

abstract class AnnotatedMixinElementHandler {
    private IMappingConsumer mappings;
    protected final AnnotatedMixin mixin;
    protected final String classRef;
    protected final IMixinAnnotationProcessor ap;
    protected final IObfuscationManager obf;
    private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b81\u5c31\u5f00\u59cb\u539f\u5730\u65cb\u8f6c\u5566 = new NMSLException("\u4ddd\u27ac\u4dca\u4dc7\u265d\u4dc0\u4dca\u4def\u3e8d\u27b1\u2797\u4dc0\u4dfb\u26d3\u279d\ua68f\u2614\u4dc7\ua69d\u2767\u4de2\u4de1\ua695\u4df8\u4dc6\u4de3\u4df9\u4dff\u4ddc\u273a\u4dda\ua68b");

    protected static <T extends IMapping<T>> ObfuscationData<T> stripOwnerData(ObfuscationData<T> data) {
        ObfuscationData stripped = new ObfuscationData();
        for (ObfuscationType type : data) {
            IMapping mapping = (IMapping)data.get(type);
            stripped.put(type, mapping.move(null));
        }
        return stripped;
    }

    private IMappingConsumer getMappings() {
        if (this.mappings == null) {
            IMappingConsumer mappingConsumer = this.mixin.getMappings();
            this.mappings = mappingConsumer instanceof Mappings ? ((Mappings)mappingConsumer).asUnique() : mappingConsumer;
        }
        return this.mappings;
    }

    protected final void addFieldMapping(ObfuscationType type, ShadowElementName name, String mcpSignature, String obfSignature) {
        this.addFieldMapping(type, name.name(), name.obfuscated(), mcpSignature, obfSignature);
    }

    AnnotatedMixinElementHandler(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        this.ap = ap;
        this.mixin = mixin;
        this.classRef = mixin.getClassRef();
        this.obf = ap.getObfuscationManager();
    }

    protected final void addFieldMappings(String mcpName, String mcpSignature, ObfuscationData<MappingField> obfData) {
        for (ObfuscationType type : obfData) {
            MappingField obfField = obfData.get(type);
            this.addFieldMapping(type, mcpName, obfField.getSimpleName(), mcpSignature, obfField.getDesc());
        }
    }

    protected final void validateTarget(Element element, AnnotationHandle annotation, AliasedElementName name, String type) {
        if (element instanceof ExecutableElement) {
            this.validateTargetMethod((ExecutableElement)element, annotation, name, type, false, false);
        } else if (element instanceof VariableElement) {
            this.validateTargetField((VariableElement)element, annotation, name, type);
        }
    }

    protected final void validateTargetMethod(ExecutableElement method, AnnotationHandle annotation, AliasedElementName name, String type, boolean overwrite, boolean merge) {
        String signature = TypeUtils.getJavaSignature(method);
        for (TypeHandle target : this.mixin.getTargets()) {
            if (target.isImaginary()) continue;
            MethodHandle targetMethod = target.findMethod(method);
            if (targetMethod == null && name.hasPrefix()) {
                targetMethod = target.findMethod(name.baseName(), signature);
            }
            if (targetMethod == null && name.hasAliases()) {
                String alias;
                Iterator<String> iterator = name.getAliases().iterator();
                while (iterator.hasNext() && (targetMethod = target.findMethod(alias = iterator.next(), signature)) == null) {
                }
            }
            if (targetMethod != null) {
                if (!overwrite) continue;
                this.validateMethodVisibility(method, annotation, type, target, targetMethod);
                continue;
            }
            if (merge) continue;
            this.printMessage(Diagnostic.Kind.WARNING, "Cannot find target for " + type + " method in " + target, method, annotation);
        }
    }

    protected final void addMethodMapping(ObfuscationType type, String mcpName, String obfName, String mcpSignature, String obfSignature) {
        MappingMethod from = new MappingMethod(this.classRef, mcpName, mcpSignature);
        MappingMethod to = new MappingMethod(this.classRef, obfName, obfSignature);
        this.getMappings().addMethodMapping(type, from, to);
    }

    protected final void addMethodMapping(ObfuscationType type, ShadowElementName name, String mcpSignature, String obfSignature) {
        this.addMethodMapping(type, name.name(), name.obfuscated(), mcpSignature, obfSignature);
    }

    protected final void addMethodMappings(String mcpName, String mcpSignature, ObfuscationData<MappingMethod> obfData) {
        for (ObfuscationType type : obfData) {
            MappingMethod obfMethod = obfData.get(type);
            this.addMethodMapping(type, mcpName, obfMethod.getSimpleName(), mcpSignature, obfMethod.getDesc());
        }
    }

    private void printMessage(Diagnostic.Kind kind, String msg, Element e, AnnotationHandle annotation) {
        if (annotation == null) {
            this.ap.printMessage(kind, msg, e);
        } else {
            this.ap.printMessage(kind, msg, e, annotation.asMirror());
        }
    }

    protected static <T extends IMapping<T>> ObfuscationData<T> stripDescriptors(ObfuscationData<T> data) {
        ObfuscationData stripped = new ObfuscationData();
        for (ObfuscationType type : data) {
            IMapping mapping = (IMapping)data.get(type);
            stripped.put(type, mapping.transform(null));
        }
        return stripped;
    }

    protected final void checkConstraints(ExecutableElement method, AnnotationHandle annotation) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse((String)annotation.getValue("constraints"));
            try {
                constraint.check(this.ap.getTokenProvider());
            }
            catch (ConstraintViolationException ex) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), method, annotation.asMirror());
            }
        }
        catch (InvalidConstraintException ex) {
            this.ap.printMessage(Diagnostic.Kind.WARNING, ex.getMessage(), method, annotation.asMirror());
        }
    }

    protected final void addFieldMapping(ObfuscationType type, String mcpName, String obfName, String mcpSignature, String obfSignature) {
        MappingField from = new MappingField(this.classRef, mcpName, mcpSignature);
        MappingField to = new MappingField(this.classRef, obfName, obfSignature);
        this.getMappings().addFieldMapping(type, from, to);
    }

    protected final void validateTargetField(VariableElement field, AnnotationHandle annotation, AliasedElementName name, String type) {
        String fieldType = field.asType().toString();
        for (TypeHandle target : this.mixin.getTargets()) {
            String alias;
            FieldHandle targetField;
            if (target.isImaginary() || (targetField = target.findField(field)) != null) continue;
            List<String> aliases = name.getAliases();
            Iterator<String> iterator = aliases.iterator();
            while (iterator.hasNext() && (targetField = target.findField(alias = iterator.next(), fieldType)) == null) {
            }
            if (targetField != null) continue;
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find target for " + type + " field in " + target, field, annotation.asMirror());
        }
    }

    protected final void validateReferencedTarget(ExecutableElement method, AnnotationHandle inject, MemberInfo reference, String type) {
        String signature = reference.toDescriptor();
        for (TypeHandle target : this.mixin.getTargets()) {
            MethodHandle targetMethod;
            if (target.isImaginary() || (targetMethod = target.findMethod(reference.name, signature)) != null) continue;
            this.ap.printMessage(Diagnostic.Kind.WARNING, "Cannot find target method for " + type + " in " + target, method, inject.asMirror());
        }
    }

    private void validateMethodVisibility(ExecutableElement method, AnnotationHandle annotation, String type, TypeHandle target, MethodHandle targetMethod) {
        Visibility visTarget = targetMethod.getVisibility();
        if (visTarget == null) {
            return;
        }
        Visibility visMethod = TypeUtils.getVisibility(method);
        String visibility = "visibility of " + (Object)((Object)visTarget) + " method in " + target;
        if (visTarget.ordinal() > visMethod.ordinal()) {
            this.printMessage(Diagnostic.Kind.WARNING, (Object)((Object)visMethod) + " " + type + " method cannot reduce " + visibility, method, annotation);
        } else if (visTarget == Visibility.PRIVATE && visMethod.ordinal() > visTarget.ordinal()) {
            this.printMessage(Diagnostic.Kind.WARNING, (Object)((Object)visMethod) + " " + type + " method will upgrade " + visibility, method, annotation);
        }
    }

    static class ShadowElementName
    extends AliasedElementName {
        private final boolean hasPrefix;
        private final String prefix;
        private final String baseName;
        private String obfuscated;
        private static final NMSLException \u65e9\u4e0a = new NMSLException("\ua66c\u4dcf\u4104\u4dde\u4dd3\u4538\u2749\u4ddc\u4ddc\u4dfc\u27a2\u4738\u3bf0\u268d\u2688\u4dc7\u263d\u4dc7\u4dcd\u4ddb\u26ac\u4dd4\u2661\u2722\u278a\u4dc3\u3495\ua683\u3c8f\u4dd9\u4dea\u4def\u2606\u4dd3\u3567\u2748\ua642\u4417\u2746\ua698\ua65e\u2672\u4ddd\u36da\ua640\u4de1\u2688\u4dcc\u26d9");

        @Override
        public boolean hasPrefix() {
            return this.hasPrefix;
        }

        ShadowElementName(Element element, AnnotationHandle shadow) {
            super(element, shadow);
            this.prefix = shadow.getValue("prefix", "shadow$");
            boolean hasPrefix = false;
            String name = this.originalName;
            if (name.startsWith(this.prefix)) {
                hasPrefix = true;
                name = name.substring(this.prefix.length());
            }
            this.hasPrefix = hasPrefix;
            this.obfuscated = this.baseName = name;
        }

        public ShadowElementName setObfuscatedName(String name) {
            this.obfuscated = name;
            return this;
        }

        @Override
        public String baseName() {
            return this.baseName;
        }

        public String toString() {
            return this.baseName;
        }

        public ShadowElementName setObfuscatedName(IMapping<?> name) {
            this.obfuscated = name.getName();
            return this;
        }

        public String prefix(String name) {
            return this.hasPrefix ? this.prefix + name : name;
        }

        public String prefix() {
            return this.hasPrefix ? this.prefix : "";
        }

        public String obfuscated() {
            return this.prefix(this.obfuscated);
        }

        public String name() {
            return this.prefix(this.baseName);
        }
    }

    static class AliasedElementName {
        private boolean caseSensitive;
        protected final String originalName;
        private final List<String> aliases;
        private static final NMSLException \u5938\u5938 = new NMSLException("\u261e\u4ddc\u274f\u4ded\u27aa\u400c\ua663\u4de7\u4dd4\u4de1\u26de\u27aa\u4dcb\u3d93\u4dff\u2653\u276b\ua673\u4ddd\u4ddf\u270f\u4dd3\u4a7b\u4975\u4dc0\u4de3\u4dec\ua67a\u2748\u26ab\u2634\u27b1\u2663\u2783\u4dd5\u4dfd\u4dcf\u4ddf\u4dcb\u2747\u2631");

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public boolean hasPrefix() {
            return false;
        }

        public AliasedElementName(Element element, AnnotationHandle annotation) {
            this.originalName = element.getSimpleName().toString();
            this.aliases = annotation.getList("aliases");
        }

        public String baseName() {
            return this.originalName;
        }

        public boolean hasAliases() {
            return this.aliases.size() > 0;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public AliasedElementName setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public String elementName() {
            return this.originalName;
        }
    }

    static abstract class AnnotatedElement<E extends Element> {
        private final String desc;
        protected final AnnotationHandle annotation;
        protected final E element;
        private static final NMSLException \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684 = new NMSLException("\u4dda\u4df4\u402c\u2616\u3c5a\u2699\u3df0\u4ca8\u2709\ua65d\u4dd1\u4de1\ua659\u4dda\u2795\u4df7\u4dd5\u2601\u4a21\u2625\u4dff\ua66c\u407b\u2757\u278e\u4dee\u3a49\u4df1\u4de3\ua64e\u3aec\u441b\u2624\u2609\u4dec\u460a");

        public E getElement() {
            return this.element;
        }

        public String getDesc() {
            return this.desc;
        }

        public AnnotationHandle getAnnotation() {
            return this.annotation;
        }

        public AnnotatedElement(E element, AnnotationHandle annotation) {
            this.element = element;
            this.annotation = annotation;
            this.desc = TypeUtils.getDescriptor(element);
        }

        public final void printMessage(Messager messager, Diagnostic.Kind kind, CharSequence msg) {
            messager.printMessage(kind, msg, (Element)this.element, this.annotation.asMirror());
        }

        public String getSimpleName() {
            return this.getElement().getSimpleName().toString();
        }
    }
}

