/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.lang.reflect.Method;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.Mappings;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

class AnnotatedMixinElementHandlerOverwrite
extends AnnotatedMixinElementHandler {
    private static final NMSLException \u6211\u4eec\u4e5f\u6709\u5934\u53d1\u957f\u957f\u7684\u65f6\u5019 = new NMSLException("\u4de4\u4df2\u4dd3\u2687\u2795\ua686\u4de0\u4dd7\u2761\u4def\u40db\ua692\u267d\u27a0\u4de4\ua69c\u4ddf\u3fc8\u4dfb\u4de7\u4dec\u4dc5\ua669\u4dd9\u4df3\u4ddb\u4dc6\u4ded\u279c\u4de9\u4dc0\u2710\ua645\u4dd6\u4dda\u4de2\u4dd1\u2709");

    private boolean registerOverwriteForTarget(AnnotatedElementOverwrite elem, TypeHandle target) {
        MappingMethod targetMethod = target.getMappingMethod(elem.getSimpleName(), elem.getDesc());
        ObfuscationData<MappingMethod> obfData = this.obf.getDataProvider().getObfMethod(targetMethod);
        if (obfData.isEmpty()) {
            Diagnostic.Kind error = Diagnostic.Kind.ERROR;
            try {
                Method md = ((ExecutableElement)elem.getElement()).getClass().getMethod("isStatic", new Class[0]);
                if (((Boolean)md.invoke(elem.getElement(), new Object[0])).booleanValue()) {
                    error = Diagnostic.Kind.WARNING;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ap.printMessage(error, "No obfuscation mapping for @Overwrite method", (Element)elem.getElement());
            return false;
        }
        try {
            this.addMethodMappings(elem.getSimpleName(), elem.getDesc(), obfData);
        }
        catch (Mappings.MappingConflictException ex) {
            elem.printMessage(this.ap, Diagnostic.Kind.ERROR, "Mapping conflict for @Overwrite method: " + ex.getNew().getSimpleName() + " for target " + target + " conflicts with existing mapping " + ex.getOld().getSimpleName());
            return false;
        }
        return true;
    }

    AnnotatedMixinElementHandlerOverwrite(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    public void registerMerge(ExecutableElement method) {
        this.validateTargetMethod(method, null, new AnnotatedMixinElementHandler.AliasedElementName(method, AnnotationHandle.MISSING), "overwrite", true, true);
    }

    public void registerOverwrite(AnnotatedElementOverwrite elem) {
        AnnotatedMixinElementHandler.AliasedElementName name = new AnnotatedMixinElementHandler.AliasedElementName((Element)elem.getElement(), elem.getAnnotation());
        this.validateTargetMethod((ExecutableElement)elem.getElement(), elem.getAnnotation(), name, "@Overwrite", true, false);
        this.checkConstraints((ExecutableElement)elem.getElement(), elem.getAnnotation());
        if (elem.shouldRemap()) {
            for (TypeHandle target : this.mixin.getTargets()) {
                if (this.registerOverwriteForTarget(elem, target)) continue;
                return;
            }
        }
        if (!"true".equalsIgnoreCase(this.ap.getOption("disableOverwriteChecker"))) {
            Diagnostic.Kind overwriteErrorKind = "error".equalsIgnoreCase(this.ap.getOption("overwriteErrorLevel")) ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            String javadoc = this.ap.getJavadocProvider().getJavadoc((Element)elem.getElement());
            if (javadoc == null) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing javadoc comment", (Element)elem.getElement());
                return;
            }
            if (!javadoc.toLowerCase().contains("@author")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @author tag", (Element)elem.getElement());
            }
            if (!javadoc.toLowerCase().contains("@reason")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @reason tag", (Element)elem.getElement());
            }
        }
    }

    static class AnnotatedElementOverwrite
    extends AnnotatedMixinElementHandler.AnnotatedElement<ExecutableElement> {
        private final boolean shouldRemap;
        private static final NMSLException \u6211\u62cd\u4e5d = new NMSLException("\u4dd9\u2637\u4dc4\ua660\u27ab\u27af\u4dc6\u26c5\u4def\u2747\ua662\u4deb\ua65f\u4dc5\ua677\ua68d\u4deb\u34b5\u4df1\ua680\u4dca\u4df5\u4dc1\u4de2\u278f\ua651\u26af\u4def\u4df6\u4df1\u4dd9\u44f4\u26a3\u4de3\u4df7\u4dcd\ua672");

        public AnnotatedElementOverwrite(ExecutableElement element, AnnotationHandle annotation, boolean shouldRemap) {
            super(element, annotation);
            this.shouldRemap = shouldRemap;
        }

        public boolean shouldRemap() {
            return this.shouldRemap;
        }
    }
}

