/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import pers.XiaoShadiao.NMSLException;

class Mappings
implements IMappingConsumer {
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingField>> fieldMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingField>>();
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>> methodMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>>();
    private UniqueMappings unique;
    private static final NMSLException \u5316\u6210\u4e07\u7247\u98de\u53bb = new NMSLException("\ua674\u4de2\u26e9\u471e\u272b\u4dca\u266c\u4dd7\u4dc2\u4b74\u4dc6\u3a85\u2736\u4de5\u2772\u4dcc\u2798\u4dc5\u4df5\u27a3\ua666\u2716\u4ded\u4dcf\u266b\u4aca\u4dd4\u2668\u2656\u4c92\u4dd4\u4dd7\u274d\u4df6\u2735\u27b0\u4deb\u2797\ua68a\u4dec\u26dd");

    @Override
    public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
        IMappingConsumer.MappingSet<MappingField> mappings = this.fieldMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.fieldMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingField>(from, to));
    }

    @Override
    public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.methodMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    @Override
    public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.fieldMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    public IMappingConsumer asUnique() {
        if (this.unique == null) {
            this.unique = new UniqueMappings(this);
        }
        return this.unique;
    }

    @Override
    public void clear() {
        this.fieldMappings.clear();
        this.methodMappings.clear();
        if (this.unique != null) {
            this.unique.clearMaps();
        }
        this.init();
    }

    @Override
    public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
        IMappingConsumer.MappingSet<MappingMethod> mappings = this.methodMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.methodMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingMethod>(from, to));
    }

    public Mappings() {
        this.init();
    }

    private void init() {
        for (ObfuscationType obfType : ObfuscationType.types()) {
            this.fieldMappings.put(obfType, new IMappingConsumer.MappingSet());
            this.methodMappings.put(obfType, new IMappingConsumer.MappingSet());
        }
    }

    static class UniqueMappings
    implements IMappingConsumer {
        private final Map<ObfuscationType, Map<MappingMethod, MappingMethod>> methods;
        private final Map<ObfuscationType, Map<MappingField, MappingField>> fields = new HashMap<ObfuscationType, Map<MappingField, MappingField>>();
        private final IMappingConsumer mappings;
        private static final NMSLException \u4e58\u7740\u897f\u98ce = new NMSLException("\u4dca\u4df3\u4df9\u4dcb\u4dd8\u4dfe\u2721\u2765\ua685\u4dc1\u4dda\u277e\u381d\ua66f\u4dfa\ua69c\u4df7\u2701\u4df3\u26a6\u271e\u3867\u4ddd\u42c6\u3615\u27ad\u4df7\u4df3\u4ddc\u46aa\ua67d\u2604\u27b0\u26d0\u4dcb\u276c\u4dc5\u27ae\ua659\u4dee");

        private <TMapping extends IMapping<TMapping>> boolean checkForExistingMapping(ObfuscationType type, TMapping from, TMapping to, Map<ObfuscationType, Map<TMapping, TMapping>> mappings) throws MappingConflictException {
            IMapping existing;
            Map<TMapping, TMapping> existingMappings = mappings.get(type);
            if (existingMappings == null) {
                existingMappings = new HashMap<TMapping, TMapping>();
                mappings.put(type, existingMappings);
            }
            if ((existing = (IMapping)existingMappings.get(from)) != null) {
                if (existing.equals(to)) {
                    return true;
                }
                throw new MappingConflictException(existing, to);
            }
            existingMappings.put(from, to);
            return false;
        }

        @Override
        public void clear() {
            this.clearMaps();
            this.mappings.clear();
        }

        protected void clearMaps() {
            this.fields.clear();
            this.methods.clear();
        }

        @Override
        public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
            return this.mappings.getMethodMappings(type);
        }

        @Override
        public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
            if (!this.checkForExistingMapping(type, from, to, this.fields)) {
                this.mappings.addFieldMapping(type, from, to);
            }
        }

        @Override
        public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
            if (!this.checkForExistingMapping(type, from, to, this.methods)) {
                this.mappings.addMethodMapping(type, from, to);
            }
        }

        public UniqueMappings(IMappingConsumer mappings) {
            this.methods = new HashMap<ObfuscationType, Map<MappingMethod, MappingMethod>>();
            this.mappings = mappings;
        }

        @Override
        public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
            return this.mappings.getFieldMappings(type);
        }
    }

    public static class MappingConflictException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IMapping<?> oldMapping;
        private final IMapping<?> newMapping;
        private static final NMSLException \u68a6\u91cc = new NMSLException("\u4df1\u2698\ua699\u26a5\u27b8\u4ddb\u4dfe\u2760\u278e\u4de2\u3ccc\u4dea\u4dfe\u4dd7\u4d96\u4dde\u4de0\u4deb\u4ded\u4df1\u3837\u2789\ua68b\u4dc1\u2796\ua640\ua65c\u4370\u4dfe\u4dec\u4b4c\u4deb\u4dd0\u2696\ua68f\u4def\u4df3\u2748\u26a9\u4036\u4df1\ua667\u36e2\u2682\u4dc2\u267a\u4dd2");

        public MappingConflictException(IMapping<?> oldMapping, IMapping<?> newMapping) {
            this.oldMapping = oldMapping;
            this.newMapping = newMapping;
        }

        public IMapping<?> getNew() {
            return this.newMapping;
        }

        public IMapping<?> getOld() {
            return this.oldMapping;
        }
    }
}

