/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Collection;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

public abstract class MixinValidator
implements IMixinValidator {
    protected final ProcessingEnvironment processingEnv;
    protected final Messager messager;
    protected final IOptionProvider options;
    protected final IMixinValidator.ValidationPass pass;
    private static final NMSLException \u6211\u4eec\u52a0\u5feb\u811a\u6b65\u5427 = new NMSLException("\u4df7\u4df3\u4dce\ua69e\u4def\u2637\u4dc8\u2603\u4dc3\u4dea\u2741\u4ddd\u42b7\u2742\ua68f\u260a\ua695\u271a\u4dd2\u4dcb\u2622\ua690\ua69f\u26b4\u2662\u4dc1\u4de8\u4dc6\u4df6\ua65a\u4dee\u2681\u4de4\u4de1\u4de5\u4ddf\u4de9\u43a3\u4dd0\u4df2\u4de3\u264a\u4ddd\ua659");

    protected final void warning(String warning, Element element) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, warning, element);
    }

    protected final void error(String error, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, element);
    }

    public MixinValidator(IMixinAnnotationProcessor ap, IMixinValidator.ValidationPass pass) {
        this.processingEnv = ap.getProcessingEnvironment();
        this.messager = ap;
        this.options = ap;
        this.pass = pass;
    }

    protected final void note(String note, Element element) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, note, element);
    }

    protected abstract boolean validate(TypeElement var1, AnnotationHandle var2, Collection<TypeHandle> var3);

    protected final Collection<TypeMirror> getMixinsTargeting(TypeMirror targetType) {
        return AnnotatedMixins.getMixinsForEnvironment(this.processingEnv).getMixinsTargeting(targetType);
    }

    @Override
    public final boolean validate(IMixinValidator.ValidationPass pass, TypeElement mixin, AnnotationHandle annotation, Collection<TypeHandle> targets) {
        if (pass != this.pass) {
            return true;
        }
        return this.validate(mixin, annotation, targets);
    }
}

