/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.ObfuscationUtil;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.mapping.IMappingProvider;
import org.spongepowered.tools.obfuscation.mapping.IMappingWriter;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

public abstract class ObfuscationEnvironment
implements IObfuscationEnvironment {
    protected final IMappingWriter mappingWriter;
    protected final ObfuscationType type;
    protected final IMixinAnnotationProcessor ap;
    private boolean initDone;
    protected final List<String> inFileNames;
    protected final RemapperProxy remapper = new RemapperProxy();
    protected final String outFileName;
    protected final IMappingProvider mappingProvider;
    private static final NMSLException \u6bcf\u6b21\u548c\u5c0f\u590f\u89c1\u9762 = new NMSLException("\u2649\u2736\ua644\u4de6\u4deb\u2652\u276f\ua695\u4de3\ua68e\u4dfd\u4dee\u4dd3\u4dc0\ua68f\u4dd1\u4dc6\u4df6\u4de2\u4dff\u4dfc\u265b\u277d\u4dde\u4de2\u26a3\u272c\u2685\u2741\u2606\u2626\u4bd4\u4df1\ua699\u4dfc\u2741\u4de9\u266d\u4dfb\u49dc\u4c24\u4dd7\u2668\u4dc0\u4dcd");

    protected abstract IMappingWriter getMappingWriter(Messager var1, Filer var2);

    protected abstract IMappingProvider getMappingProvider(Messager var1, Filer var2);

    @Override
    public void writeMappings(Collection<IMappingConsumer> consumers) {
        IMappingConsumer.MappingSet<MappingField> fields = new IMappingConsumer.MappingSet<MappingField>();
        IMappingConsumer.MappingSet<MappingMethod> methods = new IMappingConsumer.MappingSet<MappingMethod>();
        for (IMappingConsumer mappings : consumers) {
            fields.addAll(mappings.getFieldMappings(this.type));
            methods.addAll(mappings.getMethodMappings(this.type));
        }
        this.mappingWriter.write(this.outFileName, this.type, fields, methods);
    }

    @Override
    public String remapDescriptor(String desc) {
        return ObfuscationUtil.mapDescriptor(desc, this.remapper);
    }

    @Override
    public String getObfClass(String className) {
        if (!this.initMappings()) {
            return null;
        }
        return this.mappingProvider.getClassMapping(className);
    }

    public String toString() {
        return this.type.toString();
    }

    private boolean initMappings() {
        if (!this.initDone) {
            this.initDone = true;
            if (this.inFileNames == null) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "The " + this.type.getConfig().getInputFileOption() + " argument was not supplied, obfuscation processing will not occur");
                return false;
            }
            int successCount = 0;
            for (String inputFileName : this.inFileNames) {
                File inputFile = new File(inputFileName);
                try {
                    if (!inputFile.isFile()) continue;
                    this.ap.printMessage(Diagnostic.Kind.NOTE, "Loading " + this.type + " mappings from " + inputFile.getAbsolutePath());
                    this.mappingProvider.read(inputFile);
                    ++successCount;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (successCount < 1) {
                this.ap.printMessage(Diagnostic.Kind.ERROR, "No valid input files for " + this.type + " could be read, processing may not be sucessful.");
                this.mappingProvider.clear();
            }
        }
        return !this.mappingProvider.isEmpty();
    }

    @Override
    public MappingField getObfField(MappingField field, boolean lazyRemap) {
        String remappedOwner;
        if (!this.initMappings()) {
            return null;
        }
        MappingField mapping = this.mappingProvider.getFieldMapping(field);
        if (mapping == null) {
            if (lazyRemap) {
                return null;
            }
            mapping = field;
        }
        if ((remappedOwner = this.getObfClass(mapping.getOwner())) == null || remappedOwner.equals(field.getOwner()) || remappedOwner.equals(mapping.getOwner())) {
            return mapping != field ? mapping : null;
        }
        return mapping.move(remappedOwner);
    }

    @Override
    public MappingField getObfField(MemberInfo field) {
        return this.getObfField(field.asFieldMapping(), true);
    }

    public ObfuscationType getType() {
        return this.type;
    }

    @Override
    public MappingMethod getObfMethod(MappingMethod method, boolean lazyRemap) {
        if (this.initMappings()) {
            String remappedOwner;
            boolean remapped = true;
            Object mapping = null;
            for (MappingMethod md = method; md != null && mapping == null; md = md.getSuper()) {
                mapping = this.mappingProvider.getMethodMapping(md);
            }
            if (mapping == null) {
                if (lazyRemap) {
                    return null;
                }
                mapping = method.copy();
                remapped = false;
            }
            if ((remappedOwner = this.getObfClass(((MappingMethod)mapping).getOwner())) == null || remappedOwner.equals(method.getOwner()) || remappedOwner.equals(((MappingMethod)mapping).getOwner())) {
                return remapped ? mapping : null;
            }
            if (remapped) {
                return ((MappingMethod)mapping).move(remappedOwner);
            }
            String desc = ObfuscationUtil.mapDescriptor(((MappingMethod)mapping).getDesc(), this.remapper);
            return new MappingMethod(remappedOwner, ((MappingMethod)mapping).getSimpleName(), desc);
        }
        return null;
    }

    @Override
    public MappingMethod getObfMethod(MemberInfo method) {
        MappingMethod obfd = this.getObfMethod(method.asMethodMapping());
        if (obfd != null || !method.isFullyQualified()) {
            return obfd;
        }
        TypeHandle type = this.ap.getTypeProvider().getTypeHandle(method.owner);
        if (type == null || type.isImaginary()) {
            return null;
        }
        TypeMirror superClass = type.getElement().getSuperclass();
        if (superClass.getKind() != TypeKind.DECLARED) {
            return null;
        }
        String superClassName = ((TypeElement)((DeclaredType)superClass).asElement()).getQualifiedName().toString();
        return this.getObfMethod(new MemberInfo(method.name, superClassName.replace('.', '/'), method.desc, method.matchAll));
    }

    @Override
    public MappingMethod getObfMethod(MappingMethod method) {
        return this.getObfMethod(method, true);
    }

    @Override
    public MappingField getObfField(MappingField field) {
        return this.getObfField(field, true);
    }

    protected ObfuscationEnvironment(ObfuscationType type) {
        this.type = type;
        this.ap = type.getAnnotationProcessor();
        this.inFileNames = type.getInputFileNames();
        this.outFileName = type.getOutputFileName();
        this.mappingProvider = this.getMappingProvider(this.ap, this.ap.getProcessingEnvironment().getFiler());
        this.mappingWriter = this.getMappingWriter(this.ap, this.ap.getProcessingEnvironment().getFiler());
    }

    @Override
    public MemberInfo remapDescriptor(MemberInfo method) {
        String newDesc;
        String desc;
        String newOwner;
        boolean transformed = false;
        String owner = method.owner;
        if (owner != null && (newOwner = this.remapper.map(owner)) != null) {
            owner = newOwner;
            transformed = true;
        }
        if ((desc = method.desc) != null && !(newDesc = ObfuscationUtil.mapDescriptor(method.desc, this.remapper)).equals(method.desc)) {
            desc = newDesc;
            transformed = true;
        }
        return transformed ? new MemberInfo(method.name, owner, desc, method.matchAll) : null;
    }

    final class RemapperProxy
    implements ObfuscationUtil.IClassRemapper {
        private static final NMSLException \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019 = new NMSLException("\u4df7\ua647\u4de5\u4dd3\u2775\ua671\u2787\ua660\ua657\u3f14\u2766\u4dc9\u4df6\u4de2\u4dd9\u4dfb\u2713\u4dc6\u4dc7\u4dd4\ua69d\u4df4\u4dc1\u4ddb\ua690\u4dd2\u4dd7\u26c6\u4deb\u4df5\ua677\u4dd4\u4de7\u4dca\ua670\u4dd2\u4deb\u4deb\ua662\u4ded\u4dd9\u4dc6\u3c37\u4df2");

        @Override
        public String map(String typeName) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(typeName);
        }

        @Override
        public String unmap(String typeName) {
            if (ObfuscationEnvironment.this.mappingProvider == null) {
                return null;
            }
            return ObfuscationEnvironment.this.mappingProvider.getClassMapping(typeName);
        }

        RemapperProxy() {
        }
    }
}

