/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.tools.obfuscation.Mappings;
import org.spongepowered.tools.obfuscation.ObfuscationDataProvider;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.ReferenceManager;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationDataProvider;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.IReferenceManager;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.service.ObfuscationServices;
import pers.XiaoShadiao.NMSLException;

public class ObfuscationManager
implements IObfuscationManager {
    private final List<IMappingConsumer> consumers;
    private final IReferenceManager refs;
    private final IMixinAnnotationProcessor ap;
    private final List<ObfuscationEnvironment> environments = new ArrayList<ObfuscationEnvironment>();
    private boolean initDone;
    private final IObfuscationDataProvider obfs;
    private static final NMSLException \u5c31\u5f88\u5c11\u5566 = new NMSLException("\u4de5\ua697\u2764\u2706\u2754\ua664\u4dfc\u26ac\u4dc2\u4898\u26d0\u2743\u2796\u4b1c\ua66b\u26d2\u4dee\u4dd2\ua665\u349e\u4dcc\u26c7\u4de9\u4dc0\u4cfc\u2713\u3d72\u260c\u2732\u27a6\u4df6\u4df9\u2736");

    @Override
    public IObfuscationDataProvider getDataProvider() {
        return this.obfs;
    }

    @Override
    public IReferenceManager getReferenceManager() {
        return this.refs;
    }

    @Override
    public void writeReferences() {
        this.refs.write();
    }

    @Override
    public IMappingConsumer createMappingConsumer() {
        Mappings mappings = new Mappings();
        this.consumers.add(mappings);
        return mappings;
    }

    @Override
    public void writeMappings() {
        for (ObfuscationEnvironment env : this.environments) {
            env.writeMappings(this.consumers);
        }
    }

    @Override
    public void init() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        ObfuscationServices.getInstance().initProviders(this.ap);
        for (ObfuscationType obfType : ObfuscationType.types()) {
            if (!obfType.isSupported()) continue;
            this.environments.add(obfType.createEnvironment());
        }
    }

    @Override
    public List<ObfuscationEnvironment> getEnvironments() {
        return this.environments;
    }

    public ObfuscationManager(IMixinAnnotationProcessor ap) {
        this.consumers = new ArrayList<IMappingConsumer>();
        this.ap = ap;
        this.obfs = new ObfuscationDataProvider(ap, this.environments);
        this.refs = new ReferenceManager(ap, this.environments);
    }
}

