/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import pers.XiaoShadiao.NMSLException;

public final class AnnotationHandle {
    public static final AnnotationHandle MISSING;
    private final AnnotationMirror annotation;
    private static final NMSLException \u8046\u542c\u795e\u8c15\u7684\u796d\u53f8;

    protected static AnnotationMirror getAnnotation(Element elem, Class<? extends Annotation> annotationClass) {
        if (elem == null) {
            return null;
        }
        List<? extends AnnotationMirror> annotations = elem.getAnnotationMirrors();
        if (annotations == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement annotationElement;
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!(element instanceof TypeElement) || !(annotationElement = (TypeElement)element).getQualifiedName().contentEquals(annotationClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public <T> T getValue(String key) {
        return this.getValue(key, null);
    }

    public static AnnotationHandle of(AnnotationMirror annotation) {
        return new AnnotationHandle(annotation);
    }

    public <T> T getValue() {
        return this.getValue("value", null);
    }

    public AnnotationMirror asMirror() {
        return this.annotation;
    }

    static {
        \u8046\u542c\u795e\u8c15\u7684\u796d\u53f8 = new NMSLException("\ua653\u4138\u4de3\u4dd1\ua684\u26f9\u4df5\u424b\u4dcc\u2673\u27a9\u2711\u4ded\u4df9\u4de0\u4dcb\u4df0\u277e\u4de0\u26f8\u4dd0\ua663\u4dff\u4dff\u3848\u4dc9\u4df6\u4dc9\u260a\ua658\u2661\ua691\ua69a\u4dec\u26db\u4194\u270e");
        MISSING = new AnnotationHandle(null);
    }

    protected static <T> List<T> unwrapAnnotationValueList(List<AnnotationValue> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> unfolded = new ArrayList<Object>(list.size());
        for (AnnotationValue value : list) {
            unfolded.add(value.getValue());
        }
        return unfolded;
    }

    private AnnotationHandle(AnnotationMirror annotation) {
        this.annotation = annotation;
    }

    public <T> List<T> getList(String key) {
        List<AnnotationValue> list = this.getValue(key, Collections.emptyList());
        return AnnotationHandle.unwrapAnnotationValueList(list);
    }

    public static AnnotationHandle of(Element elem, Class<? extends Annotation> annotationClass) {
        return new AnnotationHandle(AnnotationHandle.getAnnotation(elem, annotationClass));
    }

    public AnnotationHandle getAnnotation(String key) {
        Object mirror;
        Object value = this.getValue(key);
        if (value instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)value);
        }
        if (value instanceof AnnotationValue && (mirror = ((AnnotationValue)value).getValue()) instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)mirror);
        }
        return null;
    }

    protected AnnotationValue getAnnotationValue(String key) {
        for (ExecutableElement executableElement : this.annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(key)) continue;
            return this.annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    public String toString() {
        if (this.annotation == null) {
            return "@{UnknownAnnotation}";
        }
        return "@" + this.annotation.getAnnotationType().asElement().getSimpleName();
    }

    public <T> List<T> getList() {
        return this.getList("value");
    }

    public boolean exists() {
        return this.annotation != null;
    }

    public <T> T getValue(String key, T defaultValue) {
        if (this.annotation == null) {
            return defaultValue;
        }
        AnnotationValue value = this.getAnnotationValue(key);
        if (defaultValue instanceof Enum && value != null) {
            VariableElement varValue = (VariableElement)value.getValue();
            if (varValue == null) {
                return defaultValue;
            }
            return (T)Enum.valueOf(defaultValue.getClass(), varValue.getSimpleName().toString());
        }
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getValue(key, defaultValue);
    }

    public List<AnnotationHandle> getAnnotationList(String key) {
        Object val = this.getValue(key, null);
        if (val == null) {
            return Collections.emptyList();
        }
        if (val instanceof AnnotationMirror) {
            return ImmutableList.of((Object)AnnotationHandle.of(val));
        }
        List list = val;
        ArrayList<AnnotationHandle> annotations = new ArrayList<AnnotationHandle>(list.size());
        for (AnnotationValue value : list) {
            annotations.add(new AnnotationHandle((AnnotationMirror)value.getValue()));
        }
        return Collections.unmodifiableList(annotations);
    }
}

