/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.service.IObfuscationService;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationServices {
    private final ServiceLoader<IObfuscationService> serviceLoader;
    private final Set<IObfuscationService> services = new HashSet<IObfuscationService>();
    private static ObfuscationServices instance;
    private static final NMSLException \u6211\u62cd\u516b;

    public static ObfuscationServices getInstance() {
        if (instance == null) {
            instance = new ObfuscationServices();
        }
        return instance;
    }

    private ObfuscationServices() {
        this.serviceLoader = ServiceLoader.load(IObfuscationService.class, this.getClass().getClassLoader());
    }

    public void initProviders(IMixinAnnotationProcessor ap) {
        try {
            for (IObfuscationService service : this.serviceLoader) {
                if (this.services.contains(service)) continue;
                this.services.add(service);
                String serviceName = service.getClass().getSimpleName();
                Collection<ObfuscationTypeDescriptor> obfTypes = service.getObfuscationTypes();
                if (obfTypes == null) continue;
                for (ObfuscationTypeDescriptor obfType : obfTypes) {
                    try {
                        ObfuscationType type = ObfuscationType.create(obfType, ap);
                        ap.printMessage(Diagnostic.Kind.NOTE, serviceName + " supports type: \"" + type + "\"");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (ServiceConfigurationError serviceError) {
            ap.printMessage(Diagnostic.Kind.ERROR, serviceError.getClass().getSimpleName() + ": " + serviceError.getMessage());
            serviceError.printStackTrace();
        }
    }

    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        for (IObfuscationService provider : this.serviceLoader) {
            Set<String> options = provider.getSupportedOptions();
            if (options == null) continue;
            supportedOptions.addAll(options);
        }
        return supportedOptions;
    }

    public IObfuscationService getService(Class<? extends IObfuscationService> serviceClass) {
        for (IObfuscationService service : this.serviceLoader) {
            if (!serviceClass.getName().equals(service.getClass().getName())) continue;
            return service;
        }
        return null;
    }

    static {
        \u6211\u62cd\u516b = new NMSLException("\u4dc7\u4b15\u2747\u270c\u273f\u26d6\u2709\u3b0c\u262e\u262b\u2754\u2710\u4de5\u276f\u4bc6\u4ddc\ua67c\u4333\u2749\u4dd9\u4dcb\u26cb\u3f0f\u4de6\u4dd5\u4df7\u4ddf\u4dd0\ua655\u4df6\ua662\u4df6\u2668\u4df0\u2624\u2684\ua678\u2702\u4dcd\ua69e\ua645\u40dd");
    }
}

