/*
 * Decompiled with CFR 0.152.
 */
package pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u9521\u9499\u5e03\u6d1b\u514b;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pers.XiaoShadiao.NMSLException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.Config\u7ba1\u7406.Config\u7ba1\u7406;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u7f07\u5b81\u7f07\u5b81\u7f07\u5b89\u7f07\u5b9d\u7f07\u5b81\u7f07\u5b81\u7f07\u5b81;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u7f07\u5b9d\u7f07\u5b89\u7f07\u5b89\u7f07\u5b89\u7f07\u5b9d\u7f07\u5b9d\u7f07\u5b81;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u9521\u9499\u5e03\u6d1b\u514b.Line;

public class \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488 {
    private static final AxisAlignedBB ODAWA_BB;
    private static final Vec3 JUNGLE_DOOR_OFFSET_FROM_CRYSTAL;
    private static final ArrayDeque<ParticleData> seenParticles;
    private static final AxisAlignedBB MINES_OF_DIVAN_BB;
    private Line solutionIntersectionLine;
    private static final AxisAlignedBB HOLLOWS_BB;
    private static final AxisAlignedBB MAGMA_FIELDS_BB;
    private Compass firstCompass;
    private Vec3 originalSolution;
    private static final AxisAlignedBB NUCLEUS_BB;
    private SolverState solverState;
    public CrystalSetSupplier foundCrystals;
    public BooleanSupplier kingsScentPresent;
    private Vec3 solution;
    public LongSupplier currentTimeMillis = System::currentTimeMillis;
    private static final AxisAlignedBB JUNGLE_TEMPLE_BB;
    private static final Minecraft mc;
    private static final double MAX_DISTANCE_BETWEEN_PARTICLES = 0.6;
    private static final AxisAlignedBB MITHRIL_DEPOSITS_BB;
    public static final long ALL_PARTICLES_MAX_MILLIS = 5000L;
    private static final double MINIMUM_DISTANCE_SQ_BETWEEN_COMPASSES = 64.0;
    private Compass secondCompass;
    private static final AxisAlignedBB JUNGLE_BB;
    private static final AxisAlignedBB GOBLIN_HOLDOUT_BB;
    private static final AxisAlignedBB GOBLIN_QUEEN_BB;
    private static final double MAX_DISTANCE_FROM_USE_TO_FIRST_PARTICLE = 9.0;
    private static boolean isSkytilsPresent;
    private static final AxisAlignedBB PRECURSOR_CITY_BB;
    private Set<CompassTarget> solutionPossibleTargets;
    private static final AxisAlignedBB PRECURSOR_REMNANTS_BB;
    private static final \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488 INSTANCE;
    public boolean foundGoblinKing;
    public BooleanSupplier keyInInventory;
    private Set<CompassTarget> possibleTargets;
    private static final AxisAlignedBB GOBLIN_KING_BB;
    private static final AxisAlignedBB KHAZAD_DUM_BB;
    private static final NMSLException \u6211\u62cd\u4e5d;

    @SubscribeEvent
    public void \u804a\u5929\u6846\u4e8b\u4ef6(ClientChatReceivedEvent event) {
        this.foundGoblinKing = this.foundGoblinKing ? this.foundGoblinKing : event.message.func_150260_c().contains("[NPC]") && event.message.func_150260_c().contains("King");
    }

    public SolverState getSolverState() {
        return this.solverState;
    }

    public Set<CompassTarget> getPossibleTargets() {
        return this.possibleTargets;
    }

    public Vec3i getSolutionCoords() {
        return new Vec3i(this.solution.field_72450_a, this.solution.field_72448_b, this.solution.field_72449_c);
    }

    public \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488() {
        this.kingsScentPresent = this::isKingsScentPresent;
        this.keyInInventory = this::isKeyInInventory;
        this.foundCrystals = this::getFoundCrystals;
    }

    @SubscribeEvent
    public void onPacket(\u7f07\u5b81\u7f07\u5b81\u7f07\u5b89\u7f07\u5b9d\u7f07\u5b81\u7f07\u5b81\u7f07\u5b81 event) {
        if (event.\u8981\u6765\u4e86\u5427 instanceof S2APacketParticles) {
            this.onSpawnParticle(((S2APacketParticles)event.\u8981\u6765\u4e86\u5427).func_179749_a(), ((S2APacketParticles)event.\u8981\u6765\u4e86\u5427).func_149220_d(), ((S2APacketParticles)event.\u8981\u6765\u4e86\u5427).func_149226_e(), ((S2APacketParticles)event.\u8981\u6765\u4e86\u5427).func_149225_f());
        }
    }

    private Set<CompassTarget> calculatePossibleTargets(Vec3 playerPos) {
        HashSet<CompassTarget> candidateTargets = new HashSet<CompassTarget>(){
            private static final NMSLException \u4f60\u62cd\u516b = new NMSLException("\u4dcd\u4dd9\u4dc2\u2710\u277e\u4de2\ua686\u4df2\u4dd7\u4de6\u4df4\u4df6\u4dc0\ua64c\u274e\u4df2\u2713\u4de3\u2708\u4dfe\u4dd1\u4ddb\u3aed\u4dd2\u4dc4\u276d\u3c82\ua671\u2747\u2646\u2645\u2713\u4dee\u4ced\u2712\u4dd7\u4dd3\u4de0");
            {
                this.add(CompassTarget.CRYSTAL_NUCLEUS);
            }
        };
        Set<Crystal> foundCrystals = this.foundCrystals.getAsCrystalSet();
        block7: for (Crystal crystal : Crystal.values()) {
            if (foundCrystals.contains((Object)crystal)) continue;
            switch (crystal) {
                case JADE: {
                    candidateTargets.add(CompassTarget.MINES_OF_DIVAN);
                    continue block7;
                }
                case AMBER: {
                    candidateTargets.add(this.kingsScentPresent.getAsBoolean() ? CompassTarget.GOBLIN_QUEEN : CompassTarget.GOBLIN_KING);
                    continue block7;
                }
                case TOPAZ: {
                    candidateTargets.add(CompassTarget.BAL);
                    continue block7;
                }
                case AMETHYST: {
                    candidateTargets.add(this.keyInInventory.getAsBoolean() ? CompassTarget.JUNGLE_TEMPLE : CompassTarget.ODAWA);
                    continue block7;
                }
                case SAPPHIRE: {
                    candidateTargets.add(CompassTarget.PRECURSOR_CITY);
                }
            }
        }
        return candidateTargets;
    }

    private void showSolution() {
        if (this.solution == null) {
            return;
        }
        if (NUCLEUS_BB.func_72318_a(this.solution)) {
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] " + EnumChatFormatting.AQUA + "Wishing compass target is the Crystal Nucleus"));
            return;
        }
        String destinationMessage = this.getWishingCompassDestinationsMessage();
        if (!isSkytilsPresent) {
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(destinationMessage));
            return;
        }
        String targetNameForSkytils = this.solutionPossibleTargets.size() == 1 ? this.getNameForCompassTarget(this.solutionPossibleTargets.iterator().next()) : "WishingTarget";
        String skytilsCommand = String.format("/sthw add %s %s", this.getSolutionCoordsText(), targetNameForSkytils);
        if (this.solutionPossibleTargets.size() == 1) {
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(destinationMessage));
            int commandResult = ClientCommandHandler.instance.func_71556_a((ICommandSender)\u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g, skytilsCommand);
            if (commandResult == 1) {
                return;
            }
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Failed to automatically run /sthw"));
        }
        destinationMessage = destinationMessage + "\u00a7e[Add Skytils Waypoint]";
        ChatComponentText chatMessage = new ChatComponentText(destinationMessage);
        chatMessage.func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, skytilsCommand)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Set waypoint for wishing target"))));
        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)chatMessage);
    }

    public static Set<CompassTarget> getSolutionTargets(HollowsZone compassUsedZone, Set<Crystal> foundCrystals, Set<CompassTarget> possibleTargets, Vec3 solution) {
        HashSet<CompassTarget> solutionPossibleTargets = new HashSet<CompassTarget>(possibleTargets);
        HollowsZone solutionZone = \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.getZoneForCoords(solution);
        if (solutionZone == HollowsZone.CRYSTAL_NUCLEUS) {
            return solutionPossibleTargets;
        }
        solutionPossibleTargets.remove((Object)CompassTarget.CRYSTAL_NUCLEUS);
        if (solutionPossibleTargets.contains((Object)CompassTarget.BAL) && solution.field_72448_b > 75.0) {
            solutionPossibleTargets.remove((Object)CompassTarget.BAL);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.GOBLIN_KING) && solution.field_72448_b < 82.0 || solution.field_72448_b > 168.0) {
            solutionPossibleTargets.remove((Object)CompassTarget.GOBLIN_KING);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.GOBLIN_QUEEN) && (solution.field_72448_b < 125.0 || solution.field_72448_b > 140.0)) {
            solutionPossibleTargets.remove((Object)CompassTarget.GOBLIN_QUEEN);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.JUNGLE_TEMPLE) && (solution.field_72448_b < 72.0 || solution.field_72448_b > 81.0)) {
            solutionPossibleTargets.remove((Object)CompassTarget.JUNGLE_TEMPLE);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.ODAWA) && (solution.field_72448_b < 73.0 || solution.field_72448_b > 155.0)) {
            solutionPossibleTargets.remove((Object)CompassTarget.ODAWA);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.PRECURSOR_CITY) && (solution.field_72448_b < 121.0 || solution.field_72448_b > 130.0)) {
            solutionPossibleTargets.remove((Object)CompassTarget.PRECURSOR_CITY);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.MINES_OF_DIVAN) && (solution.field_72448_b < 97.0 || solution.field_72448_b > 102.0)) {
            solutionPossibleTargets.remove((Object)CompassTarget.MINES_OF_DIVAN);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.GOBLIN_KING) && (solution.field_72450_a > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_HOLDOUT_BB.field_72336_d + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_KING_BB.field_72336_d || solution.field_72449_c < \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_HOLDOUT_BB.field_72339_c - \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_KING_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.GOBLIN_KING);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.GOBLIN_QUEEN) && (solution.field_72450_a > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_HOLDOUT_BB.field_72336_d + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_QUEEN_BB.field_72336_d || solution.field_72449_c < \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_HOLDOUT_BB.field_72339_c - \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.GOBLIN_QUEEN_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.GOBLIN_QUEEN);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.JUNGLE_TEMPLE) && (solution.field_72450_a > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_BB.field_72336_d + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_TEMPLE_BB.field_72336_d || solution.field_72449_c > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_BB.field_72334_f + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_TEMPLE_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.JUNGLE_TEMPLE);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.ODAWA) && (solution.field_72450_a > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_BB.field_72336_d + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.ODAWA_BB.field_72336_d || solution.field_72449_c > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.JUNGLE_BB.field_72334_f + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.ODAWA_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.ODAWA);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.PRECURSOR_CITY) && (solution.field_72450_a < \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.PRECURSOR_REMNANTS_BB.field_72340_a - \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.PRECURSOR_CITY_BB.field_72336_d || solution.field_72449_c < \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.PRECURSOR_REMNANTS_BB.field_72339_c - \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.PRECURSOR_CITY_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.PRECURSOR_CITY);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.MINES_OF_DIVAN) && (solution.field_72450_a < \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.MITHRIL_DEPOSITS_BB.field_72340_a - \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.MINES_OF_DIVAN_BB.field_72336_d || solution.field_72449_c > \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.MITHRIL_DEPOSITS_BB.field_72334_f + \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.MINES_OF_DIVAN_BB.field_72334_f)) {
            solutionPossibleTargets.remove((Object)CompassTarget.MINES_OF_DIVAN);
        }
        if (solutionPossibleTargets.contains((Object)CompassTarget.JUNGLE_TEMPLE) && solutionPossibleTargets.contains((Object)CompassTarget.BAL) && !foundCrystals.contains((Object)Crystal.AMETHYST) && compassUsedZone == HollowsZone.JUNGLE) {
            solutionPossibleTargets.remove((Object)CompassTarget.BAL);
        }
        return solutionPossibleTargets;
    }

    private String getWishingCompassDestinationsMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(EnumChatFormatting.YELLOW);
        sb.append("\u00a7a[\u5c0f\u6c99\u96d5 | \u00a7eNEU] ");
        sb.append(EnumChatFormatting.AQUA);
        sb.append("Wishing compass points to ");
        int index = 1;
        for (CompassTarget target : this.solutionPossibleTargets) {
            if (index > 1) {
                sb.append(EnumChatFormatting.AQUA);
                if (index == this.solutionPossibleTargets.size()) {
                    sb.append(" or ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.getFriendlyNameForCompassTarget(target));
            ++index;
        }
        sb.append(EnumChatFormatting.AQUA);
        sb.append(" (");
        sb.append(this.getSolutionCoordsText());
        sb.append(")");
        return sb.toString();
    }

    public static \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488 getInstance() {
        return INSTANCE;
    }

    private String getNameForCompassTarget(CompassTarget compassTarget) {
        boolean useSkytilsNames = true;
        switch (compassTarget) {
            case BAL: {
                return useSkytilsNames ? "internal_bal" : "Bal";
            }
            case ODAWA: {
                return "Odawa";
            }
            case JUNGLE_TEMPLE: {
                return useSkytilsNames ? "internal_temple" : "Temple";
            }
            case GOBLIN_KING: {
                return useSkytilsNames ? "internal_king" : "King";
            }
            case GOBLIN_QUEEN: {
                return useSkytilsNames ? "internal_den" : "Queen";
            }
            case PRECURSOR_CITY: {
                return useSkytilsNames ? "internal_city" : "City";
            }
            case MINES_OF_DIVAN: {
                return useSkytilsNames ? "internal_mines" : "Mines";
            }
        }
        return "WishingTarget";
    }

    public void logDiagnosticData(boolean outputAlways) {
    }

    private boolean isKeyInInventory() {
        for (ItemStack item : \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.field_71071_by.field_70462_a) {
            if (item == null || !item.func_82833_r().contains("Jungle Key")) continue;
            return true;
        }
        return false;
    }

    private String getFriendlyNameForCompassTarget(CompassTarget compassTarget) {
        switch (compassTarget) {
            case BAL: {
                return "\u00a7cBal";
            }
            case ODAWA: {
                return EnumChatFormatting.GREEN + "Odawa";
            }
            case JUNGLE_TEMPLE: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.GREEN + "Jungle Temple";
            }
            case GOBLIN_KING: {
                return EnumChatFormatting.GOLD + "King Yolkar";
            }
            case GOBLIN_QUEEN: {
                return EnumChatFormatting.AQUA + "the \u00a7eGoblin Queen";
            }
            case PRECURSOR_CITY: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.WHITE + "Precursor City";
            }
            case MINES_OF_DIVAN: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.BLUE + "Mines of Divan";
            }
        }
        return EnumChatFormatting.WHITE + "an undetermined location";
    }

    public static HollowsZone getZoneForCoords(Vec3 whereUsed) {
        if (NUCLEUS_BB.func_72318_a(whereUsed)) {
            return HollowsZone.CRYSTAL_NUCLEUS;
        }
        if (JUNGLE_BB.func_72318_a(whereUsed)) {
            return HollowsZone.JUNGLE;
        }
        if (MITHRIL_DEPOSITS_BB.func_72318_a(whereUsed)) {
            return HollowsZone.MITHRIL_DEPOSITS;
        }
        if (GOBLIN_HOLDOUT_BB.func_72318_a(whereUsed)) {
            return HollowsZone.GOBLIN_HOLDOUT;
        }
        if (PRECURSOR_REMNANTS_BB.func_72318_a(whereUsed)) {
            return HollowsZone.PRECURSOR_REMNANTS;
        }
        if (MAGMA_FIELDS_BB.func_72318_a(whereUsed)) {
            return HollowsZone.MAGMA_FIELDS;
        }
        throw new IllegalArgumentException("Coordinates do not fall in known zone");
    }

    public void solveUsingParticle(double x, double y, double z, long currentTimeMillis) {
        Compass currentCompass;
        switch (this.solverState) {
            case PROCESSING_FIRST_USE: {
                currentCompass = this.firstCompass;
                break;
            }
            case PROCESSING_SECOND_USE: {
                currentCompass = this.secondCompass;
                break;
            }
            default: {
                return;
            }
        }
        currentCompass.processParticle(x, y, z, currentTimeMillis);
        switch (currentCompass.compassState) {
            case FAILED_TIMEOUT_NO_PARTICLES: {
                this.solverState = SolverState.FAILED_TIMEOUT_NO_PARTICLES;
                return;
            }
            case FAILED_TIMEOUT_NO_REPEATING: {
                this.solverState = SolverState.FAILED_TIMEOUT_NO_REPEATING;
                return;
            }
            case WAITING_FOR_FIRST_PARTICLE: 
            case COMPUTING_LAST_PARTICLE: {
                return;
            }
            case COMPLETED: {
                if (this.solverState == SolverState.NEED_SECOND_COMPASS) {
                    return;
                }
                if (this.solverState != SolverState.PROCESSING_FIRST_USE) break;
                this.solverState = SolverState.NEED_SECOND_COMPASS;
                return;
            }
        }
        this.solutionIntersectionLine = this.firstCompass.line.getIntersectionLineSegment(this.secondCompass.line);
        if (this.solutionIntersectionLine == null) {
            this.solverState = SolverState.FAILED_INTERSECTION_CALCULATION;
            return;
        }
        this.solution = this.solutionIntersectionLine.getMidpoint();
        this.firstCompass.getDirection();
        this.firstCompass.getDirectionTo(this.solution);
        this.secondCompass.getDirection();
        this.secondCompass.getDirectionTo(this.solution);
        if (!HOLLOWS_BB.func_72318_a(this.solution)) {
            this.solverState = SolverState.FAILED_INVALID_SOLUTION;
            return;
        }
        this.solutionPossibleTargets = \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.getSolutionTargets(\u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.getZoneForCoords(this.firstCompass.whereUsed), this.foundCrystals.getAsCrystalSet(), this.possibleTargets, this.solution);
        if (this.solutionPossibleTargets.size() == 1 && this.solutionPossibleTargets.contains((Object)CompassTarget.JUNGLE_TEMPLE)) {
            this.originalSolution = this.solution;
            this.solution = this.solution.func_178787_e(JUNGLE_DOOR_OFFSET_FROM_CRYSTAL);
        }
        this.solverState = SolverState.SOLVED;
    }

    public HandleCompassResult handleCompassUse(BlockPos playerPos) {
        long lastCompassUsedMillis = 0L;
        switch (this.solverState) {
            case PROCESSING_SECOND_USE: {
                if (this.secondCompass != null) {
                    lastCompassUsedMillis = this.secondCompass.whenUsedMillis;
                }
            }
            case PROCESSING_FIRST_USE: {
                if (lastCompassUsedMillis == 0L && this.firstCompass != null) {
                    lastCompassUsedMillis = this.firstCompass.whenUsedMillis;
                }
                if (lastCompassUsedMillis != 0L && this.currentTimeMillis.getAsLong() > lastCompassUsedMillis + 5000L) {
                    return HandleCompassResult.NO_PARTICLES_FOR_PREVIOUS_COMPASS;
                }
                return HandleCompassResult.STILL_PROCESSING_PRIOR_USE;
            }
            case SOLVED: 
            case FAILED_EXCEPTION: 
            case FAILED_TIMEOUT_NO_REPEATING: 
            case FAILED_TIMEOUT_NO_PARTICLES: 
            case FAILED_INTERSECTION_CALCULATION: 
            case FAILED_INVALID_SOLUTION: {
                this.resetForNewTarget();
            }
            case NOT_STARTED: {
                if (NUCLEUS_BB.func_72318_a(new Vec3((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p()))) {
                    return HandleCompassResult.PLAYER_IN_NUCLEUS;
                }
                this.firstCompass = new Compass(new Vec3((Vec3i)playerPos), this.currentTimeMillis.getAsLong());
                seenParticles.clear();
                this.solverState = SolverState.PROCESSING_FIRST_USE;
                this.possibleTargets = this.calculatePossibleTargets(new Vec3((Vec3i)playerPos));
                return HandleCompassResult.SUCCESS;
            }
            case NEED_SECOND_COMPASS: {
                Vec3 vec3 = new Vec3((Vec3i)playerPos);
                if (this.firstCompass.whereUsed.func_72438_d(vec3) < 64.0) {
                    return HandleCompassResult.LOCATION_TOO_CLOSE;
                }
                HollowsZone firstCompassZone = \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.getZoneForCoords(this.firstCompass.whereUsed);
                HollowsZone playerZone = \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.getZoneForCoords(new Vec3((Vec3i)playerPos));
                if (!this.possibleTargets.equals(this.calculatePossibleTargets(new Vec3((Vec3i)playerPos))) || firstCompassZone != playerZone) {
                    this.resetForNewTarget();
                    return HandleCompassResult.POSSIBLE_TARGETS_CHANGED;
                }
                this.secondCompass = new Compass(new Vec3((Vec3i)playerPos), this.currentTimeMillis.getAsLong());
                this.solverState = SolverState.PROCESSING_SECOND_USE;
                return HandleCompassResult.SUCCESS;
            }
        }
        throw new IllegalStateException("Unexpected compass state");
    }

    public void initWorld() {
        this.resetForNewTarget();
    }

    private String getDiagnosticMessage() {
        StringBuilder diagsMessage = new StringBuilder();
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solver State: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solverState.name());
        diagsMessage.append("\n");
        if (this.firstCompass == null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("First Compass: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append("<NONE>");
            diagsMessage.append("\n");
        } else {
            this.firstCompass.appendCompassDiagnostics(diagsMessage, "First Compass");
        }
        if (this.secondCompass == null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Second Compass: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append("<NONE>");
            diagsMessage.append("\n");
        } else {
            this.secondCompass.appendCompassDiagnostics(diagsMessage, "Second Compass");
        }
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Intersection Line: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solutionIntersectionLine == null ? "<NONE>" : this.solutionIntersectionLine);
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Jungle Key in Inventory: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.isKeyInInventory());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("King's Scent Present: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.isKingsScentPresent());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("First Compass Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.possibleTargets == null ? "<NONE>" : this.possibleTargets.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Current Calculated Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.calculatePossibleTargets(new Vec3((Vec3i)\u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_180425_c())));
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Found Crystals: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.getFoundCrystals());
        diagsMessage.append("\n");
        if (this.originalSolution != null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Original Solution: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.originalSolution);
            diagsMessage.append("\n");
        }
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solution: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solution == null ? "<NONE>" : this.solution.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solution Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solutionPossibleTargets == null ? "<NONE>" : this.solutionPossibleTargets.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Seen particles:\n");
        for (ParticleData particleData : seenParticles) {
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(particleData);
            diagsMessage.append("\n");
        }
        return diagsMessage.toString();
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (Config\u7ba1\u7406.getSBCrystalHollowPosfinder() != 1 || !\u7f07\u5b9d\u7f07\u5b89\u7f07\u5b89\u7f07\u5b89\u7f07\u5b9d\u7f07\u5b9d\u7f07\u5b81.\u8981\u6765\u4e86\u5427().\u8981\u6765\u4e86\u5427.\u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684() || event.entityPlayer != \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g || event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != Items.field_151144_bL) {
            return;
        }
        String heldInternalName = heldItem.func_82833_r();
        if (heldInternalName == null || !heldInternalName.toLowerCase().contains("wishing compass")) {
            return;
        }
        BlockPos playerPos = \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_180425_c().getImmutable();
        try {
            HandleCompassResult result = this.handleCompassUse(playerPos);
            switch (result) {
                case SUCCESS: {
                    return;
                }
                case STILL_PROCESSING_PRIOR_USE: {
                    \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Wait a little longer before using the wishing compass again."));
                    event.setCanceled(true);
                    break;
                }
                case LOCATION_TOO_CLOSE: {
                    \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Move a little further before using the wishing compass again."));
                    event.setCanceled(true);
                    break;
                }
                case POSSIBLE_TARGETS_CHANGED: {
                    \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Possible wishing compass targets have changed. Solver has been reset."));
                    event.setCanceled(true);
                    break;
                }
                case NO_PARTICLES_FOR_PREVIOUS_COMPASS: {
                    \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] No particles detected for prior compass use. Need another position to solve."));
                    break;
                }
                case PLAYER_IN_NUCLEUS: {
                    \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Wishing compass must be used outside the nucleus for accurate results."));
                    event.setCanceled(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected wishing compass solver state: \n" + this.getDiagnosticMessage());
                }
            }
        }
        catch (Exception e) {
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Error processing wishing compass action - see log for details"));
            e.printStackTrace();
            event.setCanceled(true);
            this.solverState = SolverState.FAILED_EXCEPTION;
        }
    }

    private void resetForNewTarget() {
        this.solverState = SolverState.NOT_STARTED;
        this.firstCompass = null;
        this.secondCompass = null;
        this.solutionIntersectionLine = null;
        this.possibleTargets = null;
        this.solution = null;
        this.originalSolution = null;
        this.solutionPossibleTargets = null;
    }

    private boolean isKingsScentPresent() {
        return this.foundGoblinKing;
    }

    private Set<Crystal> getFoundCrystals() {
        return new HashSet<Crystal>();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Unload event) {
        this.initWorld();
        isSkytilsPresent = Loader.isModLoaded((String)"skytils");
        this.foundGoblinKing = false;
    }

    static {
        \u6211\u62cd\u4e5d = new NMSLException("\u4df5\u4de2\u2696\u3bbf\u261f\u4ddb\u4de2\ua698\ua645\u4df1\u2671\u268a\u3dbf\u274c\u4dcf\u4de6\u4ddb\u4996\u4dc9\u4dc8\u4ded\u4dc6\u4de6\u4ceb\ua68e\u4dde\u2772\u4dc6\u3ca1\ua678\u3e8c\u4df5\u4dc7\u4de3\u4ddd\ua640\u275a\u4dd7\u278f\u4df4");
        INSTANCE = new \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488();
        mc = Minecraft.func_71410_x();
        isSkytilsPresent = false;
        seenParticles = new ArrayDeque();
        NUCLEUS_BB = new AxisAlignedBB(462.0, 63.0, 461.0, 564.0, 181.0, 565.0);
        HOLLOWS_BB = new AxisAlignedBB(201.0, 30.0, 201.0, 824.0, 189.0, 824.0);
        PRECURSOR_REMNANTS_BB = new AxisAlignedBB(512.0, 63.0, 512.0, 824.0, 189.0, 824.0);
        MITHRIL_DEPOSITS_BB = new AxisAlignedBB(512.0, 63.0, 201.0, 824.0, 189.0, 513.0);
        GOBLIN_HOLDOUT_BB = new AxisAlignedBB(201.0, 63.0, 512.0, 513.0, 189.0, 824.0);
        JUNGLE_BB = new AxisAlignedBB(201.0, 63.0, 201.0, 513.0, 189.0, 513.0);
        MAGMA_FIELDS_BB = new AxisAlignedBB(201.0, 30.0, 201.0, 824.0, 64.0, 824.0);
        PRECURSOR_CITY_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 107.0, 122.0, 107.0);
        GOBLIN_KING_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 59.0, 53.0, 56.0);
        GOBLIN_QUEEN_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 114.0, 108.0);
        JUNGLE_TEMPLE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 120.0, 108.0);
        ODAWA_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 53.0, 46.0, 54.0);
        MINES_OF_DIVAN_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 125.0, 108.0);
        KHAZAD_DUM_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 110.0, 46.0, 108.0);
        JUNGLE_DOOR_OFFSET_FROM_CRYSTAL = new Vec3(-57.0, 36.0, -21.0);
    }

    private String getSolutionCoordsText() {
        return this.solution == null ? "" : String.format("%.0f %.0f %.0f", this.solution.field_72450_a, this.solution.field_72448_b, this.solution.field_72449_c);
    }

    public void onSpawnParticle(EnumParticleTypes particleType, double x, double y, double z) {
        if (particleType != EnumParticleTypes.VILLAGER_HAPPY || Config\u7ba1\u7406.getSBCrystalHollowPosfinder() != 1 || !\u7f07\u5b9d\u7f07\u5b89\u7f07\u5b89\u7f07\u5b89\u7f07\u5b9d\u7f07\u5b9d\u7f07\u5b81.\u8981\u6765\u4e86\u5427().\u8981\u6765\u4e86\u5427.\u5c0f\u77a7\u6211\u4eec\u53ef\u662f\u4f1a\u5403\u4e8f\u7684()) {
            return;
        }
        if (this.firstCompass != null && !this.solverState.equals((Object)SolverState.SOLVED) && System.currentTimeMillis() < this.firstCompass.whenUsedMillis + 120000L) {
            seenParticles.add(new ParticleData(new Vec3(x, y, z), System.currentTimeMillis()));
        }
        try {
            SolverState originalSolverState = this.solverState;
            this.solveUsingParticle(x, y, z, this.currentTimeMillis.getAsLong());
            if (this.solverState != originalSolverState) {
                switch (this.solverState) {
                    case SOLVED: {
                        this.showSolution();
                        break;
                    }
                    case FAILED_EXCEPTION: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Unable to determine wishing compass target."));
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_TIMEOUT_NO_REPEATING: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Timed out waiting for repeat set of compass particles."));
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_TIMEOUT_NO_PARTICLES: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Timed out waiting for compass particles."));
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_INTERSECTION_CALCULATION: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Unable to determine intersection of wishing compasses."));
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_INVALID_SOLUTION: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Failed to find solution."));
                        this.logDiagnosticData(false);
                        break;
                    }
                    case NEED_SECOND_COMPASS: {
                        \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7e | NEU] Need another position to determine wishing compass target."));
                        break;
                    }
                    case NOT_STARTED: {
                        break;
                    }
                    case PROCESSING_FIRST_USE: {
                        break;
                    }
                    case PROCESSING_SECOND_USE: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            \u6c34\u6676\u77ff\u6d1e\u7948\u613f\u6307\u5357\u9488.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[\u5c0f\u6c99\u96d5\u00a7c | NEU] Exception while calculating wishing compass solution - see log for details"));
            e.printStackTrace();
        }
    }

    private static class ParticleData {
        long systemTime;
        Vec3 particleLocation;
        private static final NMSLException \u8d70\u5f00\u8d70\u5f00 = new NMSLException("\u3e9a\u265c\u4ddc\u4c6c\u4dd9\ua666\u4ded\u4dc4\u26cd\u3c84\u4816\u414e\u2613\u4de8\u4def\u273f\u4af0\u2618\u4052\u277d\u26c6\u4df2\ua659\u2725\ua643\u4de8\ua65b\u4ddc\u2710\u4ddf\u2762\u277d\u4a35\u2687");

        public String toString() {
            return "Location: " + this.particleLocation.toString() + ", systemTime: " + this.systemTime;
        }

        public ParticleData(Vec3 particleLocation, long systemTime) {
            this.particleLocation = particleLocation;
            this.systemTime = systemTime;
        }
    }

    static class Compass {
        private final long whenUsedMillis;
        private Vec3 lastParticle = null;
        private final Vec3 whereUsed;
        private Vec3 firstParticle = null;
        public Line line = null;
        private Vec3 previousParticle = null;
        public CompassState compassState;
        private final ArrayList<ProcessedParticle> processedParticles;
        private static final NMSLException \u6211\u4eec\u7a7f\u8fc7\u4e86\u4e07\u5f84\u4e4b\u95e8 = new NMSLException("\u2782\u26d3\ua641\ua69d\u276e\u4def\u2714\u269a\u4dea\ua652\ua668\u2637\u4de3\u4df3\u37df\u4dcd\u4dc5\u3b45\u2668\u4dc3\u411a\ua674\u4ded\ua652\u264a\u4cdf\u4dee\u4dc2\ua642\u4dfe\u4ddb\u2794\u4dcd\u4dcc\u4dc6\ua65d\ua684\u2643");

        Compass(Vec3 whereUsed, long whenUsedMillis) {
            this.whereUsed = whereUsed;
            this.whenUsedMillis = whenUsedMillis;
            this.compassState = CompassState.WAITING_FOR_FIRST_PARTICLE;
            this.processedParticles = new ArrayList();
        }

        public void appendCompassDiagnostics(StringBuilder diagsMessage, String compassName) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Compass State: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.compassState.name());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Used Millis: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.whenUsedMillis);
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Used Position: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.whereUsed == null ? "<NONE>" : this.whereUsed.toString());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" All Seen Particles: \n");
            diagsMessage.append(EnumChatFormatting.WHITE);
            for (ProcessedParticle particle : this.processedParticles) {
                diagsMessage.append(particle.toString());
                diagsMessage.append("\n");
            }
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Particle Spread: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.particleSpread());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Compass Line: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.line == null ? "<NONE>" : this.line.toString());
            diagsMessage.append("\n");
        }

        public double particleSpread() {
            if (this.firstParticle == null || this.lastParticle == null) {
                return 0.0;
            }
            return this.firstParticle.func_72438_d(this.lastParticle);
        }

        public void processParticle(double x, double y, double z, long particleTimeMillis) {
            if (this.compassState == CompassState.FAILED_TIMEOUT_NO_REPEATING || this.compassState == CompassState.FAILED_TIMEOUT_NO_PARTICLES || this.compassState == CompassState.COMPLETED) {
                throw new UnsupportedOperationException("processParticle should not be called in a failed or completed state");
            }
            if (particleTimeMillis - this.whenUsedMillis > 5000L) {
                this.compassState = CompassState.FAILED_TIMEOUT_NO_REPEATING;
                return;
            }
            Vec3 currentParticle = new Vec3(x, y, z);
            if (this.compassState == CompassState.WAITING_FOR_FIRST_PARTICLE) {
                if (currentParticle.func_72438_d(this.whereUsed) < 9.0) {
                    this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
                    this.firstParticle = currentParticle;
                    this.previousParticle = currentParticle;
                    this.compassState = CompassState.COMPUTING_LAST_PARTICLE;
                }
                return;
            }
            if (currentParticle.func_72438_d(this.previousParticle) <= 0.6) {
                this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
                this.previousParticle = currentParticle;
                return;
            }
            if (currentParticle.func_72438_d(this.firstParticle) > 0.6) {
                return;
            }
            this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
            this.lastParticle = this.previousParticle;
            this.line = new Line(this.firstParticle, this.lastParticle);
            this.compassState = CompassState.COMPLETED;
        }

        public Vec3 getDirection() {
            if (this.firstParticle == null || this.lastParticle == null) {
                return null;
            }
            return this.firstParticle.func_72444_a(this.lastParticle);
        }

        public Vec3 getDirectionTo(Vec3 target) {
            if (this.firstParticle == null || target == null) {
                return null;
            }
            return this.firstParticle.func_72444_a(target);
        }

        static class ProcessedParticle {
            long particleTimeMillis;
            Vec3 coords;
            private static final NMSLException \u8fdc\u65b9\u4f1a\u662f\u65b0\u7684\u4e16\u754c = new NMSLException("\u4dc3\u2663\u4df2\u492e\u26ca\u4df7\u275a\ua67a\u4def\u4df8\u274d\u4dd9\u26e2\u4dc6\ua64b\u4dff\u4dcd\u3b61\u4dda\u4dc3\u491c\ua665\u4dca\u4ddd\u4de0\u2656\u262f\u4de2\u4de5\u4dfa\u4dc9\u26d2\u4dda\u275c\u4dd9\u4dfb\ua65e\u4dc5\u26c5\u4dc1\u4df6\u4de7\u4dfd\ua647\u4df2\u4dcf\u4dcd\u4df2\u34a4");

            public String toString() {
                return this.coords.toString() + " " + this.particleTimeMillis;
            }

            ProcessedParticle(Vec3 coords, long particleTimeMillis) {
                this.coords = coords;
                this.particleTimeMillis = particleTimeMillis;
            }
        }
    }

    static enum HandleCompassResult {
        SUCCESS,
        LOCATION_TOO_CLOSE,
        STILL_PROCESSING_PRIOR_USE,
        POSSIBLE_TARGETS_CHANGED,
        NO_PARTICLES_FOR_PREVIOUS_COMPASS,
        PLAYER_IN_NUCLEUS;

    }

    static enum CompassState {
        WAITING_FOR_FIRST_PARTICLE,
        COMPUTING_LAST_PARTICLE,
        COMPLETED,
        FAILED_TIMEOUT_NO_REPEATING,
        FAILED_TIMEOUT_NO_PARTICLES;

    }

    public static interface CrystalSetSupplier {
        public Set<Crystal> getAsCrystalSet();
    }

    static enum HollowsZone {
        CRYSTAL_NUCLEUS,
        JUNGLE,
        MITHRIL_DEPOSITS,
        GOBLIN_HOLDOUT,
        PRECURSOR_REMNANTS,
        MAGMA_FIELDS;

    }

    static enum Crystal {
        AMBER,
        AMETHYST,
        JADE,
        SAPPHIRE,
        TOPAZ;

    }

    static enum CompassTarget {
        GOBLIN_QUEEN,
        GOBLIN_KING,
        BAL,
        JUNGLE_TEMPLE,
        ODAWA,
        PRECURSOR_CITY,
        MINES_OF_DIVAN,
        CRYSTAL_NUCLEUS;

    }

    static enum SolverState {
        NOT_STARTED,
        PROCESSING_FIRST_USE,
        NEED_SECOND_COMPASS,
        PROCESSING_SECOND_USE,
        SOLVED,
        FAILED_EXCEPTION,
        FAILED_TIMEOUT_NO_REPEATING,
        FAILED_TIMEOUT_NO_PARTICLES,
        FAILED_INTERSECTION_CALCULATION,
        FAILED_INVALID_SOLUTION;

    }
}

