/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javazoom.jl.converter.WaveFileObuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;
import pers.XiaoShadiao.NMSLException;

public class Converter {
    private static final NMSLException \u6211\u4eec\u7a7f\u8fc7\u4e86\u4e07\u5f84\u4e4b\u95e8 = new NMSLException("\u26b8\ua67f\u271f\ua68e\ua683\u4ddc\ua69a\u27a8\u4dd6\u2739\u3eaf\u4dcf\u2707\u2742\u4dc0\u2785\u271e\u4abb\u4dc8\u2612\u4ded\u278f\u4df9\u4dc5\u4dc2\u4dfa\u4dd9\u4dda\u4dd4\u2725\u49a6\u4dec\u36a2\u27ae\ua682");

    protected InputStream openInput(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        BufferedInputStream bufIn = new BufferedInputStream(fileIn);
        return bufIn;
    }

    public synchronized void convert(String sourceName, String destName) throws JavaLayerException {
        this.convert(sourceName, destName, null, null);
    }

    public void convert(String sourceName, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (destName.length() == 0) {
            destName = null;
        }
        try {
            InputStream in = this.openInput(sourceName);
            this.convert(in, destName, progressListener, decoderParams);
            in.close();
        }
        catch (IOException ioe) {
            throw new JavaLayerException(ioe.getLocalizedMessage(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(InputStream sourceStream, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (progressListener == null) {
            progressListener = PrintWriterProgressListener.newStdOut(0);
        }
        try {
            int frame;
            if (!(sourceStream instanceof BufferedInputStream)) {
                sourceStream = new BufferedInputStream(sourceStream);
            }
            int frameCount = -1;
            if (sourceStream.markSupported()) {
                sourceStream.mark(-1);
                frameCount = this.countFrames(sourceStream);
                sourceStream.reset();
            }
            progressListener.converterUpdate(1, frameCount, 0);
            Obuffer output = null;
            Decoder decoder = new Decoder(decoderParams);
            Bitstream stream = new Bitstream(sourceStream);
            if (frameCount == -1) {
                frameCount = Integer.MAX_VALUE;
            }
            long startTime = System.currentTimeMillis();
            try {
                for (frame = 0; frame < frameCount; ++frame) {
                    try {
                        Obuffer decoderOutput;
                        Header header = stream.readFrame();
                        if (header == null) {
                            break;
                        }
                        progressListener.readFrame(frame, header);
                        if (output == null) {
                            int channels = header.mode() == 3 ? 1 : 2;
                            int freq = header.frequency();
                            output = new WaveFileObuffer(channels, freq, destName);
                            decoder.setOutputBuffer(output);
                        }
                        if ((decoderOutput = decoder.decodeFrame(header, stream)) != output) {
                            throw new InternalError("Output buffers are different.");
                        }
                        progressListener.decodedFrame(frame, header, output);
                        stream.closeFrame();
                        continue;
                    }
                    catch (Exception ex) {
                        boolean stop;
                        boolean bl = stop = !progressListener.converterException(ex);
                        if (!stop) continue;
                        throw new JavaLayerException(ex.getLocalizedMessage(), ex);
                    }
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
            int time = (int)(System.currentTimeMillis() - startTime);
            progressListener.converterUpdate(2, time, frame);
        }
        catch (IOException ex) {
            throw new JavaLayerException(ex.getLocalizedMessage(), ex);
        }
    }

    public synchronized void convert(String sourceName, String destName, ProgressListener progressListener) throws JavaLayerException {
        this.convert(sourceName, destName, progressListener, null);
    }

    protected int countFrames(InputStream in) {
        return -1;
    }

    public static class PrintWriterProgressListener
    implements ProgressListener {
        public static final int NO_DETAIL = 0;
        public static final int VERBOSE_DETAIL = 2;
        public static final int MAX_DETAIL = 10;
        private int detailLevel;
        private PrintWriter pw;
        public static final int EXPERT_DETAIL = 1;
        public static final int DEBUG_DETAIL = 7;
        private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b89\u5c31\u9178\u5f97\u54c7\u54c7\u4e71\u53eb\u5566 = new NMSLException("\u277e\u4df2\u4de6\u4de8\u277d\u26b5\u4dc7\u26de\u4dc2\ua666\u2627\u4dcf\u4df8\u4dfb\u3518\u4dcf\u26b4\u263b\u265a\u4dc0\u2799\u4dc1\ua641\u26e9\u4dd5\u4dd6\u41a5\u4de7\u271c\u4dce\u4de4\u4dde\ua64a\u2710\u4dc9\u4de0\u4de2");

        public boolean isDetail(int detail) {
            return this.detailLevel >= detail;
        }

        @Override
        public void converterUpdate(int updateID, int param1, int param2) {
            if (this.isDetail(2)) {
                switch (updateID) {
                    case 2: {
                        if (param2 == 0) {
                            param2 = 1;
                        }
                        this.pw.println();
                        this.pw.println("Converted " + param2 + " frames in " + param1 + " ms (" + param1 / param2 + " ms per frame.)");
                    }
                }
            }
        }

        @Override
        public void decodedFrame(int frameNo, Header header, Obuffer o) {
            if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Decoded frame " + frameNo + ": " + headerString);
                this.pw.println("Output: " + o);
            } else if (this.isDetail(2)) {
                if (frameNo == 0) {
                    this.pw.print("Converting.");
                    this.pw.flush();
                }
                if (frameNo % 10 == 0) {
                    this.pw.print('.');
                    this.pw.flush();
                }
            }
        }

        @Override
        public void parsedFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Prased frame " + frameNo + ": " + headerString);
            }
        }

        @Override
        public void readFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Read frame " + frameNo + ": " + headerString);
            }
        }

        public PrintWriterProgressListener(PrintWriter writer, int detailLevel) {
            this.pw = writer;
            this.detailLevel = detailLevel;
        }

        @Override
        public boolean converterException(Throwable t) {
            if (this.detailLevel > 0) {
                t.printStackTrace(this.pw);
                this.pw.flush();
            }
            return false;
        }

        public static PrintWriterProgressListener newStdOut(int detail) {
            return new PrintWriterProgressListener(new PrintWriter(System.out, true), detail);
        }
    }

    public static interface ProgressListener {
        public static final int UPDATE_CONVERT_COMPLETE = 2;
        public static final int UPDATE_FRAME_COUNT = 1;

        public boolean converterException(Throwable var1);

        public void parsedFrame(int var1, Header var2);

        public void converterUpdate(int var1, int var2, int var3);

        public void decodedFrame(int var1, Header var2, Obuffer var3);

        public void readFrame(int var1, Header var2);
    }
}

