/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import javazoom.jl.converter.RiffFile;
import pers.XiaoShadiao.NMSLException;

public class WaveFile
extends RiffFile {
    private long pcm_data_offset = 0L;
    private int num_samples = 0;
    private RiffFile.RiffChunkHeader pcm_data = new RiffFile.RiffChunkHeader();
    public static final int MAX_WAVE_CHANNELS = 2;
    private WaveFormat_Chunk wave_format = new WaveFormat_Chunk();
    private static final NMSLException \u522e\u8d77\u5927\u98ce\u7684\u65f6\u5019 = new NMSLException("\u4dc0\u4980\u4df5\u26e3\u4deb\u4ddd\u2678\u4de0\u4df3\u4dd4\u2784\u4df7\u26ab\u4dec\u2780\u4dd5\u263b\ua659\u3f10\u276c\u3e80\u4de9\u4dcf\u2768\u274d\ua676\u26b4\u4de3\u4dcb\u4dd2\u4ddb\u4df5\u2687\ua68d");

    @Override
    public int Close() {
        int rc = 0;
        if (this.fmode == 1) {
            rc = this.Backpatch(this.pcm_data_offset, this.pcm_data, 8);
        }
        if (rc == 0) {
            rc = super.Close();
        }
        return rc;
    }

    public WaveFile() {
        this.pcm_data.ckID = WaveFile.FourCC("data");
        this.pcm_data.ckSize = 0;
        this.num_samples = 0;
    }

    public int WriteData(short[] data, int numData) {
        int extraBytes = numData * 2;
        this.pcm_data.ckSize += extraBytes;
        return super.Write(data, extraBytes);
    }

    public short BitsPerSample() {
        return this.wave_format.data.nBitsPerSample;
    }

    public int SamplingRate() {
        return this.wave_format.data.nSamplesPerSec;
    }

    public int NumSamples() {
        return this.num_samples;
    }

    public int OpenForWrite(String Filename, int SamplingRate, short BitsPerSample, short NumChannels) {
        byte[] theWave;
        if (Filename == null || BitsPerSample != 8 && BitsPerSample != 16 || NumChannels < 1 || NumChannels > 2) {
            return 4;
        }
        this.wave_format.data.Config(SamplingRate, BitsPerSample, NumChannels);
        int retcode = this.Open(Filename, 1);
        if (retcode == 0 && (retcode = this.Write(theWave = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            retcode = this.Write(this.wave_format.header, 8);
            retcode = this.Write(this.wave_format.data.wFormatTag, 2);
            retcode = this.Write(this.wave_format.data.nChannels, 2);
            retcode = this.Write(this.wave_format.data.nSamplesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nAvgBytesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nBlockAlign, 2);
            retcode = this.Write(this.wave_format.data.nBitsPerSample, 2);
            if (retcode == 0) {
                this.pcm_data_offset = this.CurrentFilePosition();
                retcode = this.Write(this.pcm_data, 8);
            }
        }
        return retcode;
    }

    @Override
    public long CurrentFilePosition() {
        return super.CurrentFilePosition();
    }

    public int OpenForWrite(String Filename, WaveFile OtherWave) {
        return this.OpenForWrite(Filename, OtherWave.SamplingRate(), OtherWave.BitsPerSample(), OtherWave.NumChannels());
    }

    public short NumChannels() {
        return this.wave_format.data.nChannels;
    }

    public class WaveFileSample {
        public short[] chan = new short[2];
        private static final NMSLException \u4f60\u62cd\u516b = new NMSLException("\u3839\u4dcb\u4dfe\u4de9\u26df\u4dd2\u4df9\u276a\u4dc1\u2746\u4df6\u44b2\u2764\ua69b\ua66d\u4dc2\u26cd\u27b8\u2764\u4dff\u4dd5\u4df5\u39c7\u4dc8\u4dd6\u269b\u275b\u4de4\u4df7\u4dc4\u2608\u4dcd\u267e\u2619\u4dc5\u4dfb\u4ddf\u4dfa\u4df4\u4df3\ua673\u4de8\u2796\u3dd5\u27a6");
    }

    class WaveFormat_Chunk {
        public WaveFormat_ChunkData data;
        public RiffFile.RiffChunkHeader header;
        private static final NMSLException \u8bba\u519b\u4e8b\u548c\u5386\u53f2 = new NMSLException("\ua64c\u3a8e\u4df8\u4de9\u4de6\u4de5\u409c\u4750\u27b7\u2798\u4df0\u3f27\u4dc0\u4dc0\u4dea\u2671\u2606\u277c\ua69d\u4dfc\u4df8\u4dc9\u4dec\u4dd6\u4dcd\u3516\u396e\u4de1\u2655\u4dc4\u274f\u4dea\u4ded\u4928\u3bdb\u4df2\ua66d\u4dea\u4dfa\u27be\u4def\u26f1\ua645\u4dd8\u2690\u2779\u4dce\u4de3");

        public WaveFormat_Chunk() {
            this.header = new RiffFile.RiffChunkHeader();
            this.data = new WaveFormat_ChunkData();
            this.header.ckID = RiffFile.FourCC("fmt ");
            this.header.ckSize = 16;
        }

        public int VerifyValidity() {
            boolean ret;
            boolean bl = ret = this.header.ckID == RiffFile.FourCC("fmt ") && (this.data.nChannels == 1 || this.data.nChannels == 2) && this.data.nAvgBytesPerSec == this.data.nChannels * this.data.nSamplesPerSec * this.data.nBitsPerSample / 8 && this.data.nBlockAlign == this.data.nChannels * this.data.nBitsPerSample / 8;
            if (ret) {
                return 1;
            }
            return 0;
        }
    }

    class WaveFormat_ChunkData {
        public short wFormatTag = 1;
        public short nBlockAlign = 0;
        public int nSamplesPerSec = 0;
        public short nBitsPerSample = 0;
        public short nChannels = 0;
        public int nAvgBytesPerSec = 0;
        private static final NMSLException \u4f46\u8fd8\u662f\u5f88\u62c5\u5fc3 = new NMSLException("\u4dcb\u2655\u4dca\u4dcb\u264a\u4dd6\ua686\u2727\u4dd4\u26f5\u3627\u265c\u4b9e\u387f\u2751\u4dc1\u354c\u4a70\u4ded\u4df6\u4def\u34c4\u4dd1\u4dca\u4dfd\ua64a\u4dd3\u42f5\u4ddf\u4dd8\u4de3\u26fa\u276c\u4ddf\u4de2\u4dcc\u4dd0\u276d\ua67c\u4dfa\u4de5\u4df7\u27b6\u4dc6\u4df8\u4d18\u4dc9");

        public void Config(int NewSamplingRate, short NewBitsPerSample, short NewNumChannels) {
            this.nSamplesPerSec = NewSamplingRate;
            this.nChannels = NewNumChannels;
            this.nBitsPerSample = NewBitsPerSample;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }

        public WaveFormat_ChunkData() {
            this.Config(44100, (short)16, (short)1);
        }
    }
}

