/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

final class BitReserve {
    private static final int BUFSIZE = 32768;
    private int buf_byte_idx = 0;
    private int offset = 0;
    private final int[] buf = new int[32768];
    private int totbit = 0;
    private static final int BUFSIZE_MASK = Short.MAX_VALUE;
    private int buf_bit_idx;
    private static final NMSLException \u660e\u5929\u89c1 = new NMSLException("\u2601\ua64b\u4dec\u4de7\ua66e\u4ddc\ua678\ua67e\u4ddb\u2694\u4de3\u2674\ua691\u44f1\u4dc2\u4df6\u4ddf\u4dc1\u4ddc\u4af4\u4df6\u48ef\ua664\u2601\u4dea\u270c\ua683\u4de6\ua678\u4dca\u4dee\u4787\u3fce\u2763\u4de8\u270e\u4dc3\u4dc1\u4dcf\u4dca\u359b\u26cc");

    public void hputbuf(int val) {
        int ofs = this.offset;
        this.buf[ofs++] = val & 0x80;
        this.buf[ofs++] = val & 0x40;
        this.buf[ofs++] = val & 0x20;
        this.buf[ofs++] = val & 0x10;
        this.buf[ofs++] = val & 8;
        this.buf[ofs++] = val & 4;
        this.buf[ofs++] = val & 2;
        this.buf[ofs++] = val & 1;
        this.offset = ofs == 32768 ? 0 : ofs;
    }

    public int hgetbits(int N) {
        this.totbit += N;
        int val = 0;
        int pos = this.buf_byte_idx;
        if (pos + N < 32768) {
            while (N-- > 0) {
                val <<= 1;
                val |= this.buf[pos++] != 0 ? 1 : 0;
            }
        } else {
            while (N-- > 0) {
                val <<= 1;
                val |= this.buf[pos] != 0 ? 1 : 0;
                pos = pos + 1 & Short.MAX_VALUE;
            }
        }
        this.buf_byte_idx = pos;
        return val;
    }

    BitReserve() {
    }

    public void rewindNbits(int N) {
        this.totbit -= N;
        this.buf_byte_idx -= N;
        if (this.buf_byte_idx < 0) {
            this.buf_byte_idx += 32768;
        }
    }

    public int hget1bit() {
        ++this.totbit;
        int val = this.buf[this.buf_byte_idx];
        this.buf_byte_idx = this.buf_byte_idx + 1 & Short.MAX_VALUE;
        return val;
    }

    public void rewindNbytes(int N) {
        int bits = N << 3;
        this.totbit -= bits;
        this.buf_byte_idx -= bits;
        if (this.buf_byte_idx < 0) {
            this.buf_byte_idx += 32768;
        }
    }

    public int hsstell() {
        return this.totbit;
    }
}

