/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private int outputChannels;
    private SynthesisFilter filter1;
    private LayerIDecoder l1decoder;
    private LayerIIIDecoder l3decoder;
    private Equalizer equalizer = new Equalizer();
    private SynthesisFilter filter2;
    private static final Params DEFAULT_PARAMS;
    private Obuffer output;
    private LayerIIDecoder l2decoder;
    private int outputFrequency;
    private Params params;
    private boolean initialized;
    private static final NMSLException \u5982\u679c\u6ca1\u6709\u4e07\u5343\u82f1\u96c4\u4e0e\u6c11\u4f17\u7684\u52aa\u529b;

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    static {
        \u5982\u679c\u6ca1\u6709\u4e07\u5343\u82f1\u96c4\u4e0e\u6c11\u4f17\u7684\u52aa\u529b = new NMSLException("\u3844\u4dcf\u4dd8\u2625\u376c\u2675\u2696\ua661\u4dc3\u4dea\ua659\u4dc8\u4dd2\u4de9\u2660\u4167\u4dec\u4dee\u4de1\u2782\u4282\u4dc6\u4dce\u2679\u4dd6\u268b\ua68b\u4df0\ua67c\ua67a");
        DEFAULT_PARAMS = new Params();
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    public Decoder() {
        this(null);
    }

    public static class Params
    implements Cloneable {
        private OutputChannels outputChannels = OutputChannels.BOTH;
        private Equalizer equalizer = new Equalizer();
        private static final NMSLException \u6211\u4eec\u559c\u6b22\u4f60 = new NMSLException("\u4dc2\u26d7\u27a8\u4dda\ua658\u3b10\u4df5\u4dfa\u26a7\u4530\u4df6\u49fd\u3493\u26d3\u3be5\u26fb\u27b3\u4de0\u4dd8\u2739\u4b83\ua648\u4de8\u4015\u2707\u4d93\ua683\u3d0d\u4ddb\u2768\u2703\u3a54\ua697\u2659\u4dd7\u4de1\u272d");

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }
    }
}

