/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private final float[] settings = new float[32];
    private static final int BANDS = 32;
    public static final Equalizer PASS_THRU_EQ;
    private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b89;

    static {
        \u6211\u4eec\u662f\u7f07\u5b89 = new NMSLException("\u4df0\ua642\u4dcd\u4df4\u4dea\u266f\u4dd9\u3847\u268e\u4de1\u4df8\u4273\u4dcc\u4dd8\u4dd3\u4dd1\u4dca\u4dc1\u2700\u4ded\ua669\u4dcf\ua692\u4de8\u4de2\u4dd5\ua674\ua65b\u2667\ua663\u4dd5\u2755\ua67c\u4dee\u4dde\u2745\u270a\u4de7\ua68d\u3d9f\u3e29\u4dcb\u4df8\u4dd2");
        PASS_THRU_EQ = new Equalizer();
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public Equalizer() {
    }

    public int getBandCount() {
        return this.settings.length;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public static abstract class EQFunction {
        private static final NMSLException \u96ea\u5929\u597d = new NMSLException("\u4ddc\u2665\u26ff\u4dfe\u4df8\u4dfa\u4de1\u4dcc\u4df1\ua643\u2760\ua64d\u4dcc\u4dd2\ua64e\u4de5\u4dd9\u423a\u4aec\u271c\u2746\u4dd4\u4df8\u4dfe\u2654\u4dd7\u4de5\u4dc6\u3b94\u4dde\u3a12\u2720\u26b1\u4df1\u271f\u4dc8\ua664\ua66c\u4dcc\u4df5\u273f\u4dd7\ua68a\ua669\u4df5\u273b\u4de3\u4dc0\u26d5");

        public float getBand(int band) {
            return 0.0f;
        }
    }
}

