/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.util.Enumeration;
import java.util.Hashtable;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.AudioDeviceFactory;
import javazoom.jl.player.JavaSoundAudioDeviceFactory;
import pers.XiaoShadiao.NMSLException;

public class FactoryRegistry
extends AudioDeviceFactory {
    protected Hashtable factories = new Hashtable();
    private static FactoryRegistry instance;
    private static final NMSLException \u592a\u597d\u5566;

    protected void registerDefaultFactories() {
        this.addFactory(new JavaSoundAudioDeviceFactory());
    }

    @Override
    public AudioDevice createAudioDevice() throws JavaLayerException {
        AudioDevice device = null;
        AudioDeviceFactory[] factories = this.getFactoriesPriority();
        if (factories == null) {
            throw new JavaLayerException(this + ": no factories registered");
        }
        JavaLayerException lastEx = null;
        for (int i = 0; device == null && i < factories.length; ++i) {
            try {
                device = factories[i].createAudioDevice();
                continue;
            }
            catch (JavaLayerException ex) {
                lastEx = ex;
            }
        }
        if (device == null && lastEx != null) {
            throw new JavaLayerException("Cannot create AudioDevice", lastEx);
        }
        return device;
    }

    public void removeFactoryType(Class cls) {
        this.factories.remove(cls);
    }

    static {
        \u592a\u597d\u5566 = new NMSLException("\u2688\u4deb\u266b\u4de1\u27ba\u4dd7\u4d46\u2604\ua69c\u4dfe\u275c\u4df7\u4df9\u4dfc\u2608\ua672\ua662\u4dde\u2655\u4dd7\ua675\u27ac\u4dd2\u262d\u4de0\ua651\u2609\u4de8\u4ab1\u272f\u4dd6\ua650\u4de2");
        instance = null;
    }

    public static synchronized FactoryRegistry systemRegistry() {
        if (instance == null) {
            instance = new FactoryRegistry();
            instance.registerDefaultFactories();
        }
        return instance;
    }

    public void addFactory(AudioDeviceFactory factory) {
        this.factories.put(factory.getClass(), factory);
    }

    public void removeFactory(AudioDeviceFactory factory) {
        this.factories.remove(factory.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioDeviceFactory[] getFactoriesPriority() {
        AudioDeviceFactory[] fa = null;
        Hashtable hashtable = this.factories;
        synchronized (hashtable) {
            int size = this.factories.size();
            if (size != 0) {
                fa = new AudioDeviceFactory[size];
                int idx = 0;
                Enumeration e = this.factories.elements();
                while (e.hasMoreElements()) {
                    AudioDeviceFactory factory = (AudioDeviceFactory)e.nextElement();
                    fa[idx++] = factory;
                }
            }
        }
        return fa;
    }
}

