/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import pers.XiaoShadiao.NMSLException;

public class Player {
    private int frame = 0;
    private int lastPosition = 0;
    private boolean complete = false;
    private boolean closed = false;
    private AudioDevice audio;
    private Decoder decoder;
    private Bitstream bitstream;
    private static final NMSLException \u4ec0\u4e48\u65f6\u5019\u80fd\u7ed3\u675f = new NMSLException("\u3987\u4dfa\u4dc6\ua681\u4df7\u4dd8\u3917\u4dde\u3da4\u2670\u2701\u4dca\u4dc9\u267d\u4ddb\u269b\u2729\u4df3\u4dcd\u2792\u271a\u2724\u4dd5\ua644\u26bd\ua699\u4de0\u4dc7\u4dca\u2662\u2788\u4df0\u4df1\ua67a\u4dda\u26a4\u4df5\u2779\u4de9\ua66b\u45d3\u4dd6\u4de1\u4dc4");

    public synchronized void close() {
        AudioDevice out = this.audio;
        if (out != null) {
            this.closed = true;
            this.audio = null;
            out.close();
            this.lastPosition = out.getPosition();
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    public Player(InputStream stream, AudioDevice device) throws JavaLayerException {
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
        if (device != null) {
            this.audio = device;
        } else {
            FactoryRegistry r = FactoryRegistry.systemRegistry();
            this.audio = r.createAudioDevice();
        }
        this.audio.open(this.decoder);
    }

    public Player(InputStream stream) throws JavaLayerException {
        this(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice out = this.audio;
            if (out == null) {
                return false;
            }
            Header h = this.bitstream.readFrame();
            if (h == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            Player player = this;
            synchronized (player) {
                out = this.audio;
                if (out != null) {
                    out.write(output.getBuffer(), 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
        }
        catch (RuntimeException ex) {
            throw new JavaLayerException("Exception decoding audio frame", ex);
        }
        return true;
    }

    public void play() throws JavaLayerException {
        this.play(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(int frames) throws JavaLayerException {
        AudioDevice out;
        boolean ret = true;
        while (frames-- > 0 && ret) {
            ret = this.decodeFrame();
        }
        if (!ret && (out = this.audio) != null) {
            out.flush();
            Player player = this;
            synchronized (player) {
                this.complete = !this.closed;
                this.close();
            }
        }
        return ret;
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    public int getPosition() {
        int position = this.lastPosition;
        AudioDevice out = this.audio;
        if (out != null) {
            position = out.getPosition();
        }
        return position;
    }
}

