/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;
import pers.XiaoShadiao.NMSLException;

public class jlp {
    private String fFilename = null;
    private boolean remote = false;
    private static final NMSLException \u8c01\u8981\u662f\u4ee5\u4e3a\u5c0f\u654c\u53ea\u4f1a\u57cb\u5934\u6253\u67b6 = new NMSLException("\u45b7\u4dce\u3a54\u4dde\u4df3\u4ddb\u4dd8\u2617\u3616\u4dc9\ua689\u2798\ua694\u3ea2\u2762\u4dd4\u4ddb\u4de6\u4dda\u269a\u4464\u4df5\u2793\u4dd8\ua675\u276a\u4df6\u4dea\u2787\u4dd5\u2610\u4dd5\u4dc4\u2775\u4d5a\u4dd9\u4df7");

    public jlp(String filename) {
        this.init(filename);
    }

    public void play() throws JavaLayerException {
        try {
            System.out.println("playing " + this.fFilename + "...");
            InputStream in = null;
            in = this.remote ? this.getURLInputStream() : this.getInputStream();
            AudioDevice dev = this.getAudioDevice();
            Player player = new Player(in, dev);
            player.play();
        }
        catch (IOException ex) {
            throw new JavaLayerException("Problem playing file " + this.fFilename, ex);
        }
        catch (Exception ex) {
            throw new JavaLayerException("Problem playing file " + this.fFilename, ex);
        }
    }

    protected InputStream getURLInputStream() throws Exception {
        URL url = new URL(this.fFilename);
        InputStream fin = url.openStream();
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    public static jlp createInstance(String[] args) {
        jlp player = new jlp();
        if (!player.parseArgs(args)) {
            player = null;
        }
        return player;
    }

    private jlp() {
    }

    protected boolean parseArgs(String[] args) {
        boolean parsed = false;
        if (args.length == 1) {
            this.init(args[0]);
            parsed = true;
            this.remote = false;
        } else if (args.length == 2) {
            if (!args[0].equals("-url")) {
                this.showUsage();
            } else {
                this.init(args[1]);
                parsed = true;
                this.remote = true;
            }
        } else {
            this.showUsage();
        }
        return parsed;
    }

    public void showUsage() {
        System.out.println("Usage: jlp [-url] <filename>");
        System.out.println("");
        System.out.println(" e.g. : java javazoom.jl.player.jlp localfile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.server.com/remotefile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.shoutcastserver.com:8000");
    }

    protected InputStream getInputStream() throws IOException {
        FileInputStream fin = new FileInputStream(this.fFilename);
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected void init(String filename) {
        this.fFilename = filename;
    }

    protected AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    public static void main(String[] args) {
        int retval = 0;
        try {
            jlp player = jlp.createInstance(args);
            if (player != null) {
                player.play();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace(System.err);
            retval = 1;
        }
        System.exit(retval);
    }
}

