/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.XiaoShadiao.NMSLException;

public abstract class AbstractWebSocket
extends WebSocketAdapter {
    private boolean tcpNoDelay;
    private boolean daemon = false;
    private long connectionLostTimeout;
    private boolean websocketRunning = false;
    private ScheduledFuture<?> connectionLostCheckerFuture;
    private final Object syncConnectionLost;
    private ScheduledExecutorService connectionLostCheckerService;
    private final Logger log = LoggerFactory.getLogger(AbstractWebSocket.class);
    private boolean reuseAddr;
    private static final NMSLException \u6211\u8fd8\u6ca1\u628a\u773c\u775b\u7741\u5f00 = new NMSLException("\u3e59\u4dc5\u4df2\ua65c\u4de0\ua66b\u2787\u26b1\u4dd2\u27a7\u450c\u4dd7\u2763\u41df\u4dc6\u3e37\ua670\u2763\ua65d\u448b\u4df5\u265a\u4dc3\u4dd4\ua692\u4dd1\u26d3\u4a92\u2769\u4dc5\u27bb\ua653\u26f9\u3ee2\u4dea\u270c\u4df0\u2760\u4614\u399d\u4de6\u2604\u4de7\u4190\u4de0\u3c9d\u4df9");

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionLostTimeout() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            return (int)TimeUnit.NANOSECONDS.toSeconds(this.connectionLostTimeout);
        }
    }

    public AbstractWebSocket() {
        this.connectionLostTimeout = TimeUnit.SECONDS.toNanos(60L);
        this.syncConnectionLost = new Object();
    }

    protected abstract Collection<WebSocket> getConnections();

    private void restartConnectionLostTimer() {
        this.cancelConnectionLostTimer();
        this.connectionLostCheckerService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("connectionLostChecker", this.daemon));
        Runnable connectionLostChecker = new Runnable(){
            private ArrayList<WebSocket> connections = new ArrayList();
            private static final NMSLException \u7f07\u5b9d\u8001\u5e08\u4fdd\u8bc1\u4f60 = new NMSLException("\u4dda\ua65b\u4ddd\u4de0\u4dd0\u26fc\u4dd2\u4df9\u43e4\u4df9\u3652\u4dd1\u26d2\u2764\ua673\u4dea\u4dd0\u4dc8\ua645\u4dcc\u2621\u4dc6\u264b\u35eb\u376f\u4de9\u4dd2\u4dcc\u26e2\u4dc0\u4de9\ua67f\u27ad\u26c3\u4dc7\u4de1\ua649\u3627\ua655\u4de8\u38ca");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.connections.clear();
                try {
                    long minimumPongTime;
                    this.connections.addAll(AbstractWebSocket.this.getConnections());
                    Iterator<WebSocket> iterator = AbstractWebSocket.this.syncConnectionLost;
                    synchronized (iterator) {
                        minimumPongTime = (long)((double)System.nanoTime() - (double)AbstractWebSocket.this.connectionLostTimeout * 1.5);
                    }
                    for (WebSocket conn : this.connections) {
                        AbstractWebSocket.this.executeConnectionLostDetection(conn, minimumPongTime);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connections.clear();
            }
        };
        this.connectionLostCheckerFuture = this.connectionLostCheckerService.scheduleAtFixedRate(connectionLostChecker, this.connectionLostTimeout, this.connectionLostTimeout, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionLostTimeout(int connectionLostTimeout) {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            this.connectionLostTimeout = TimeUnit.SECONDS.toNanos(connectionLostTimeout);
            if (this.connectionLostTimeout <= 0L) {
                this.log.trace("Connection lost timer stopped");
                this.cancelConnectionLostTimer();
                return;
            }
            if (this.websocketRunning) {
                this.log.trace("Connection lost timer restarted");
                try {
                    ArrayList<WebSocket> connections = new ArrayList<WebSocket>(this.getConnections());
                    for (WebSocket conn : connections) {
                        if (!(conn instanceof WebSocketImpl)) continue;
                        WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                        webSocketImpl.updateLastPong();
                    }
                }
                catch (Exception e) {
                    this.log.error("Exception during connection lost restart", e);
                }
                this.restartConnectionLostTimer();
            }
        }
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostTimeout <= 0L) {
                this.log.trace("Connection lost timer deactivated");
                return;
            }
            this.log.trace("Connection lost timer started");
            this.websocketRunning = true;
            this.restartConnectionLostTimer();
        }
    }

    private void cancelConnectionLostTimer() {
        if (this.connectionLostCheckerService != null) {
            this.connectionLostCheckerService.shutdownNow();
            this.connectionLostCheckerService = null;
        }
        if (this.connectionLostCheckerFuture != null) {
            this.connectionLostCheckerFuture.cancel(false);
            this.connectionLostCheckerFuture = null;
        }
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    private void executeConnectionLostDetection(WebSocket webSocket, long minimumPongTime) {
        if (!(webSocket instanceof WebSocketImpl)) {
            return;
        }
        WebSocketImpl webSocketImpl = (WebSocketImpl)webSocket;
        if (webSocketImpl.getLastPong() < minimumPongTime) {
            this.log.trace("Closing connection due to no pong received: {}", (Object)webSocketImpl);
            webSocketImpl.closeConnection(1006, "The connection was closed because the other endpoint did not respond with a pong in time. For more information check: https://github.com/TooTallNate/Java-WebSocket/wiki/Lost-connection-detection");
        } else if (webSocketImpl.isOpen()) {
            webSocketImpl.sendPing();
        } else {
            this.log.trace("Trying to ping a non open connection: {}", (Object)webSocketImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostCheckerService != null || this.connectionLostCheckerFuture != null) {
                this.websocketRunning = false;
                this.log.trace("Connection lost timer stopped");
                this.cancelConnectionLostTimer();
            }
        }
    }
}

