/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.enums.Role;
import pers.XiaoShadiao.NMSLException;

public class SocketChannelIOHelper {
    private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b89 = new NMSLException("\u4dc9\u4de4\u4df1\ua667\u4dd6\u4d80\u270b\u4df6\u4c83\u4dc4\u4dfb\u270c\u4de6\u4de8\u4dfb\ua647\u4282\u4de4\u4ddd\u4df3\u2638\u4dd4\u4de5\u26f3\ua65d\u2794\u270f\u2699\u4ded\u26ac\u4df4\u4de8\u2752\ua64b\u4dcd\u4dd5\u3eae\u27b7\u4b7d\u2753\u4dc2");

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws, WrappedByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.readMore(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return channel.isNeedRead();
    }

    private SocketChannelIOHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean batch(WebSocketImpl ws, ByteChannel sockchannel) throws IOException {
        if (ws == null) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)ws.outQueue.peek();
        WrappedByteChannel c = null;
        if (buffer == null) {
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws.outQueue.peek()) != null);
        }
        if (ws.outQueue.isEmpty() && ws.isFlushAndClose() && ws.getDraft() != null && ws.getDraft().getRole() != null && ws.getDraft().getRole() == Role.SERVER) {
            ws.closeConnection();
        }
        return c == null || !((WrappedByteChannel)sockchannel).isNeedWrite();
    }

    public static boolean read(ByteBuffer buf, WebSocketImpl ws, ByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.read(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return read != 0;
    }
}

