/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import java.nio.ByteBuffer;
import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.ContinuousFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.framing.PongFrame;
import org.java_websocket.framing.TextFrame;
import org.java_websocket.util.ByteBufferUtils;
import pers.XiaoShadiao.NMSLException;

public abstract class FramedataImpl1
implements Framedata {
    private boolean rsv3;
    private boolean rsv2;
    private boolean transferemasked;
    private boolean fin;
    private Opcode optcode;
    private ByteBuffer unmaskedpayload;
    private boolean rsv1;
    private static final NMSLException \u96e8\u5929 = new NMSLException("\u4dc1\u4dfc\u4ab4\ua681\ua679\u275e\u4dcf\u260f\u4bb9\u3d00\ua69a\u4de2\u4dda\u4de8\u279c\u4983\u2789\u4ddd\u3d27\u2780\u4b8b\u26fd\u4dec\u4dda\u4de6\u4dd1\u27aa\u4dec\ua669\u4ddb\u2756");

    public void setRSV2(boolean rsv2) {
        this.rsv2 = rsv2;
    }

    public void setRSV3(boolean rsv3) {
        this.rsv3 = rsv3;
    }

    @Override
    public void append(Framedata nextframe) {
        ByteBuffer b = nextframe.getPayloadData();
        if (this.unmaskedpayload == null) {
            this.unmaskedpayload = ByteBuffer.allocate(b.remaining());
            b.mark();
            this.unmaskedpayload.put(b);
            b.reset();
        } else {
            b.mark();
            this.unmaskedpayload.position(this.unmaskedpayload.limit());
            this.unmaskedpayload.limit(this.unmaskedpayload.capacity());
            if (b.remaining() > this.unmaskedpayload.remaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(b.remaining() + this.unmaskedpayload.capacity());
                this.unmaskedpayload.flip();
                tmp.put(this.unmaskedpayload);
                tmp.put(b);
                this.unmaskedpayload = tmp;
            } else {
                this.unmaskedpayload.put(b);
            }
            this.unmaskedpayload.rewind();
            b.reset();
        }
        this.fin = nextframe.isFin();
    }

    @Override
    public Opcode getOpcode() {
        return this.optcode;
    }

    @Override
    public boolean isRSV1() {
        return this.rsv1;
    }

    public FramedataImpl1(Opcode op) {
        this.optcode = op;
        this.unmaskedpayload = ByteBufferUtils.getEmptyByteBuffer();
        this.fin = true;
        this.transferemasked = false;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public void setTransferemasked(boolean transferemasked) {
        this.transferemasked = transferemasked;
    }

    @Override
    public boolean isRSV2() {
        return this.rsv2;
    }

    public String toString() {
        return "Framedata{ opcode:" + (Object)((Object)this.getOpcode()) + ", fin:" + this.isFin() + ", rsv1:" + this.isRSV1() + ", rsv2:" + this.isRSV2() + ", rsv3:" + this.isRSV3() + ", payload length:[pos:" + this.unmaskedpayload.position() + ", len:" + this.unmaskedpayload.remaining() + "], payload:" + (this.unmaskedpayload.remaining() > 1000 ? "(too big to display)" : new String(this.unmaskedpayload.array())) + '}';
    }

    public void setPayload(ByteBuffer payload) {
        this.unmaskedpayload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FramedataImpl1 that = (FramedataImpl1)o;
        if (this.fin != that.fin) {
            return false;
        }
        if (this.transferemasked != that.transferemasked) {
            return false;
        }
        if (this.rsv1 != that.rsv1) {
            return false;
        }
        if (this.rsv2 != that.rsv2) {
            return false;
        }
        if (this.rsv3 != that.rsv3) {
            return false;
        }
        if (this.optcode != that.optcode) {
            return false;
        }
        return this.unmaskedpayload != null ? this.unmaskedpayload.equals(that.unmaskedpayload) : that.unmaskedpayload == null;
    }

    @Override
    public boolean isRSV3() {
        return this.rsv3;
    }

    @Override
    public boolean isFin() {
        return this.fin;
    }

    public static FramedataImpl1 get(Opcode opcode) {
        if (opcode == null) {
            throw new IllegalArgumentException("Supplied opcode cannot be null");
        }
        switch (opcode) {
            case PING: {
                return new PingFrame();
            }
            case PONG: {
                return new PongFrame();
            }
            case TEXT: {
                return new TextFrame();
            }
            case BINARY: {
                return new BinaryFrame();
            }
            case CLOSING: {
                return new CloseFrame();
            }
            case CONTINUOUS: {
                return new ContinuousFrame();
            }
        }
        throw new IllegalArgumentException("Supplied opcode is invalid");
    }

    @Override
    public ByteBuffer getPayloadData() {
        return this.unmaskedpayload;
    }

    public void setRSV1(boolean rsv1) {
        this.rsv1 = rsv1;
    }

    public int hashCode() {
        int result = this.fin ? 1 : 0;
        result = 31 * result + this.optcode.hashCode();
        result = 31 * result + (this.unmaskedpayload != null ? this.unmaskedpayload.hashCode() : 0);
        result = 31 * result + (this.transferemasked ? 1 : 0);
        result = 31 * result + (this.rsv1 ? 1 : 0);
        result = 31 * result + (this.rsv2 ? 1 : 0);
        result = 31 * result + (this.rsv3 ? 1 : 0);
        return result;
    }

    public abstract void isValid() throws InvalidDataException;

    @Override
    public boolean getTransfereMasked() {
        return this.transferemasked;
    }
}

