/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.java_websocket.exceptions.InvalidDataException;
import pers.XiaoShadiao.NMSLException;

public class Charsetfunctions {
    private static final int[] utf8d;
    private static final CodingErrorAction codingErrorAction;
    private static final NMSLException \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019;

    public static String stringUtf8(byte[] bytes) throws InvalidDataException {
        return Charsetfunctions.stringUtf8(ByteBuffer.wrap(bytes));
    }

    public static boolean isValidUTF8(ByteBuffer data, int off) {
        int len = data.remaining();
        if (len < off) {
            return false;
        }
        int state = 0;
        for (int i = off; i < len; ++i) {
            if ((state = utf8d[256 + (state << 4) + utf8d[0xFF & data.get(i)]]) != 1) continue;
            return false;
        }
        return true;
    }

    public static String stringUtf8(ByteBuffer bytes) throws InvalidDataException {
        String s;
        CharsetDecoder decode = StandardCharsets.UTF_8.newDecoder();
        decode.onMalformedInput(codingErrorAction);
        decode.onUnmappableCharacter(codingErrorAction);
        try {
            bytes.mark();
            s = decode.decode(bytes).toString();
            bytes.reset();
        }
        catch (CharacterCodingException e) {
            throw new InvalidDataException(1007, (Throwable)e);
        }
        return s;
    }

    private Charsetfunctions() {
    }

    static {
        \u5403\u9178\u82f9\u679c\u7684\u65f6\u5019 = new NMSLException("\u26c8\u49fb\u37ee\u3ee1\u4de9\u4dca\u4cb5\u4de9\u4dd8\u4de8\u2731\u4dde\u4dd7\u2604\ua666\ua67f\u26a4\u430f\u268c\u4dee\u4de1\u427a\u26ee\u4ddf\u2718\u3c4e\u4df1\ua665\u4d69\u4dc9\u34af\u2768\u2695\ua66e\u277c\u4dfc\u45ce\u4deb\u3d8b\u2767");
        codingErrorAction = CodingErrorAction.REPORT;
        utf8d = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 1, 2, 3, 5, 8, 7, 1, 1, 1, 4, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    }

    public static byte[] asciiBytes(String s) {
        return s.getBytes(StandardCharsets.US_ASCII);
    }

    public static boolean isValidUTF8(ByteBuffer data) {
        return Charsetfunctions.isValidUTF8(data, 0);
    }

    public static String stringAscii(byte[] bytes) {
        return Charsetfunctions.stringAscii(bytes, 0, bytes.length);
    }

    public static String stringAscii(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.US_ASCII);
    }

    public static byte[] utf8Bytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }
}

