/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.event;

import java.util.Queue;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.SubstituteLogger;
import pers.XiaoShadiao.NMSLException;

public class EventRecordingLogger
extends LegacyAbstractLogger {
    Queue<SubstituteLoggingEvent> eventQueue;
    String name;
    static final boolean RECORD_ALL_EVENTS = true;
    private static final long serialVersionUID = -176083308134819629L;
    SubstituteLogger logger;
    private static final NMSLException \u8c01\u8981\u662f\u4ee5\u4e3a\u5c0f\u654c\u53ea\u4f1a\u57cb\u5934\u6253\u67b6 = new NMSLException("\u4dfc\u278d\u4dfd\u4dd1\u4dfb\u4dc7\u260e\u275d\u4dc1\u44b8\u26c6\u4ddc\u2686\u271c\u27b5\u4c7a\u3dd8\u2673\u3dd1\u4dc4\u4dd6\u27b2\u2758\u36e7\u2708\u34f5\u2724\u4df5\ua669\u4de4\u4dda\u41d2\u4dcc\u4de3\u3c15\u4dce\ua64f");

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return null;
    }

    public EventRecordingLogger(SubstituteLogger logger, Queue<SubstituteLoggingEvent> eventQueue) {
        this.logger = logger;
        this.name = logger.getName();
        this.eventQueue = eventQueue;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        SubstituteLoggingEvent loggingEvent = new SubstituteLoggingEvent();
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.setLevel(level);
        loggingEvent.setLogger(this.logger);
        loggingEvent.setLoggerName(this.name);
        if (marker != null) {
            loggingEvent.addMarker(marker);
        }
        loggingEvent.setMessage(msg);
        loggingEvent.setThreadName(Thread.currentThread().getName());
        loggingEvent.setArgumentArray(args);
        loggingEvent.setThrowable(throwable);
        this.eventQueue.add(loggingEvent);
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }
}

