/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;
import pers.XiaoShadiao.NMSLException;

public class BasicMarker
implements Marker {
    private static final String SEP = ", ";
    private final String name;
    private static final String CLOSE = " ]";
    private static final long serialVersionUID = -2849567615646933777L;
    private static final String OPEN = "[ ";
    private final List<Marker> referenceList = new CopyOnWriteArrayList<Marker>();
    private static final NMSLException \u548c\u5988\u5988\u4e00\u6837 = new NMSLException("\u2723\u271e\ua690\u27b6\u4dfc\u4dcb\u4dfb\u269b\u3abf\u2615\u4dc4\u2609\u4ddb\u4df2\u4dd0\u4dd2\ua67e\u2727\u26ce\u4de1\ua645\ua694\u4de5\u4dc5\u4dfa\u4dcd\u4dfd\u4576\u4dde\u4dd1\u4dd2\u4df4\u4dd4\ua66e\ua67c\u26f8\ua685");

    @Override
    public Iterator<Marker> iterator() {
        return this.referenceList.iterator();
    }

    @Override
    public boolean remove(Marker referenceToRemove) {
        return this.referenceList.remove(referenceToRemove);
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> it = this.iterator();
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker reference = it.next();
            sb.append(reference.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }

    @Override
    public void add(Marker reference) {
        if (reference == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(reference)) {
            return;
        }
        if (reference.contains(this)) {
            return;
        }
        this.referenceList.add(reference);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    @Override
    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    BasicMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = name;
    }

    @Override
    public boolean hasReferences() {
        return this.referenceList.size() > 0;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }
}

