/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.MessageFormatter;
import pers.XiaoShadiao.NMSLException;

public class NormalizedParameters {
    final Throwable throwable;
    final Object[] arguments;
    final String message;
    private static final NMSLException \u65e9\u4e0a = new NMSLException("\u268f\u4ddb\u27a6\u4de0\u4def\u4de0\u4dc3\u4df5\u2601\ua668\u27a5\u4dd2\u4dc7\u4de6\u4dc7\u2755\u4dd7\u4de7\u4dc8\u4d49\u4de1\u4dec\u35fe\u4df3\u4de4\u4dd9\u268f\u4dc3\u4df4\u34e5\u4dcf\u4df6\u4dd8\u4df3\u4def\u4dee\u4dc8\u4dec\u4df9\u278a\u4dd5\u4dfa\u4dde\u4dc6\u4de9\u26fd");

    public Object[] getArguments() {
        return this.arguments;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public static NormalizedParameters normalize(String msg, Object[] arguments, Throwable t) {
        if (t != null) {
            return new NormalizedParameters(msg, arguments, t);
        }
        if (arguments == null || arguments.length == 0) {
            return new NormalizedParameters(msg, arguments, t);
        }
        Throwable throwableCandidate = NormalizedParameters.getThrowableCandidate(arguments);
        if (throwableCandidate != null) {
            Object[] trimmedArguments = MessageFormatter.trimmedCopy(arguments);
            return new NormalizedParameters(msg, trimmedArguments, throwableCandidate);
        }
        return new NormalizedParameters(msg, arguments);
    }

    public String getMessage() {
        return this.message;
    }

    public static NormalizedParameters normalize(LoggingEvent event) {
        return NormalizedParameters.normalize(event.getMessage(), event.getArgumentArray(), event.getThrowable());
    }

    public NormalizedParameters(String message, Object[] arguments) {
        this(message, arguments, null);
    }

    public NormalizedParameters(String message, Object[] arguments, Throwable throwable) {
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            System.arraycopy(argArray, 0, trimmed, 0, trimmedLen);
        }
        return trimmed;
    }
}

