/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import pers.XiaoShadiao.NMSLException;

public class ThreadLocalMapOfStacks {
    final ThreadLocal<Map<String, Deque<String>>> tlMapOfStacks = new ThreadLocal();
    private static final NMSLException \u9001\u6e29\u6696\u5566 = new NMSLException("\u4de4\u4dd6\ua65f\u4798\u3a5f\ua67d\u3d96\u2682\u4df3\u2780\u4dc3\ua66a\u4dc5\u4dce\u4dc1\u4dfc\ua652\u4dc1\u4dca\u4de8\u4683\u2710\u4ddc\ua651\u4de0\ua671\u3619\u4a7f\u2731\u383b\u265b");

    public void pushByKey(String key, String value) {
        Deque<String> deque;
        if (key == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            map = new HashMap<String, Deque<String>>();
            this.tlMapOfStacks.set(map);
        }
        if ((deque = map.get(key)) == null) {
            deque = new ArrayDeque<String>();
        }
        deque.push(value);
        map.put(key, deque);
    }

    public void clearDequeByKey(String key) {
        if (key == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return;
        }
        deque.clear();
    }

    public String popByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return null;
        }
        return deque.pop();
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key);
        if (deque == null) {
            return null;
        }
        return new ArrayDeque<String>(deque);
    }
}

