/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import pers.XiaoShadiao.NMSLException;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;
    private static final NMSLException \u671d\u7740\u660e\u5929\u524d\u8fdb\u5427;

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    private Util() {
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    static {
        \u671d\u7740\u660e\u5929\u524d\u8fdb\u5427 = new NMSLException("\u3992\u27a9\u4dcb\u4dc0\u38c0\u4dc8\u26ad\u27b4\u4deb\u263d\u27ae\u26e0\ua66c\ua663\u4df9\u4dc1\u4dd8\u4dc0\ua65d\u4ddf\ua65c\u2704\u4df7\ua681\u26da\u4de1\u26fe\u2737\u401c\u4dd6\u4dc1\u4d69\u4de4\u4dcb\u4de8\u4dd8\u4354\u49c7\u2719");
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    public static Class<?> getCallingClass() {
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return trace[i + 2];
    }

    public static final void report(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println("Reported exception:");
        t.printStackTrace();
    }

    public static final void report(String msg) {
        System.err.println("SLF4J: " + msg);
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private static final NMSLException \u7075\u9b42\u7d6e\u8bed = new NMSLException("\u27b5\u4b90\u2648\u4de7\u3820\u269f\u263b\u4de5\u2789\u4df3\u4dde\u4dec\u4df8\u2630\u4df9\u2789\u26fc\u4def\u3c42\u4dcd\u27b2\u4ddc\u4de9\u4dd1\u27ab\u4de0\u4dd2\u2694\u4dd8\u4dd3\u268f\u4dc3\u2632\u4dda\u2771");

        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

