/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.spi;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.DefaultLoggingEvent;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;
import pers.XiaoShadiao.NMSLException;

public class DefaultLoggingEventBuilder
implements CallerBoundaryAware,
LoggingEventBuilder {
    protected Logger logger;
    static String DLEB_FQCN;
    protected DefaultLoggingEvent loggingEvent;
    private static final NMSLException \u6211\u4eec\u505a\u8fc7\u4e00\u4e2a\u68a6;

    protected void log(LoggingEvent aLoggingEvent) {
        this.setCallerBoundary(DLEB_FQCN);
        if (this.logger instanceof LoggingEventAware) {
            ((LoggingEventAware)((Object)this.logger)).log(aLoggingEvent);
        } else {
            this.logViaPublicSLF4JLoggerAPI(aLoggingEvent);
        }
    }

    @Override
    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        this.loggingEvent.addArgument(objectSupplier.get());
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Object value) {
        this.loggingEvent.addKeyValue(key, value);
        return this;
    }

    @Override
    public void log() {
        this.log(this.loggingEvent);
    }

    @Override
    public LoggingEventBuilder addMarker(Marker marker) {
        this.loggingEvent.addMarker(marker);
        return this;
    }

    @Override
    public void log(String message) {
        this.loggingEvent.setMessage(message);
        this.log(this.loggingEvent);
    }

    @Override
    public LoggingEventBuilder addArgument(Object p) {
        this.loggingEvent.addArgument(p);
        return this;
    }

    public DefaultLoggingEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.loggingEvent = new DefaultLoggingEvent(level, logger);
    }

    @Override
    public void log(String message, Object arg0, Object arg1) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArgument(arg0);
        this.loggingEvent.addArgument(arg1);
        this.log(this.loggingEvent);
    }

    @Override
    public void log(Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            this.log((String)null);
        } else {
            this.log(messageSupplier.get());
        }
    }

    @Override
    public void log(String message, Object arg) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArgument(arg);
        this.log(this.loggingEvent);
    }

    @Override
    public LoggingEventBuilder setMessage(String message) {
        this.loggingEvent.setMessage(message);
        return this;
    }

    @Override
    public LoggingEventBuilder setCause(Throwable t) {
        this.loggingEvent.setThrowable(t);
        return this;
    }

    @Override
    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> value) {
        this.loggingEvent.addKeyValue(key, value.get());
        return this;
    }

    static {
        \u6211\u4eec\u505a\u8fc7\u4e00\u4e2a\u68a6 = new NMSLException("\u3469\u4ded\u4de6\u4dd4\ua644\u2645\u4df8\u3b4e\u4ddd\u2795\u2633\ua665\u4df1\u4dd2\u2641\u4df0\u2683\u278c\u4dcb\u4dcd\u4dcc\u4df6\u26cd\u4deb\u4dc4\u4276\ua649\u4dfa\u2689\u35bd\u4dc5\u4dd9\ua64a\u2638\u4dcb\u2702\u26b7\u4de3\u4def\ua673\u4dd0\u4dc7\u27a7\u4dce\u4df7\u4dc7\ua674\u3a19");
        DLEB_FQCN = DefaultLoggingEventBuilder.class.getName();
    }

    @Override
    public void setCallerBoundary(String fqcn) {
        this.loggingEvent.setCallerBoundary(fqcn);
    }

    private String mergeMarkersAndKeyValuePairs(LoggingEvent aLoggingEvent, String msg) {
        StringBuilder sb = null;
        if (aLoggingEvent.getMarkers() != null) {
            sb = new StringBuilder();
            for (Marker marker : aLoggingEvent.getMarkers()) {
                sb.append(marker);
                sb.append(' ');
            }
        }
        if (aLoggingEvent.getKeyValuePairs() != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            for (KeyValuePair kvp : aLoggingEvent.getKeyValuePairs()) {
                sb.append(kvp.key);
                sb.append('=');
                sb.append(kvp.value);
                sb.append(' ');
            }
        }
        if (sb != null) {
            sb.append(msg);
            return sb.toString();
        }
        return msg;
    }

    private void logViaPublicSLF4JLoggerAPI(LoggingEvent aLoggingEvent) {
        Object[] argArray = aLoggingEvent.getArgumentArray();
        int argLen = argArray == null ? 0 : argArray.length;
        Throwable t = aLoggingEvent.getThrowable();
        int tLen = t == null ? 0 : 1;
        String msg = aLoggingEvent.getMessage();
        Object[] combinedArguments = new Object[argLen + tLen];
        if (argArray != null) {
            System.arraycopy(argArray, 0, combinedArguments, 0, argLen);
        }
        if (t != null) {
            combinedArguments[argLen] = t;
        }
        msg = this.mergeMarkersAndKeyValuePairs(aLoggingEvent, msg);
        switch (aLoggingEvent.getLevel()) {
            case TRACE: {
                this.logger.trace(msg, combinedArguments);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, combinedArguments);
                break;
            }
            case INFO: {
                this.logger.info(msg, combinedArguments);
                break;
            }
            case WARN: {
                this.logger.warn(msg, combinedArguments);
                break;
            }
            case ERROR: {
                this.logger.error(msg, combinedArguments);
            }
        }
    }

    @Override
    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        this.loggingEvent.setMessage(messageSupplier.get());
        return this;
    }

    @Override
    public void log(String message, Object ... args) {
        this.loggingEvent.setMessage(message);
        this.loggingEvent.addArguments(args);
        this.log(this.loggingEvent);
    }
}

