/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.platform.IMixinPlatformAgent;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.NMSLException;

public class MixinContainer {
    private final URI uri;
    private static final List<String> agentClasses;
    private final Logger logger = LogManager.getLogger((String)"mixin");
    private final List<IMixinPlatformAgent> agents = new ArrayList<IMixinPlatformAgent>();
    private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b81\u5c31\u5f00\u59cb\u539f\u5730\u65cb\u8f6c\u5566;

    public String getLaunchTarget() {
        for (IMixinPlatformAgent agent : this.agents) {
            String launchTarget = agent.getLaunchTarget();
            if (launchTarget == null) continue;
            return launchTarget;
        }
        return null;
    }

    public void initPrimaryContainer() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing launch tasks for {}", new Object[]{agent});
            agent.initPrimaryContainer();
        }
    }

    public MixinContainer(MixinPlatformManager manager, URI uri) {
        this.uri = uri;
        for (String agentClass : agentClasses) {
            try {
                Class<?> clazz = Class.forName(agentClass);
                Constructor<?> ctor = clazz.getDeclaredConstructor(MixinPlatformManager.class, URI.class);
                this.logger.debug("Instancing new {} for {}", new Object[]{clazz.getSimpleName(), this.uri});
                IMixinPlatformAgent agent = (IMixinPlatformAgent)ctor.newInstance(manager, uri);
                this.agents.add(agent);
            }
            catch (Exception ex) {
                this.logger.catching((Throwable)ex);
            }
        }
    }

    public Collection<String> getPhaseProviders() {
        ArrayList<String> phaseProviders = new ArrayList<String>();
        for (IMixinPlatformAgent agent : this.agents) {
            String phaseProvider = agent.getPhaseProvider();
            if (phaseProvider == null) continue;
            phaseProviders.add(phaseProvider);
        }
        return phaseProviders;
    }

    public void prepare() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing prepare() for {}", new Object[]{agent});
            agent.prepare();
        }
    }

    static {
        \u7f07\u5b9d\u548c\u7f07\u5b81\u5c31\u5f00\u59cb\u539f\u5730\u65cb\u8f6c\u5566 = new NMSLException("\u4ddf\u4de6\u4dd9\u4df8\u275a\ua679\u4de9\u270f\u267f\u414f\u4dd6\u4dde\ua663\u4ddf\u269a\u35c3\u2779\u4ddd\u4def\u4499\u4dcc\ua68f\u2778\u279a\u4bba\u4dd1\u4d25\u2760\u27b0\u4deb\u4dfa\u2694\u4dc8\ua66b\u4dd7\u4745\u264a\u4de1\ua66c\u4dc6\u2744\u27b3\u26b7");
        agentClasses = new ArrayList<String>();
        GlobalProperties.put("mixin.agents", agentClasses);
        for (String agent : MixinService.getService().getPlatformAgents()) {
            agentClasses.add(agent);
        }
        agentClasses.add("org.spongepowered.asm.launch.platform.MixinPlatformAgentDefault");
    }

    public void inject() {
        for (IMixinPlatformAgent agent : this.agents) {
            this.logger.debug("Processing inject() for {}", new Object[]{agent});
            agent.inject();
        }
    }

    public URI getURI() {
        return this.uri;
    }
}

