/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.ByteVector;
import pers.XiaoShadiao.NMSLException;

public class TypePath {
    byte[] b;
    int offset;
    public static final int ARRAY_ELEMENT = 0;
    public static final int WILDCARD_BOUND = 2;
    public static final int TYPE_ARGUMENT = 3;
    public static final int INNER_TYPE = 1;
    private static final NMSLException \u4f60\u62cd\u56db = new NMSLException("\u4de3\u4dc8\u4dd5\u4055\u4de8\u4de9\u4dfa\u2762\u4df0\u4de8\u4de9\ua690\u2604\u4dd5\ua671\u4dc9\u273d\u4dcd\ua64a\u4dc6\u4585\u4dff\ua65c\ua698\u4de3\u4dc1\u268d\u4dd9\u4dde\u266d\u4dc2\u4dc0\u2627\ua64c\u2622\u4dc8");

    public String toString() {
        int length = this.getLength();
        StringBuilder result = new StringBuilder(length * 2);
        block6: for (int i = 0; i < length; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    result.append('[');
                    continue block6;
                }
                case 1: {
                    result.append('.');
                    continue block6;
                }
                case 2: {
                    result.append('*');
                    continue block6;
                }
                case 3: {
                    result.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    result.append('_');
                }
            }
        }
        return result.toString();
    }

    public static TypePath fromString(String typePath) {
        if (typePath == null || typePath.length() == 0) {
            return null;
        }
        int n = typePath.length();
        ByteVector out = new ByteVector(n);
        out.putByte(0);
        int i = 0;
        while (i < n) {
            char c;
            if ((c = typePath.charAt(i++)) == '[') {
                out.put11(0, 0);
                continue;
            }
            if (c == '.') {
                out.put11(1, 0);
                continue;
            }
            if (c == '*') {
                out.put11(2, 0);
                continue;
            }
            if (c < '0' || c > '9') continue;
            int typeArg = c - 48;
            while (i < n && (c = typePath.charAt(i)) >= '0' && c <= '9') {
                typeArg = typeArg * 10 + c - 48;
                ++i;
            }
            if (i < n && typePath.charAt(i) == ';') {
                ++i;
            }
            out.put11(3, typeArg);
        }
        out.data[0] = (byte)(out.length / 2);
        return new TypePath(out.data, 0);
    }

    TypePath(byte[] b, int offset) {
        this.b = b;
        this.offset = offset;
    }

    public int getLength() {
        return this.b[this.offset];
    }

    public int getStepArgument(int index) {
        return this.b[this.offset + 2 * index + 2];
    }

    public int getStep(int index) {
        return this.b[this.offset + 2 * index + 1];
    }
}

